/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ObjUrl_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'elink.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef elink__OBJTOOLS_EUTILS_ELINK_OBJURL_BASE_HPP
#define elink__OBJTOOLS_EUTILS_ELINK_OBJURL_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

#ifndef BEGIN_elink_SCOPE
#  define BEGIN_elink_SCOPE BEGIN_SCOPE(elink)
#  define END_elink_SCOPE END_SCOPE(elink)
#endif
BEGIN_elink_SCOPE // namespace elink::


// forward declarations
class CIconUrl;
class CProvider;
class CUrl;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CObjUrl_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CObjUrl_Base(void);
    // destructor
    virtual ~CObjUrl_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CUrl TUrl;
    typedef CIconUrl TIconUrl;
    typedef NCBI_NS_STD::string TLinkName;
    typedef NCBI_NS_STD::list< NCBI_NS_STD::string > TSubjectType;
    typedef NCBI_NS_STD::list< NCBI_NS_STD::string > TCategory;
    typedef NCBI_NS_STD::list< NCBI_NS_STD::string > TAttribute;
    typedef CProvider TProvider;
    typedef NCBI_NS_STD::string TSubProvider;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Url,
        e_IconUrl,
        e_LinkName,
        e_SubjectType,
        e_Category,
        e_Attribute,
        e_Provider,
        e_SubProvider
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 9> TmemberIndex;

    // getters
    // setters

    /// cmd=llinks 
    /// \S+ 
    /// mandatory
    /// typedef CUrl TUrl
    ///  Check whether the Url data member has been assigned a value.
    bool IsSetUrl(void) const;
    /// Check whether it is safe or not to call GetUrl method.
    bool CanGetUrl(void) const;
    void ResetUrl(void);
    const TUrl& GetUrl(void) const;
    void SetUrl(TUrl& value);
    TUrl& SetUrl(void);
    void SetUrl(const NCBI_NS_STD::string& value);

    /// \S+ 
    /// optional
    /// typedef CIconUrl TIconUrl
    ///  Check whether the IconUrl data member has been assigned a value.
    bool IsSetIconUrl(void) const;
    /// Check whether it is safe or not to call GetIconUrl method.
    bool CanGetIconUrl(void) const;
    void ResetIconUrl(void);
    const TIconUrl& GetIconUrl(void) const;
    void SetIconUrl(TIconUrl& value);
    TIconUrl& SetIconUrl(void);
    void SetIconUrl(const NCBI_NS_STD::string& value);

    /// \S+ 
    /// optional
    /// typedef NCBI_NS_STD::string TLinkName
    ///  Check whether the LinkName data member has been assigned a value.
    bool IsSetLinkName(void) const;
    /// Check whether it is safe or not to call GetLinkName method.
    bool CanGetLinkName(void) const;
    void ResetLinkName(void);
    const TLinkName& GetLinkName(void) const;
    void SetLinkName(const TLinkName& value);
    void SetLinkName(TLinkName&& value);
    TLinkName& SetLinkName(void);

    /// .+ 
    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_STD::string > TSubjectType
    ///  Check whether the SubjectType data member has been assigned a value.
    bool IsSetSubjectType(void) const;
    /// Check whether it is safe or not to call GetSubjectType method.
    bool CanGetSubjectType(void) const;
    void ResetSubjectType(void);
    const TSubjectType& GetSubjectType(void) const;
    TSubjectType& SetSubjectType(void);

    /// .+ 
    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_STD::string > TCategory
    ///  Check whether the Category data member has been assigned a value.
    bool IsSetCategory(void) const;
    /// Check whether it is safe or not to call GetCategory method.
    bool CanGetCategory(void) const;
    void ResetCategory(void);
    const TCategory& GetCategory(void) const;
    TCategory& SetCategory(void);

    /// .+ 
    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_STD::string > TAttribute
    ///  Check whether the Attribute data member has been assigned a value.
    bool IsSetAttribute(void) const;
    /// Check whether it is safe or not to call GetAttribute method.
    bool CanGetAttribute(void) const;
    void ResetAttribute(void);
    const TAttribute& GetAttribute(void) const;
    TAttribute& SetAttribute(void);

    /// mandatory
    /// typedef CProvider TProvider
    ///  Check whether the Provider data member has been assigned a value.
    bool IsSetProvider(void) const;
    /// Check whether it is safe or not to call GetProvider method.
    bool CanGetProvider(void) const;
    void ResetProvider(void);
    const TProvider& GetProvider(void) const;
    void SetProvider(TProvider& value);
    TProvider& SetProvider(void);

    /// optional
    /// typedef NCBI_NS_STD::string TSubProvider
    ///  Check whether the SubProvider data member has been assigned a value.
    bool IsSetSubProvider(void) const;
    /// Check whether it is safe or not to call GetSubProvider method.
    bool CanGetSubProvider(void) const;
    void ResetSubProvider(void);
    const TSubProvider& GetSubProvider(void) const;
    void SetSubProvider(const TSubProvider& value);
    void SetSubProvider(TSubProvider&& value);
    TSubProvider& SetSubProvider(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CObjUrl_Base(const CObjUrl_Base&);
    CObjUrl_Base& operator=(const CObjUrl_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TUrl > m_Url;
    NCBI_NS_NCBI::CRef< TIconUrl > m_IconUrl;
    NCBI_NS_STD::string m_LinkName;
    NCBI_NS_STD::list< NCBI_NS_STD::string > m_SubjectType;
    NCBI_NS_STD::list< NCBI_NS_STD::string > m_Category;
    NCBI_NS_STD::list< NCBI_NS_STD::string > m_Attribute;
    NCBI_NS_NCBI::CRef< TProvider > m_Provider;
    NCBI_NS_STD::string m_SubProvider;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CObjUrl_Base::IsSetUrl(void) const
{
    return m_Url.NotEmpty();
}

inline
bool CObjUrl_Base::CanGetUrl(void) const
{
    return true;
}

inline
const CObjUrl_Base::TUrl& CObjUrl_Base::GetUrl(void) const
{
    if ( !m_Url ) {
        const_cast<CObjUrl_Base*>(this)->ResetUrl();
    }
    return (*m_Url);
}

inline
CObjUrl_Base::TUrl& CObjUrl_Base::SetUrl(void)
{
    if ( !m_Url ) {
        ResetUrl();
    }
    return (*m_Url);
}

inline
bool CObjUrl_Base::IsSetIconUrl(void) const
{
    return m_IconUrl.NotEmpty();
}

inline
bool CObjUrl_Base::CanGetIconUrl(void) const
{
    return IsSetIconUrl();
}

inline
const CObjUrl_Base::TIconUrl& CObjUrl_Base::GetIconUrl(void) const
{
    if (!CanGetIconUrl()) {
        ThrowUnassigned(1);
    }
    return (*m_IconUrl);
}

inline
bool CObjUrl_Base::IsSetLinkName(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CObjUrl_Base::CanGetLinkName(void) const
{
    return IsSetLinkName();
}

inline
const CObjUrl_Base::TLinkName& CObjUrl_Base::GetLinkName(void) const
{
    if (!CanGetLinkName()) {
        ThrowUnassigned(2);
    }
    return m_LinkName;
}

inline
void CObjUrl_Base::SetLinkName(const CObjUrl_Base::TLinkName& value)
{
    m_LinkName = value;
    m_set_State[0] |= 0x30;
}

inline
void CObjUrl_Base::SetLinkName(CObjUrl_Base::TLinkName&& value)
{
    m_LinkName = std::forward<CObjUrl_Base::TLinkName>(value);
    m_set_State[0] |= 0x30;
}

inline
CObjUrl_Base::TLinkName& CObjUrl_Base::SetLinkName(void)
{
#ifdef _DEBUG
    if (!IsSetLinkName()) {
        m_LinkName = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_LinkName;
}

inline
bool CObjUrl_Base::IsSetSubjectType(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CObjUrl_Base::CanGetSubjectType(void) const
{
    return true;
}

inline
const CObjUrl_Base::TSubjectType& CObjUrl_Base::GetSubjectType(void) const
{
    return m_SubjectType;
}

inline
CObjUrl_Base::TSubjectType& CObjUrl_Base::SetSubjectType(void)
{
    m_set_State[0] |= 0x40;
    return m_SubjectType;
}

inline
bool CObjUrl_Base::IsSetCategory(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CObjUrl_Base::CanGetCategory(void) const
{
    return true;
}

inline
const CObjUrl_Base::TCategory& CObjUrl_Base::GetCategory(void) const
{
    return m_Category;
}

inline
CObjUrl_Base::TCategory& CObjUrl_Base::SetCategory(void)
{
    m_set_State[0] |= 0x100;
    return m_Category;
}

inline
bool CObjUrl_Base::IsSetAttribute(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CObjUrl_Base::CanGetAttribute(void) const
{
    return true;
}

inline
const CObjUrl_Base::TAttribute& CObjUrl_Base::GetAttribute(void) const
{
    return m_Attribute;
}

inline
CObjUrl_Base::TAttribute& CObjUrl_Base::SetAttribute(void)
{
    m_set_State[0] |= 0x400;
    return m_Attribute;
}

inline
bool CObjUrl_Base::IsSetProvider(void) const
{
    return m_Provider.NotEmpty();
}

inline
bool CObjUrl_Base::CanGetProvider(void) const
{
    return true;
}

inline
const CObjUrl_Base::TProvider& CObjUrl_Base::GetProvider(void) const
{
    if ( !m_Provider ) {
        const_cast<CObjUrl_Base*>(this)->ResetProvider();
    }
    return (*m_Provider);
}

inline
CObjUrl_Base::TProvider& CObjUrl_Base::SetProvider(void)
{
    if ( !m_Provider ) {
        ResetProvider();
    }
    return (*m_Provider);
}

inline
bool CObjUrl_Base::IsSetSubProvider(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CObjUrl_Base::CanGetSubProvider(void) const
{
    return IsSetSubProvider();
}

inline
const CObjUrl_Base::TSubProvider& CObjUrl_Base::GetSubProvider(void) const
{
    if (!CanGetSubProvider()) {
        ThrowUnassigned(7);
    }
    return m_SubProvider;
}

inline
void CObjUrl_Base::SetSubProvider(const CObjUrl_Base::TSubProvider& value)
{
    m_SubProvider = value;
    m_set_State[0] |= 0xc000;
}

inline
void CObjUrl_Base::SetSubProvider(CObjUrl_Base::TSubProvider&& value)
{
    m_SubProvider = std::forward<CObjUrl_Base::TSubProvider>(value);
    m_set_State[0] |= 0xc000;
}

inline
CObjUrl_Base::TSubProvider& CObjUrl_Base::SetSubProvider(void)
{
#ifdef _DEBUG
    if (!IsSetSubProvider()) {
        m_SubProvider = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_SubProvider;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_elink_SCOPE // namespace elink::


#endif // elink__OBJTOOLS_EUTILS_ELINK_OBJURL_BASE_HPP
