/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ESummaryResult_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'esummary.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef esummary__OBJTOOLS_EUTILS_ESUMMARY_ESUMMARYRESULT_BASE_HPP
#define esummary__OBJTOOLS_EUTILS_ESUMMARY_ESUMMARYRESULT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

#ifndef BEGIN_esummary_SCOPE
#  define BEGIN_esummary_SCOPE BEGIN_SCOPE(esummary)
#  define END_esummary_SCOPE END_SCOPE(esummary)
#endif
BEGIN_esummary_SCOPE // namespace esummary::


// forward declarations
class CDocSum;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CESummaryResult_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CESummaryResult_Base(void);
    // destructor
    virtual ~CESummaryResult_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_EUTILS_EXPORT C_Data : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Data(void);
        // destructor
        ~C_Data(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_DocSum,
            e_ERROR         ///< .+ 
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_ERROR+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static NCBI_NS_STD::string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    NCBI_NS_NCBI::EResetVariant reset,
                    NCBI_NS_NCBI::CObjectMemoryPool* pool);
    
        // types
        typedef CDocSum TDocSum;
        typedef NCBI_NS_STD::string TERROR;
    
        // getters
        // setters
    
        // typedef CDocSum TDocSum
        bool IsDocSum(void) const;
        const TDocSum& GetDocSum(void) const;
        TDocSum& SetDocSum(void);
        void SetDocSum(TDocSum& value);
    
        // typedef NCBI_NS_STD::string TERROR
        bool IsERROR(void) const;
        const TERROR& GetERROR(void) const;
        TERROR& SetERROR(void);
        void SetERROR(const TERROR& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Data(const C_Data& );
        C_Data& operator=(const C_Data& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_Data > > Tdata;

    // getters
    // setters

    /// mandatory
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_Data > > Tdata
    ///  Check whether the  data member has been assigned a value.
    bool IsSet(void) const;
    /// Check whether it is safe or not to call Get method.
    bool CanGet(void) const;
    void Reset(void);
    const Tdata& Get(void) const;
    Tdata& Set(void);

    /// Conversion operator to 'const Tdata' type.
    operator const Tdata& (void) const;
    /// Conversion operator to 'Tdata' type.
    operator Tdata& (void);



private:
    // Prohibit copy constructor and assignment operator
    CESummaryResult_Base(const CESummaryResult_Base&);
    CESummaryResult_Base& operator=(const CESummaryResult_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_Data > > m_data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CESummaryResult_Base::C_Data::E_Choice CESummaryResult_Base::C_Data::Which(void) const
{
    return m_choice;
}

inline
void CESummaryResult_Base::C_Data::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CESummaryResult_Base::C_Data::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CESummaryResult_Base::C_Data::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CESummaryResult_Base::C_Data::IsDocSum(void) const
{
    return m_choice == e_DocSum;
}

inline
bool CESummaryResult_Base::C_Data::IsERROR(void) const
{
    return m_choice == e_ERROR;
}

inline
const CESummaryResult_Base::C_Data::TERROR& CESummaryResult_Base::C_Data::GetERROR(void) const
{
    CheckSelected(e_ERROR);
    return *m_string;
}

inline
CESummaryResult_Base::C_Data::TERROR& CESummaryResult_Base::C_Data::SetERROR(void)
{
    Select(e_ERROR, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CESummaryResult_Base::IsSet(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CESummaryResult_Base::CanGet(void) const
{
    return true;
}

inline
const CESummaryResult_Base::Tdata& CESummaryResult_Base::Get(void) const
{
    return m_data;
}

inline
CESummaryResult_Base::Tdata& CESummaryResult_Base::Set(void)
{
    m_set_State[0] |= 0x1;
    return m_data;
}

inline
CESummaryResult_Base::operator const CESummaryResult_Base::Tdata& (void) const
{
    return m_data;
}

inline
CESummaryResult_Base::operator CESummaryResult_Base::Tdata& (void)
{
    m_set_State[0] |= 0x1;
    return m_data;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_esummary_SCOPE // namespace esummary::


#endif // esummary__OBJTOOLS_EUTILS_ESUMMARY_ESUMMARYRESULT_BASE_HPP
