/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.history.Annotation;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.RCSRepository;
import org.opensolaris.opengrok.history.RCSget;
import org.opensolaris.opengrok.history.RazorHistoryParser;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.history.SCCSRepository;
import org.opensolaris.opengrok.history.SCCSget;

public class RazorRepository
extends Repository {
    private static final long serialVersionUID = 1L;
    private String opengrokSourceRootDirectoryPath;
    private String razorGroupBaseDirectoryPath;

    public RazorRepository() {
        this.type = "Razor";
        this.working = Boolean.TRUE;
        this.datePattern = "yyyy/MM/dd,hh:mm:ss";
    }

    @Override
    public void setDirectoryName(String directoryName) {
        super.setDirectoryName(directoryName);
        File opengrokBaseDirectory = new File(directoryName);
        this.opengrokSourceRootDirectoryPath = opengrokBaseDirectory.getParentFile().getAbsolutePath();
        this.razorGroupBaseDirectoryPath = new File(directoryName, ".razor").getAbsolutePath();
    }

    public String getOpengrokSourceRootDirectoryPath() {
        return this.opengrokSourceRootDirectoryPath;
    }

    public void setOpengrokSourceRootDirectoryPath(String opengrokSourceRootDirectoryPath) {
        this.opengrokSourceRootDirectoryPath = opengrokSourceRootDirectoryPath;
    }

    public String getRazorGroupBaseDirectoryPath() {
        return this.razorGroupBaseDirectoryPath;
    }

    public void setRazorGroupBaseDirectoryPath(String razorGroupBaseDirectoryPath) {
        this.razorGroupBaseDirectoryPath = razorGroupBaseDirectoryPath;
    }

    String getOpenGrokFileNameFor(File file) {
        return file.getAbsolutePath().substring(this.opengrokSourceRootDirectoryPath.length());
    }

    File getSourceNameForOpenGrokName(String path) {
        return new File(this.opengrokSourceRootDirectoryPath + path);
    }

    File getRazorHistoryFileFor(File file) throws IOException {
        return this.pathTranslation(file, "/History/", "", "");
    }

    File getRazorArchiveRCSFileFor(File file) throws IOException {
        return this.pathTranslation(file, "/Archive/RZ_VCS/", "", ",v");
    }

    File getRazorArchiveBinaryFileFor(File file, String rev) throws IOException {
        return this.pathTranslation(file, "/Archive/BINARY/", "", "@" + rev + ".Z");
    }

    File getRazorArchiveSCCSFileFor(File file) throws IOException {
        return this.pathTranslation(file, "/Archive/SCCS/", "s.", "");
    }

    @Override
    boolean fileHasHistory(File file) {
        try {
            File mappedFile = this.getRazorHistoryFileFor(file);
            return mappedFile.exists() && mappedFile.isFile();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    InputStream getHistoryGet(String parent, String basename, String rev) {
        try {
            File binaryFile = this.getRazorArchiveBinaryFileFor(new File(parent, basename), rev);
            if (binaryFile != null && binaryFile.exists()) {
                return new GZIPInputStream(new FileInputStream(binaryFile));
            }
            File rcsFile = this.getRazorArchiveRCSFileFor(new File(parent, basename));
            if (rcsFile != null && rcsFile.exists()) {
                String rcsPath = rcsFile.getPath();
                return new BufferedInputStream(new RCSget(rcsPath, rev));
            }
            File sccsFile = this.getRazorArchiveSCCSFileFor(new File(parent, basename));
            if (sccsFile != null && sccsFile.exists()) {
                this.ensureCommand("org.opensolaris.opengrok.history.SCCS", "sccs");
                return SCCSget.getRevision(this.cmd, sccsFile, rev);
            }
        }
        catch (Exception e) {
            OpenGrokLogger.getLogger().log(Level.SEVERE, "getHistoryGet( " + parent + ", " + basename + ", " + rev + ")", e);
        }
        return null;
    }

    @Override
    Annotation annotate(File file, String revision) throws IOException {
        File rcsFile = this.getRazorArchiveRCSFileFor(file);
        if (rcsFile != null && rcsFile.exists()) {
            return RCSRepository.annotate(file, revision, rcsFile);
        }
        File sccsFile = this.getRazorArchiveSCCSFileFor(file);
        if (sccsFile != null && sccsFile.exists()) {
            return new SCCSRepository().annotate(sccsFile, revision);
        }
        return null;
    }

    @Override
    boolean fileHasAnnotation(File file) {
        try {
            File mappedFile = this.getRazorArchiveRCSFileFor(file);
            if (mappedFile.exists() && mappedFile.isFile()) {
                return true;
            }
            mappedFile = this.getRazorArchiveSCCSFileFor(file);
            return mappedFile.exists() && mappedFile.isFile();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    void update() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private File pathTranslation(File file, String intermediateElements, String filePrefix, String fileSuffix) throws IOException {
        File f = file;
        if (!f.getAbsolutePath().startsWith(this.opengrokSourceRootDirectoryPath)) {
            throw new IOException("Invalid Path for Translation '" + f.getPath() + "', '" + intermediateElements + "', '" + filePrefix + "', '" + fileSuffix + "'");
        }
        if (filePrefix.length() != 0) {
            f = new File(f.getParent(), filePrefix + f.getName());
        }
        StringBuffer path = new StringBuffer(this.razorGroupBaseDirectoryPath);
        path.append(intermediateElements);
        if (f.getAbsolutePath().length() > this.opengrokSourceRootDirectoryPath.length()) {
            path.append(f.getAbsolutePath().substring(this.opengrokSourceRootDirectoryPath.length() + 1));
        }
        if (fileSuffix.length() != 0) {
            path.append(fileSuffix);
        }
        return new File(path.toString());
    }

    @Override
    boolean isRepositoryFor(File file) {
        File f = new File(file, ".razor");
        return f.exists() && f.isDirectory();
    }

    @Override
    boolean hasHistoryForDirectories() {
        return false;
    }

    @Override
    History getHistory(File file) throws HistoryException {
        return new RazorHistoryParser().parse(file, this);
    }
}

