/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.search.context;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.lucene.search.Query;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryEntry;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.HistoryGuru;
import org.opensolaris.opengrok.search.Hit;
import org.opensolaris.opengrok.search.context.HistoryLineTokenizer;
import org.opensolaris.opengrok.search.context.LineMatcher;
import org.opensolaris.opengrok.search.context.QueryMatchers;

public class HistoryContext {
    private final LineMatcher[] m;
    HistoryLineTokenizer tokens;
    private static final Map<String, Boolean> tokenFields = Collections.singletonMap("hist", Boolean.TRUE);

    public HistoryContext(Query query) {
        QueryMatchers qm = new QueryMatchers();
        this.m = qm.getMatchers(query, tokenFields);
        if (this.m != null) {
            this.tokens = new HistoryLineTokenizer(null);
        }
    }

    public boolean isEmpty() {
        return this.m == null;
    }

    public boolean getContext(String filename, String path, List<Hit> hits) throws HistoryException {
        if (this.m == null) {
            return false;
        }
        File f = new File(filename);
        return this.getHistoryContext(HistoryGuru.getInstance().getHistory(f), path, null, hits, null);
    }

    public boolean getContext(String parent, String basename, String path, Writer out, String context) throws HistoryException {
        return this.getContext(new File(parent, basename), path, out, context);
    }

    public boolean getContext(File src, String path, Writer out, String context) throws HistoryException {
        if (this.m == null) {
            return false;
        }
        History hist = HistoryGuru.getInstance().getHistory(src);
        return this.getHistoryContext(hist, path, out, null, context);
    }

    private boolean getHistoryContext(History in, String path, Writer out, List<Hit> hits, String wcontext) {
        if (out == null == (hits == null)) {
            throw new IllegalArgumentException("Exactly one of out and hits should be non-null");
        }
        if (this.m == null) {
            return false;
        }
        int matchedLines = 0;
        Iterator<HistoryEntry> it = in.getHistoryEntries().iterator();
        try {
            HistoryEntry he = null;
            HistoryEntry nhe = null;
            String nrev = null;
            while ((it.hasNext() || nhe != null) && matchedLines < 10) {
                String token;
                he = nhe == null ? it.next() : nhe;
                String line = he.getLine();
                String rev = he.getRevision();
                nhe = it.hasNext() ? it.next() : null;
                nrev = nhe == null ? null : nhe.getRevision();
                this.tokens.reInit(line);
                int start = -1;
                block3: while ((token = this.tokens.next()) != null) {
                    for (int i = 0; i < this.m.length; ++i) {
                        int matchState = this.m[i].match(token);
                        if (matchState == 1) {
                            if (start < 0) {
                                start = this.tokens.getMatchStart();
                            }
                            int end = this.tokens.getMatchEnd();
                            if (out == null) {
                                StringBuilder sb = new StringBuilder();
                                this.writeMatch(sb, line, start, end, true, path, wcontext, nrev, rev);
                                hits.add(new Hit(path, sb.toString(), "", false, false));
                            } else {
                                this.writeMatch(out, line, start, end, false, path, wcontext, nrev, rev);
                            }
                            ++matchedLines;
                            continue block3;
                        }
                        if (matchState == 2) {
                            if (start >= 0) continue;
                            start = this.tokens.getMatchStart();
                            continue;
                        }
                        start = -1;
                    }
                }
            }
        }
        catch (Exception e) {
            OpenGrokLogger.getLogger().log(Level.WARNING, "Could not get history context for " + path, e);
        }
        return matchedLines > 0;
    }

    private void writeMatch(Appendable out, String line, int start, int end, boolean flatten, String path, String wcontext, String nrev, String rev) throws IOException {
        String prefix = line.substring(0, start);
        String match = line.substring(start, end);
        String suffix = line.substring(end);
        if (wcontext != null && nrev != null && !wcontext.isEmpty()) {
            out.append("<a href=" + wcontext + "/diff" + path + "?r2=" + path + "@" + rev + "&r1=" + path + "@" + nrev + " title=\"diff to previous version\">diff</a> ");
        }
        this.printHTML(out, prefix, flatten);
        out.append("<b>");
        this.printHTML(out, match, flatten);
        out.append("</b>");
        this.printHTML(out, suffix, flatten);
    }

    private void printHTML(Appendable out, String str, boolean flatten) throws IOException {
        block6: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\n': {
                    out.append(flatten ? " " : "<br/>");
                    continue block6;
                }
                case '<': {
                    out.append("&lt;");
                    continue block6;
                }
                case '>': {
                    out.append("&gt;");
                    continue block6;
                }
                case '&': {
                    out.append("&amp;");
                    continue block6;
                }
                default: {
                    out.append(ch);
                }
            }
        }
    }
}

