# pylint:disable=line-too-long
import logging
from collections import OrderedDict

from ...sim_type import (SimTypeFunction,
    SimTypeShort,
    SimTypeInt,
    SimTypeLong,
    SimTypeLongLong,
    SimTypeDouble,
    SimTypeFloat,
    SimTypePointer,
    SimTypeChar,
    SimStruct,
    SimTypeArray,
    SimTypeBottom,
    SimUnion,
    SimTypeBool,
    SimTypeRef,
)
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.type_collection_names = ["win32"]
lib.set_default_cc("X86", SimCCStdcall)
lib.set_default_cc("AMD64", SimCCMicrosoftAMD64)
lib.set_library_names("winhvplatform.dll")
prototypes = \
    {
        #
        'WHvGetCapability': SimTypeFunction([SimTypeInt(signed=False, label="WHV_CAPABILITY_CODE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["CapabilityCode", "CapabilityBuffer", "CapabilityBufferSizeInBytes", "WrittenSizeInBytes"]),
        #
        'WHvCreatePartition': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition"]),
        #
        'WHvSetupPartition': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition"]),
        #
        'WHvResetPartition': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition"]),
        #
        'WHvDeletePartition': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition"]),
        #
        'WHvGetPartitionProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="WHV_PARTITION_PROPERTY_CODE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "PropertyCode", "PropertyBuffer", "PropertyBufferSizeInBytes", "WrittenSizeInBytes"]),
        #
        'WHvSetPartitionProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="WHV_PARTITION_PROPERTY_CODE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "PropertyCode", "PropertyBuffer", "PropertyBufferSizeInBytes"]),
        #
        'WHvSuspendPartitionTime': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition"]),
        #
        'WHvResumePartitionTime': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition"]),
        #
        'WHvMapGpaRange': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="WHV_MAP_GPA_RANGE_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "SourceAddress", "GuestAddress", "SizeInBytes", "Flags"]),
        #
        'WHvMapGpaRange2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="WHV_MAP_GPA_RANGE_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "Process", "SourceAddress", "GuestAddress", "SizeInBytes", "Flags"]),
        #
        'WHvUnmapGpaRange': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "GuestAddress", "SizeInBytes"]),
        #
        'WHvTranslateGva': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="WHV_TRANSLATE_GVA_FLAGS"), SimTypePointer(SimTypeRef("WHV_TRANSLATE_GVA_RESULT", SimStruct), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "VpIndex", "Gva", "TranslateFlags", "TranslationResult", "Gpa"]),
        #
        'WHvCreateVirtualProcessor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "VpIndex", "Flags"]),
        #
        'WHvCreateVirtualProcessor2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("WHV_VIRTUAL_PROCESSOR_PROPERTY", SimStruct), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "VpIndex", "Properties", "PropertyCount"]),
        #
        'WHvDeleteVirtualProcessor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "VpIndex"]),
        #
        'WHvRunVirtualProcessor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "VpIndex", "ExitContext", "ExitContextSizeInBytes"]),
        #
        'WHvCancelRunVirtualProcessor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "VpIndex", "Flags"]),
        #
        'WHvGetVirtualProcessorRegisters': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="WHV_REGISTER_NAME"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimUnion({"Reg128": SimUnion({"Anonymous": SimStruct(OrderedDict((("Low64", SimTypeLongLong(signed=False, label="UInt64")), ("High64", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "Dword": SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 4)}, name="<anon>", label="None"), "Reg64": SimTypeLongLong(signed=False, label="UInt64"), "Reg32": SimTypeInt(signed=False, label="UInt32"), "Reg16": SimTypeShort(signed=False, label="UInt16"), "Reg8": SimTypeChar(label="Byte"), "Fp": SimUnion({"Anonymous": SimStruct(OrderedDict((("Mantissa", SimTypeLongLong(signed=False, label="UInt64")), ("_bitfield", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "AsUINT128": SimUnion({"Anonymous": SimStruct(OrderedDict((("Low64", SimTypeLongLong(signed=False, label="UInt64")), ("High64", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "Dword": SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 4)}, name="<anon>", label="None")}, name="<anon>", label="None"), "FpControlStatus": SimUnion({"Anonymous": SimStruct(OrderedDict((("FpControl", SimTypeShort(signed=False, label="UInt16")), ("FpStatus", SimTypeShort(signed=False, label="UInt16")), ("FpTag", SimTypeChar(label="Byte")), ("Reserved", SimTypeChar(label="Byte")), ("LastFpOp", SimTypeShort(signed=False, label="UInt16")), ("Anonymous", SimUnion({"LastFpRip": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct(OrderedDict((("LastFpEip", SimTypeInt(signed=False, label="UInt32")), ("LastFpCs", SimTypeShort(signed=False, label="UInt16")), ("Reserved2", SimTypeShort(signed=False, label="UInt16")),)), name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")),)), name="_Anonymous_e__Struct", pack=False, align=None), "AsUINT128": SimUnion({"Anonymous": SimStruct(OrderedDict((("Low64", SimTypeLongLong(signed=False, label="UInt64")), ("High64", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "Dword": SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 4)}, name="<anon>", label="None")}, name="<anon>", label="None"), "XmmControlStatus": SimUnion({"Anonymous": SimStruct(OrderedDict((("Anonymous", SimUnion({"LastFpRdp": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct(OrderedDict((("LastFpDp", SimTypeInt(signed=False, label="UInt32")), ("LastFpDs", SimTypeShort(signed=False, label="UInt16")), ("Reserved", SimTypeShort(signed=False, label="UInt16")),)), name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")), ("XmmStatusControl", SimTypeInt(signed=False, label="UInt32")), ("XmmStatusControlMask", SimTypeInt(signed=False, label="UInt32")),)), name="_Anonymous_e__Struct", pack=False, align=None), "AsUINT128": SimUnion({"Anonymous": SimStruct(OrderedDict((("Low64", SimTypeLongLong(signed=False, label="UInt64")), ("High64", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "Dword": SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 4)}, name="<anon>", label="None")}, name="<anon>", label="None"), "Segment": SimTypeRef("WHV_X64_SEGMENT_REGISTER", SimStruct), "Table": SimTypeRef("WHV_X64_TABLE_REGISTER", SimStruct), "InterruptState": SimUnion({"Anonymous": SimStruct(OrderedDict((("_bitfield", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "AsUINT64": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), "PendingInterruption": SimUnion({"Anonymous": SimStruct(OrderedDict((("_bitfield", SimTypeInt(signed=False, label="UInt32")), ("ErrorCode", SimTypeInt(signed=False, label="UInt32")),)), name="_Anonymous_e__Struct", pack=False, align=None), "AsUINT64": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), "DeliverabilityNotifications": SimUnion({"Anonymous": SimStruct(OrderedDict((("_bitfield", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "AsUINT64": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), "ExceptionEvent": SimUnion({"Anonymous": SimStruct(OrderedDict((("_bitfield", SimTypeInt(signed=False, label="UInt32")), ("ErrorCode", SimTypeInt(signed=False, label="UInt32")), ("ExceptionParameter", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "AsUINT128": SimUnion({"Anonymous": SimStruct(OrderedDict((("Low64", SimTypeLongLong(signed=False, label="UInt64")), ("High64", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "Dword": SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 4)}, name="<anon>", label="None")}, name="<anon>", label="None"), "ExtIntEvent": SimUnion({"Anonymous": SimStruct(OrderedDict((("_bitfield", SimTypeLongLong(signed=False, label="UInt64")), ("Reserved2", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "AsUINT128": SimUnion({"Anonymous": SimStruct(OrderedDict((("Low64", SimTypeLongLong(signed=False, label="UInt64")), ("High64", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "Dword": SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 4)}, name="<anon>", label="None")}, name="<anon>", label="None"), "InternalActivity": SimUnion({"Anonymous": SimStruct(OrderedDict((("_bitfield", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "AsUINT64": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), "PendingDebugException": SimUnion({"AsUINT64": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct(OrderedDict((("_bitfield", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="<anon>", label="None"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "VpIndex", "RegisterNames", "RegisterCount", "RegisterValues"]),
        #
        'WHvSetVirtualProcessorRegisters': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="WHV_REGISTER_NAME"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimUnion({"Reg128": SimUnion({"Anonymous": SimStruct(OrderedDict((("Low64", SimTypeLongLong(signed=False, label="UInt64")), ("High64", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "Dword": SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 4)}, name="<anon>", label="None"), "Reg64": SimTypeLongLong(signed=False, label="UInt64"), "Reg32": SimTypeInt(signed=False, label="UInt32"), "Reg16": SimTypeShort(signed=False, label="UInt16"), "Reg8": SimTypeChar(label="Byte"), "Fp": SimUnion({"Anonymous": SimStruct(OrderedDict((("Mantissa", SimTypeLongLong(signed=False, label="UInt64")), ("_bitfield", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "AsUINT128": SimUnion({"Anonymous": SimStruct(OrderedDict((("Low64", SimTypeLongLong(signed=False, label="UInt64")), ("High64", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "Dword": SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 4)}, name="<anon>", label="None")}, name="<anon>", label="None"), "FpControlStatus": SimUnion({"Anonymous": SimStruct(OrderedDict((("FpControl", SimTypeShort(signed=False, label="UInt16")), ("FpStatus", SimTypeShort(signed=False, label="UInt16")), ("FpTag", SimTypeChar(label="Byte")), ("Reserved", SimTypeChar(label="Byte")), ("LastFpOp", SimTypeShort(signed=False, label="UInt16")), ("Anonymous", SimUnion({"LastFpRip": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct(OrderedDict((("LastFpEip", SimTypeInt(signed=False, label="UInt32")), ("LastFpCs", SimTypeShort(signed=False, label="UInt16")), ("Reserved2", SimTypeShort(signed=False, label="UInt16")),)), name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")),)), name="_Anonymous_e__Struct", pack=False, align=None), "AsUINT128": SimUnion({"Anonymous": SimStruct(OrderedDict((("Low64", SimTypeLongLong(signed=False, label="UInt64")), ("High64", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "Dword": SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 4)}, name="<anon>", label="None")}, name="<anon>", label="None"), "XmmControlStatus": SimUnion({"Anonymous": SimStruct(OrderedDict((("Anonymous", SimUnion({"LastFpRdp": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct(OrderedDict((("LastFpDp", SimTypeInt(signed=False, label="UInt32")), ("LastFpDs", SimTypeShort(signed=False, label="UInt16")), ("Reserved", SimTypeShort(signed=False, label="UInt16")),)), name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")), ("XmmStatusControl", SimTypeInt(signed=False, label="UInt32")), ("XmmStatusControlMask", SimTypeInt(signed=False, label="UInt32")),)), name="_Anonymous_e__Struct", pack=False, align=None), "AsUINT128": SimUnion({"Anonymous": SimStruct(OrderedDict((("Low64", SimTypeLongLong(signed=False, label="UInt64")), ("High64", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "Dword": SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 4)}, name="<anon>", label="None")}, name="<anon>", label="None"), "Segment": SimTypeRef("WHV_X64_SEGMENT_REGISTER", SimStruct), "Table": SimTypeRef("WHV_X64_TABLE_REGISTER", SimStruct), "InterruptState": SimUnion({"Anonymous": SimStruct(OrderedDict((("_bitfield", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "AsUINT64": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), "PendingInterruption": SimUnion({"Anonymous": SimStruct(OrderedDict((("_bitfield", SimTypeInt(signed=False, label="UInt32")), ("ErrorCode", SimTypeInt(signed=False, label="UInt32")),)), name="_Anonymous_e__Struct", pack=False, align=None), "AsUINT64": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), "DeliverabilityNotifications": SimUnion({"Anonymous": SimStruct(OrderedDict((("_bitfield", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "AsUINT64": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), "ExceptionEvent": SimUnion({"Anonymous": SimStruct(OrderedDict((("_bitfield", SimTypeInt(signed=False, label="UInt32")), ("ErrorCode", SimTypeInt(signed=False, label="UInt32")), ("ExceptionParameter", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "AsUINT128": SimUnion({"Anonymous": SimStruct(OrderedDict((("Low64", SimTypeLongLong(signed=False, label="UInt64")), ("High64", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "Dword": SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 4)}, name="<anon>", label="None")}, name="<anon>", label="None"), "ExtIntEvent": SimUnion({"Anonymous": SimStruct(OrderedDict((("_bitfield", SimTypeLongLong(signed=False, label="UInt64")), ("Reserved2", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "AsUINT128": SimUnion({"Anonymous": SimStruct(OrderedDict((("Low64", SimTypeLongLong(signed=False, label="UInt64")), ("High64", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "Dword": SimTypeArray(SimTypeInt(signed=False, label="UInt32"), 4)}, name="<anon>", label="None")}, name="<anon>", label="None"), "InternalActivity": SimUnion({"Anonymous": SimStruct(OrderedDict((("_bitfield", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None), "AsUINT64": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), "PendingDebugException": SimUnion({"AsUINT64": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct(OrderedDict((("_bitfield", SimTypeLongLong(signed=False, label="UInt64")),)), name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="<anon>", label="None"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "VpIndex", "RegisterNames", "RegisterCount", "RegisterValues"]),
        #
        'WHvGetVirtualProcessorInterruptControllerState': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "VpIndex", "State", "StateSize", "WrittenSize"]),
        #
        'WHvSetVirtualProcessorInterruptControllerState': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "VpIndex", "State", "StateSize"]),
        #
        'WHvRequestInterrupt': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("WHV_INTERRUPT_CONTROL", SimStruct), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "Interrupt", "InterruptControlSize"]),
        #
        'WHvGetVirtualProcessorXsaveState': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "VpIndex", "Buffer", "BufferSizeInBytes", "BytesWritten"]),
        #
        'WHvSetVirtualProcessorXsaveState': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "VpIndex", "Buffer", "BufferSizeInBytes"]),
        #
        'WHvQueryGpaRangeDirtyBitmap': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "GuestAddress", "RangeSizeInBytes", "Bitmap", "BitmapSizeInBytes"]),
        #
        'WHvGetPartitionCounters': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="WHV_PARTITION_COUNTER_SET"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "CounterSet", "Buffer", "BufferSizeInBytes", "BytesWritten"]),
        #
        'WHvGetVirtualProcessorCounters': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="WHV_PROCESSOR_COUNTER_SET"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "VpIndex", "CounterSet", "Buffer", "BufferSizeInBytes", "BytesWritten"]),
        #
        'WHvGetVirtualProcessorInterruptControllerState2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "VpIndex", "State", "StateSize", "WrittenSize"]),
        #
        'WHvSetVirtualProcessorInterruptControllerState2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "VpIndex", "State", "StateSize"]),
        #
        'WHvRegisterPartitionDoorbellEvent': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("WHV_DOORBELL_MATCH_DATA", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "MatchData", "EventHandle"]),
        #
        'WHvUnregisterPartitionDoorbellEvent': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("WHV_DOORBELL_MATCH_DATA", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "MatchData"]),
        #
        'WHvAdviseGpaRange': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("WHV_MEMORY_RANGE_ENTRY", SimStruct), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="WHV_ADVISE_GPA_RANGE_CODE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "GpaRanges", "GpaRangesCount", "Advice", "AdviceBuffer", "AdviceBufferSizeInBytes"]),
        #
        'WHvReadGpaRange': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=False, label="UInt64"), SimUnion({"AsUINT64": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct(OrderedDict((("CacheType", SimTypeInt(signed=False, label="WHV_CACHE_TYPE")), ("Reserved", SimTypeInt(signed=False, label="UInt32")),)), name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "VpIndex", "GuestAddress", "Controls", "Data", "DataSizeInBytes"]),
        #
        'WHvWriteGpaRange': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=False, label="UInt64"), SimUnion({"AsUINT64": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct(OrderedDict((("CacheType", SimTypeInt(signed=False, label="WHV_CACHE_TYPE")), ("Reserved", SimTypeInt(signed=False, label="UInt32")),)), name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "VpIndex", "GuestAddress", "Controls", "Data", "DataSizeInBytes"]),
        #
        'WHvSignalVirtualProcessorSynicEvent': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeRef("WHV_SYNIC_EVENT_PARAMETERS", SimStruct), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "SynicEvent", "NewlySignaled"]),
        #
        'WHvGetVirtualProcessorState': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="WHV_VIRTUAL_PROCESSOR_STATE_TYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "VpIndex", "StateType", "Buffer", "BufferSizeInBytes", "BytesWritten"]),
        #
        'WHvSetVirtualProcessorState': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="WHV_VIRTUAL_PROCESSOR_STATE_TYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "VpIndex", "StateType", "Buffer", "BufferSizeInBytes"]),
        #
        'WHvAllocateVpciResource': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="WHV_ALLOCATE_VPCI_RESOURCE_FLAGS"), SimTypePointer(SimTypeBottom(label="Void"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ProviderId", "Flags", "ResourceDescriptor", "ResourceDescriptorSizeInBytes", "VpciResource"]),
        #
        'WHvCreateVpciDevice': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="WHV_CREATE_VPCI_DEVICE_FLAGS"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "LogicalDeviceId", "VpciResource", "Flags", "NotificationEventHandle"]),
        #
        'WHvDeleteVpciDevice': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "LogicalDeviceId"]),
        #
        'WHvGetVpciDeviceProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="WHV_VPCI_DEVICE_PROPERTY_CODE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "LogicalDeviceId", "PropertyCode", "PropertyBuffer", "PropertyBufferSizeInBytes", "WrittenSizeInBytes"]),
        #
        'WHvGetVpciDeviceNotification': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeRef("WHV_VPCI_DEVICE_NOTIFICATION", SimStruct), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "LogicalDeviceId", "Notification", "NotificationSizeInBytes"]),
        #
        'WHvMapVpciDeviceMmioRanges': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("WHV_VPCI_MMIO_MAPPING", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "LogicalDeviceId", "MappingCount", "Mappings"]),
        #
        'WHvUnmapVpciDeviceMmioRanges': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "LogicalDeviceId"]),
        #
        'WHvSetVpciDevicePowerState': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="DEVICE_POWER_STATE")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "LogicalDeviceId", "PowerState"]),
        #
        'WHvReadVpciDeviceRegister': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeRef("WHV_VPCI_DEVICE_REGISTER", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "LogicalDeviceId", "Register", "Data"]),
        #
        'WHvWriteVpciDeviceRegister': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeRef("WHV_VPCI_DEVICE_REGISTER", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "LogicalDeviceId", "Register", "Data"]),
        #
        'WHvMapVpciDeviceInterrupt': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("WHV_VPCI_INTERRUPT_TARGET", SimStruct), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "LogicalDeviceId", "Index", "MessageCount", "Target", "MsiAddress", "MsiData"]),
        #
        'WHvUnmapVpciDeviceInterrupt': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "LogicalDeviceId", "Index"]),
        #
        'WHvRetargetVpciDeviceInterrupt': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("WHV_VPCI_INTERRUPT_TARGET", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "LogicalDeviceId", "MsiAddress", "MsiData", "Target"]),
        #
        'WHvRequestVpciDeviceInterrupt': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "LogicalDeviceId", "MsiAddress", "MsiData"]),
        #
        'WHvGetVpciDeviceInterruptTarget': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("WHV_VPCI_INTERRUPT_TARGET", SimStruct), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "LogicalDeviceId", "Index", "MultiMessageNumber", "Target", "TargetSizeInBytes", "BytesWritten"]),
        #
        'WHvCreateTrigger': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("WHV_TRIGGER_PARAMETERS", SimStruct), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "Parameters", "TriggerHandle", "EventHandle"]),
        #
        'WHvUpdateTriggerParameters': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("WHV_TRIGGER_PARAMETERS", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "Parameters", "TriggerHandle"]),
        #
        'WHvDeleteTrigger': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "TriggerHandle"]),
        #
        'WHvCreateNotificationPort': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("WHV_NOTIFICATION_PORT_PARAMETERS", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "Parameters", "EventHandle", "PortHandle"]),
        #
        'WHvSetNotificationPortProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="WHV_NOTIFICATION_PORT_PROPERTY_CODE"), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "PortHandle", "PropertyCode", "PropertyValue"]),
        #
        'WHvDeleteNotificationPort': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "PortHandle"]),
        #
        'WHvPostVirtualProcessorSynicMessage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "VpIndex", "SintIndex", "Message", "MessageSizeInBytes"]),
        #
        'WHvGetVirtualProcessorCpuidOutput': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("WHV_CPUID_OUTPUT", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "VpIndex", "Eax", "Ecx", "CpuidOutput"]),
        #
        'WHvGetInterruptTargetVpSet': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="WHV_INTERRUPT_DESTINATION_MODE"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "Destination", "DestinationMode", "TargetVps", "VpCount", "TargetVpCount"]),
        #
        'WHvStartPartitionMigration': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition", "MigrationHandle"]),
        #
        'WHvCancelPartitionMigration': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition"]),
        #
        'WHvCompletePartitionMigration': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Partition"]),
        #
        'WHvAcceptPartitionMigration': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["MigrationHandle", "Partition"]),
    }

lib.set_prototypes(prototypes)
