/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview;

import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JButton;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.ChartConfigMode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScale;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.Interval;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.ScaleFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

class BarChartCreator {
    private DataScale _xAxisDataScale;
    private DataScale _yAxisDataScale;
    private Integer _callDepth;
    private ChartConfigMode _mode;
    private String _title;
    private JFreeChart _chart;
    private String _label;

    public BarChartCreator(DataScale xAxisDataScale, DataScale yAxisDataScale, Integer callDepth, ChartConfigMode mode) {
        this._xAxisDataScale = xAxisDataScale;
        this._yAxisDataScale = yAxisDataScale;
        this._callDepth = callDepth;
        this._mode = mode;
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        for (Interval xAxisInterval : this._xAxisDataScale.getIntervals()) {
            rows.addAll(xAxisInterval.getResultRows());
        }
        ScaleFactory scaleFactory = new ScaleFactory(rows, this._xAxisDataScale.getColumnIx(), this._xAxisDataScale.getColumnDisplayDefinition(), this._callDepth);
        DataScaleListener dumDataScaleListener = new DataScaleListener(){

            @Override
            public void intervalSelected(Interval interval, JButton intervalButtonClicked) {
            }

            @Override
            public void showInTableWin(Interval interval) {
            }

            @Override
            public void showInTable(Interval interval) {
            }

            @Override
            public void showIntervalDetails(String intervalDetailsHtml, Point dialogLocation) {
            }
        };
        DataScale newScale = scaleFactory.createScale(dumDataScaleListener);
        DefaultCategoryDataset categoryDataset = new DefaultCategoryDataset();
        String category = this._xAxisDataScale.getColumnDisplayDefinition().getColumnName();
        for (Interval interval : newScale.getIntervals()) {
            categoryDataset.addValue(this.calculateValue(interval, this._mode, this._yAxisDataScale), (Comparable)((Object)interval.getLabel()), (Comparable)((Object)category));
        }
        this._title = "Chart for column: " + this._xAxisDataScale.getColumnDisplayDefinition().getColumnName();
        this._chart = ChartFactory.createBarChart((String)this._title, (String)category, (String)this._mode.getYAxisLabel(this._yAxisDataScale), (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        this._label = this.createLabel(newScale, rows);
    }

    public String getTitle() {
        return this._title;
    }

    public JFreeChart getChart() {
        return this._chart;
    }

    public String getLabel() {
        return this._label;
    }

    private double calculateValue(Interval interval, ChartConfigMode mode, DataScale yAxisDataScale) {
        switch (mode) {
            case COUNT: {
                return interval.getLen();
            }
            case SUM: {
                double retSum = 0.0;
                for (int i = 0; i < interval.getLen(); ++i) {
                    Object o = interval.get(i);
                    if (null == o) continue;
                    retSum += ((Number)o).doubleValue();
                }
                return retSum;
            }
            case XY_COUNT_DISTINCT: {
                HashSet<Object> distinctSet = new HashSet<Object>();
                for (int i = 0; i < interval.getLen(); ++i) {
                    int dataSetRowIndex = interval.getDataSetRowIndex(i);
                    Object obj = yAxisDataScale.getIndexedColumn().getRow(dataSetRowIndex);
                    distinctSet.add(obj);
                }
                return distinctSet.size();
            }
            case XY_SUM_COL: {
                double retXYSumCol = 0.0;
                for (int i = 0; i < interval.getLen(); ++i) {
                    int dataSetRowIndex = interval.getDataSetRowIndex(i);
                    Object obj = yAxisDataScale.getIndexedColumn().getRow(dataSetRowIndex);
                    if (null == obj) continue;
                    retXYSumCol += ((Number)obj).doubleValue();
                }
                return retXYSumCol;
            }
        }
        throw new IllegalStateException("Dont know how to handle mode: " + (Object)((Object)mode));
    }

    private String createLabel(DataScale dataScale, ArrayList<Object[]> rows) {
        String ret = "Contains " + rows.size() + " query result values in " + dataScale.getIntervals().size() + " intervals";
        String intervalWidth = dataScale.getIntervalWidth();
        if (null != intervalWidth) {
            ret = ret + " of width " + intervalWidth;
        }
        ret = ret + ".\nLegend shows the first and the last query result value of intervals. Intervals that contain no values are omitted.";
        return ret;
    }
}

