/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.actions;

import java.io.IOException;
import java.time.Clock;
import java.util.Objects;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.watcher.actions.Action;
import org.elasticsearch.xpack.core.watcher.actions.ActionFactory;
import org.elasticsearch.xpack.core.watcher.actions.ActionRegistry;
import org.elasticsearch.xpack.core.watcher.actions.ActionWrapperResult;
import org.elasticsearch.xpack.core.watcher.actions.ExecutableAction;
import org.elasticsearch.xpack.core.watcher.actions.throttler.ActionThrottler;
import org.elasticsearch.xpack.core.watcher.actions.throttler.Throttler;
import org.elasticsearch.xpack.core.watcher.actions.throttler.ThrottlerField;
import org.elasticsearch.xpack.core.watcher.condition.Condition;
import org.elasticsearch.xpack.core.watcher.condition.ExecutableCondition;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.core.watcher.transform.ExecutableTransform;
import org.elasticsearch.xpack.core.watcher.transform.Transform;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.core.watcher.watch.WatchField;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ActionWrapper
implements ToXContentObject {
    private String id;
    @Nullable
    private final ExecutableCondition condition;
    @Nullable
    private final ExecutableTransform transform;
    private final ActionThrottler throttler;
    private final ExecutableAction action;

    public ActionWrapper(String id, ActionThrottler throttler, @Nullable ExecutableCondition condition, @Nullable ExecutableTransform transform, ExecutableAction action) {
        this.id = id;
        this.condition = condition;
        this.throttler = throttler;
        this.transform = transform;
        this.action = action;
    }

    public String id() {
        return this.id;
    }

    public ExecutableCondition condition() {
        return this.condition;
    }

    public ExecutableTransform transform() {
        return this.transform;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public ExecutableAction action() {
        return this.action;
    }

    public ActionWrapperResult execute(WatchExecutionContext ctx) {
        Throttler.Result throttleResult;
        ActionWrapperResult result = ctx.actionsResults().get(this.id);
        if (result != null) {
            return result;
        }
        if (!ctx.skipThrottling(this.id) && (throttleResult = this.throttler.throttle(this.id, ctx)).throttle()) {
            if (throttleResult.type() == Throttler.Type.ACK) {
                return new ActionWrapperResult(this.id, new Action.Result.Acknowledged(this.action.type(), throttleResult.reason()));
            }
            return new ActionWrapperResult(this.id, new Action.Result.Throttled(this.action.type(), throttleResult.reason()));
        }
        Condition.Result conditionResult = null;
        if (this.condition != null) {
            try {
                conditionResult = this.condition.execute(ctx);
                if (!conditionResult.met()) {
                    ctx.watch().status().actionStatus(this.id).resetAckStatus(DateTime.now((DateTimeZone)DateTimeZone.UTC));
                    return new ActionWrapperResult(this.id, conditionResult, null, new Action.Result.ConditionFailed(this.action.type(), "condition not met. skipping", new Object[0]));
                }
            }
            catch (RuntimeException e) {
                this.action.logger().error(() -> new ParameterizedMessage("failed to execute action [{}/{}]. failed to execute condition", (Object)ctx.watch().id(), (Object)this.id), (Throwable)e);
                return new ActionWrapperResult(this.id, new Action.Result.ConditionFailed(this.action.type(), "condition failed. skipping: {}", e.getMessage()));
            }
        }
        Payload payload = ctx.payload();
        Transform.Result transformResult = null;
        if (this.transform != null) {
            try {
                transformResult = (Transform.Result)this.transform.execute(ctx, payload);
                if (transformResult.status() == Transform.Result.Status.FAILURE) {
                    this.action.logger().error("failed to execute action [{}/{}]. failed to transform payload. {}", (Object)ctx.watch().id(), (Object)this.id, (Object)transformResult.reason());
                    String msg = "Failed to transform payload";
                    return new ActionWrapperResult(this.id, conditionResult, transformResult, new Action.Result.Failure(this.action.type(), msg, new Object[0]));
                }
                payload = transformResult.payload();
            }
            catch (Exception e) {
                this.action.logger().error(() -> new ParameterizedMessage("failed to execute action [{}/{}]. failed to transform payload.", (Object)ctx.watch().id(), (Object)this.id), (Throwable)e);
                return new ActionWrapperResult(this.id, conditionResult, null, new Action.Result.FailureWithException(this.action.type(), e));
            }
        }
        try {
            Action.Result actionResult = this.action.execute(this.id, ctx, payload);
            return new ActionWrapperResult(this.id, conditionResult, transformResult, actionResult);
        }
        catch (Exception e) {
            this.action.logger().error(() -> new ParameterizedMessage("failed to execute action [{}/{}]", (Object)ctx.watch().id(), (Object)this.id), (Throwable)e);
            return new ActionWrapperResult(this.id, new Action.Result.FailureWithException(this.action.type(), e));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionWrapper that = (ActionWrapper)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.condition, that.condition) && Objects.equals(this.transform, that.transform) && Objects.equals(this.action, that.action);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.condition, this.transform, this.action);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        TimeValue throttlePeriod = this.throttler.throttlePeriod();
        if (throttlePeriod != null) {
            builder.humanReadableField(ThrottlerField.THROTTLE_PERIOD.getPreferredName(), ThrottlerField.THROTTLE_PERIOD_HUMAN.getPreferredName(), (Object)throttlePeriod);
        }
        if (this.condition != null) {
            builder.startObject(WatchField.CONDITION.getPreferredName()).field(this.condition.type(), (ToXContent)this.condition, params).endObject();
        }
        if (this.transform != null) {
            builder.startObject(Transform.TRANSFORM.getPreferredName()).field(this.transform.type(), (ToXContent)this.transform, params).endObject();
        }
        builder.field(this.action.type(), (ToXContent)this.action, params);
        return builder.endObject();
    }

    static ActionWrapper parse(String watchId, String actionId, XContentParser parser, ActionRegistry actionRegistry, Clock clock, XPackLicenseState licenseState) throws IOException {
        XContentParser.Token token;
        assert (parser.currentToken() == XContentParser.Token.START_OBJECT);
        ExecutableCondition condition = null;
        ExecutableTransform transform = null;
        TimeValue throttlePeriod = null;
        ExecutableAction action = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (WatchField.CONDITION.match(currentFieldName, parser.getDeprecationHandler())) {
                condition = actionRegistry.getConditionRegistry().parseExecutable(watchId, parser);
                continue;
            }
            if (Transform.TRANSFORM.match(currentFieldName, parser.getDeprecationHandler())) {
                transform = actionRegistry.getTransformRegistry().parse(watchId, parser);
                continue;
            }
            if (ThrottlerField.THROTTLE_PERIOD.match(currentFieldName, parser.getDeprecationHandler())) {
                throttlePeriod = TimeValue.timeValueMillis((long)parser.longValue());
                continue;
            }
            if (ThrottlerField.THROTTLE_PERIOD_HUMAN.match(currentFieldName, parser.getDeprecationHandler())) {
                try {
                    throttlePeriod = WatcherDateTimeUtils.parseTimeValue(parser, ThrottlerField.THROTTLE_PERIOD_HUMAN.toString());
                    continue;
                }
                catch (ElasticsearchParseException pe) {
                    throw new ElasticsearchParseException("could not parse action [{}/{}]. failed to parse field [{}] as time value", (Throwable)pe, new Object[]{watchId, actionId, currentFieldName});
                }
            }
            ActionFactory actionFactory = actionRegistry.factory(currentFieldName);
            if (actionFactory == null) {
                throw new ElasticsearchParseException("could not parse action [{}/{}]. unknown action type [{}]", new Object[]{watchId, actionId, currentFieldName});
            }
            action = actionFactory.parseExecutable(watchId, actionId, parser);
        }
        if (action == null) {
            throw new ElasticsearchParseException("could not parse watch action [{}/{}]. missing action type", new Object[]{watchId, actionId});
        }
        ActionThrottler throttler = new ActionThrottler(clock, throttlePeriod, licenseState);
        return new ActionWrapper(actionId, throttler, condition, transform, action);
    }
}

