/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.modelsnapshots;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.elasticsearch.xpack.core.ml.action.RevertModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class RestRevertModelSnapshotAction
extends BaseRestHandler {
    private final boolean DELETE_INTERVENING_DEFAULT = false;

    public RestRevertModelSnapshotAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/model_snapshots/{" + RevertModelSnapshotAction.Request.SNAPSHOT_ID.getPreferredName() + "}/_revert", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/model_snapshots/{" + RevertModelSnapshotAction.Request.SNAPSHOT_ID.getPreferredName() + "}/_revert", (RestHandler)this);
    }

    public String getName() {
        return "xpack_ml_revert_model_snapshot_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        RevertModelSnapshotAction.Request request;
        String jobId = restRequest.param(Job.ID.getPreferredName());
        String snapshotId = restRequest.param(RevertModelSnapshotAction.Request.SNAPSHOT_ID.getPreferredName());
        if (restRequest.hasContentOrSourceParam()) {
            XContentParser parser = restRequest.contentOrSourceParamParser();
            request = RevertModelSnapshotAction.Request.parseRequest((String)jobId, (String)snapshotId, (XContentParser)parser);
        } else {
            request = new RevertModelSnapshotAction.Request(jobId, snapshotId);
            request.setDeleteInterveningResults(restRequest.paramAsBoolean(RevertModelSnapshotAction.Request.DELETE_INTERVENING.getPreferredName(), false));
        }
        request.timeout(restRequest.paramAsTime("timeout", request.timeout()));
        request.masterNodeTimeout(restRequest.paramAsTime("master_timeout", request.masterNodeTimeout()));
        return channel -> client.execute((Action)RevertModelSnapshotAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestStatusToXContentListener(channel));
    }
}

