/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.metrics.percentiles.ParsedPercentiles;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles;

public class ParsedPercentilesBucket
extends ParsedPercentiles
implements Percentiles {
    private static ObjectParser<ParsedPercentilesBucket, Void> PARSER = new ObjectParser(ParsedPercentilesBucket.class.getSimpleName(), true, ParsedPercentilesBucket::new);

    @Override
    public String getType() {
        return "percentiles_bucket";
    }

    @Override
    public double percentile(double percent) throws IllegalArgumentException {
        Double value = (Double)this.percentiles.get(percent);
        if (value == null) {
            throw new IllegalArgumentException("Percent requested [" + String.valueOf(percent) + "] was not one of the computed percentiles. Available keys are: " + this.percentiles.keySet());
        }
        return value;
    }

    @Override
    public String percentileAsString(double percent) {
        double value = this.percentile(percent);
        String valueAsString = (String)this.percentilesAsString.get(percent);
        if (valueAsString != null) {
            return valueAsString;
        }
        return Double.toString(value);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("values");
        for (Map.Entry percent : this.percentiles.entrySet()) {
            double value = (Double)percent.getValue();
            boolean hasValue = !Double.isNaN(value);
            Double key = (Double)percent.getKey();
            builder.field(Double.toString(key), hasValue ? Double.valueOf(value) : null);
            String valueAsString = (String)this.percentilesAsString.get(key);
            if (!hasValue || valueAsString == null) continue;
            builder.field(key + "_as_string", valueAsString);
        }
        builder.endObject();
        return builder;
    }

    public static ParsedPercentilesBucket fromXContent(XContentParser parser, String name) throws IOException {
        ParsedPercentilesBucket aggregation = (ParsedPercentilesBucket)PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedPercentiles.declarePercentilesFields(PARSER);
    }
}

