/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;

public final class TransportCreateApiKeyAction
extends HandledTransportAction<CreateApiKeyRequest, CreateApiKeyResponse> {
    private final ApiKeyService apiKeyService;
    private final SecurityContext securityContext;
    private final CompositeRolesStore rolesStore;

    @Inject
    public TransportCreateApiKeyAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, ApiKeyService apiKeyService, SecurityContext context, IndexNameExpressionResolver indexNameExpressionResolver, CompositeRolesStore rolesStore) {
        super(settings, "cluster:admin/xpack/security/api_key/create", threadPool, transportService, actionFilters, indexNameExpressionResolver, CreateApiKeyRequest::new);
        this.apiKeyService = apiKeyService;
        this.securityContext = context;
        this.rolesStore = rolesStore;
    }

    protected void doExecute(CreateApiKeyRequest request, ActionListener<CreateApiKeyResponse> listener) {
        Authentication authentication = this.securityContext.getAuthentication();
        if (authentication == null) {
            listener.onFailure((Exception)new IllegalStateException("authentication is required"));
        } else {
            if (Authentication.AuthenticationType.API_KEY == authentication.getAuthenticationType() && this.grantsAnyPrivileges(request)) {
                listener.onFailure((Exception)new IllegalArgumentException("creating derived api keys requires an explicit role descriptor that is empty (has no privileges)"));
                return;
            }
            this.rolesStore.getRoleDescriptors(new HashSet<String>(Arrays.asList(authentication.getUser().roles())), (ActionListener<Set<RoleDescriptor>>)ActionListener.wrap(roleDescriptors -> this.apiKeyService.createApiKey(authentication, request, (Set<RoleDescriptor>)roleDescriptors, listener), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private boolean grantsAnyPrivileges(CreateApiKeyRequest request) {
        return request.getRoleDescriptors() == null || request.getRoleDescriptors().isEmpty() || false == request.getRoleDescriptors().stream().allMatch(RoleDescriptor::isEmpty);
    }
}

