/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.Worker;
import net.sf.freecol.client.control.ConnectController;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.control.InGameInputHandler;
import net.sf.freecol.client.control.MapEditorController;
import net.sf.freecol.client.control.PreGameController;
import net.sf.freecol.client.control.PreGameInputHandler;
import net.sf.freecol.client.control.SoundController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.SwingGUI;
import net.sf.freecol.client.gui.action.ActionManager;
import net.sf.freecol.client.networking.UserServerAPI;
import net.sf.freecol.common.FreeColSeed;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDataFile;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.io.FreeColTcFile;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.networking.ServerAPI;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.resources.ResourceMapping;
import net.sf.freecol.server.FreeColServer;

public final class FreeColClient {
    private static final Logger logger = Logger.getLogger(FreeColClient.class.getName());
    private final ConnectController connectController;
    private final PreGameController preGameController;
    private final PreGameInputHandler preGameInputHandler;
    private final InGameController inGameController;
    private final InGameInputHandler inGameInputHandler;
    private final MapEditorController mapEditorController;
    private SoundController soundController;
    private FreeColServer freeColServer = null;
    private final ServerAPI serverAPI;
    private final GUI gui;
    private final ActionManager actionManager;
    private Game game;
    private Player player;
    private ClientOptions clientOptions;
    private final Worker worker;
    private boolean inGame = false;
    private boolean mapEditor = false;
    private boolean singlePlayer;
    private boolean loggedIn = false;
    private final boolean headless;

    public FreeColClient(InputStream splashStream, String fontName) {
        this(splashStream, fontName, 1.0f, true);
    }

    public FreeColClient(InputStream splashStream, String fontName, float scale, boolean headless) {
        boolean bl = this.headless = headless || System.getProperty("java.awt.headless", "false").equals("true");
        if (this.headless && (!FreeColDebugger.isInDebugMode() || FreeColDebugger.getDebugRunTurns() <= 0)) {
            FreeColClient.fatal(Messages.message("client.headlessDebug"));
        }
        this.gui = this.headless ? new GUI(this, scale) : new SwingGUI(this, scale);
        this.gui.displaySplashScreen(splashStream);
        File baseDirectory = FreeColDirectories.getBaseDirectory();
        FreeColDataFile baseData = null;
        String ioeMessage = null;
        if (baseDirectory.exists() && baseDirectory.isDirectory()) {
            try {
                baseData = new FreeColDataFile(baseDirectory);
            }
            catch (IOException ioe) {
                ioeMessage = ioe.getMessage();
            }
        }
        if (baseData == null) {
            FreeColClient.fatal(Messages.message(StringTemplate.template("client.baseData").addName("%dir%", baseDirectory.getName())) + (ioeMessage == null ? "" : "\n" + ioeMessage));
        }
        ResourceManager.setBaseMapping(baseData.getResourceMapping());
        this.serverAPI = new UserServerAPI(this.gui);
        this.connectController = new ConnectController(this);
        this.preGameController = new PreGameController(this);
        this.preGameInputHandler = new PreGameInputHandler(this);
        this.inGameController = new InGameController(this);
        this.inGameInputHandler = new InGameInputHandler(this);
        this.mapEditorController = new MapEditorController(this);
        this.worker = new Worker();
        this.worker.start();
        try {
            FreeColTcFile tcData = new FreeColTcFile("classic");
            ResourceManager.setTcMapping(tcData.getResourceMapping());
        }
        catch (IOException e) {
            FreeColClient.fatal(Messages.message("client.classic") + "\n" + e.getMessage());
        }
        if (!this.headless) {
            try {
                this.gui.installLookAndFeel(fontName);
            }
            catch (Exception e) {
                FreeColClient.fatal(Messages.message("client.laf") + "\n" + e.getMessage());
            }
        }
        this.actionManager = new ActionManager(this);
        this.actionManager.initializeActions(this.inGameController, this.connectController);
    }

    public void startClient(Dimension size, String userMsg, boolean sound, boolean showOpeningVideo, File savedGame, Specification spec) {
        if (this.headless && savedGame == null && spec == null) {
            FreeColClient.fatal(Messages.message("client.headlessRequires"));
        }
        this.clientOptions = this.loadClientOptions(savedGame);
        this.clientOptions.fixClientOptions();
        ResourceMapping modMappings = new ResourceMapping();
        for (FreeColModFile f : this.clientOptions.getActiveMods()) {
            modMappings.addAll(f.getResourceMapping());
        }
        ResourceManager.setModMapping(modMappings);
        if (this.actionManager != null) {
            this.updateActions();
        }
        this.soundController = new SoundController(this, sound);
        this.gui.hideSplashScreen();
        this.gui.startGUI(size);
        if (savedGame != null) {
            this.soundController.playSound("sound.intro.general");
            SwingUtilities.invokeLater(() -> {
                if (!this.connectController.startSavedGame(savedGame, userMsg)) {
                    this.gui.showMainPanel(userMsg);
                }
            });
        } else if (spec != null) {
            this.soundController.playSound("sound.intro.general");
            SwingUtilities.invokeLater(() -> {
                if (!this.connectController.startSinglePlayerGame(spec, true)) {
                    this.gui.showMainPanel(userMsg);
                }
            });
        } else if (showOpeningVideo) {
            SwingUtilities.invokeLater(() -> this.gui.showOpeningVideo(userMsg));
        } else {
            this.soundController.playSound("sound.intro.general");
            SwingUtilities.invokeLater(() -> this.gui.showMainPanel(userMsg));
        }
        String quit = "FreeColClient:Quit Game";
        Runtime.getRuntime().addShutdownHook(new Thread(quit){

            @Override
            public void run() {
                FreeColClient.this.getConnectController().quitGame(true);
            }
        });
    }

    private ClientOptions loadClientOptions(File savedGameFile) {
        File userOptions;
        ClientOptions clop = new ClientOptions();
        logger.info("Load default client options.");
        clop.load(FreeColDirectories.getBaseClientOptionsFile());
        if (this.actionManager != null) {
            logger.info("Load client options from the action manager.");
            clop.add(this.actionManager);
        }
        if (savedGameFile != null) {
            try {
                FreeColSavegameFile fcsf = new FreeColSavegameFile(savedGameFile);
                logger.info("Merge client options from saved game: " + savedGameFile.getPath());
                clop.merge(fcsf);
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Could not open saved game " + savedGameFile.getPath(), ioe);
            }
        }
        if ((userOptions = FreeColDirectories.getClientOptionsFile()) != null && userOptions.exists()) {
            logger.info("Merge client options from user options file: " + userOptions.getPath());
            clop.merge(userOptions);
        }
        return clop;
    }

    public static void fatal(String err) {
        logger.log(Level.SEVERE, err);
        FreeCol.fatal(err);
    }

    public ConnectController getConnectController() {
        return this.connectController;
    }

    public PreGameController getPreGameController() {
        return this.preGameController;
    }

    public PreGameInputHandler getPreGameInputHandler() {
        return this.preGameInputHandler;
    }

    public InGameController getInGameController() {
        return this.inGameController;
    }

    public InGameInputHandler getInGameInputHandler() {
        return this.inGameInputHandler;
    }

    public MapEditorController getMapEditorController() {
        return this.mapEditorController;
    }

    public SoundController getSoundController() {
        return this.soundController;
    }

    public FreeColServer getFreeColServer() {
        return this.freeColServer;
    }

    public void setFreeColServer(FreeColServer freeColServer) {
        this.freeColServer = freeColServer;
    }

    public ServerAPI askServer() {
        return this.serverAPI;
    }

    public GUI getGUI() {
        return this.gui;
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    public Game getGame() {
        return this.game;
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public Player getMyPlayer() {
        return this.player;
    }

    public void setMyPlayer(Player player) {
        this.player = player;
    }

    public ClientOptions getClientOptions() {
        return this.clientOptions;
    }

    public boolean tutorialMode() {
        return this.getClientOptions().getBoolean("model.option.guiShowTutorial");
    }

    public boolean isInGame() {
        return this.inGame;
    }

    public void setInGame(boolean inGame) {
        this.inGame = inGame;
    }

    public boolean isMapEditor() {
        return this.mapEditor;
    }

    public void setMapEditor(boolean mapEditor) {
        this.mapEditor = mapEditor;
    }

    public boolean isSinglePlayer() {
        return this.singlePlayer;
    }

    public void setSinglePlayer(boolean singlePlayer) {
        this.singlePlayer = singlePlayer;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public void setLoggedIn(boolean loggedIn) {
        this.loggedIn = loggedIn;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public void updateActions() {
        this.actionManager.update();
    }

    public void addSpecificationActions(Specification specification) {
        this.actionManager.addSpecificationActions(specification);
    }

    public boolean isAdmin() {
        return this.player != null && this.player.isAdmin();
    }

    public boolean canSaveCurrentGame() {
        return this.freeColServer != null && (this.isAdmin() || this.freeColServer.getGameState() != FreeColServer.GameState.IN_GAME);
    }

    public boolean currentPlayerIsMyPlayer() {
        return this.inGame && this.game != null && this.player != null && this.player.equals(this.game.getCurrentPlayer());
    }

    public int getAnimationSpeed(Player player) {
        String key = this.getMyPlayer() == player ? "model.option.moveAnimationSpeed" : "model.option.enemyMoveAnimationSpeed";
        return this.getClientOptions().getInteger(key);
    }

    public List<Colony> getMySortedColonies() {
        return this.clientOptions == null || this.player == null ? Collections.emptyList() : this.clientOptions.getSortedColonies(this.player);
    }

    public void setWork(Runnable runnable) {
        this.worker.schedule(runnable);
    }

    public void newGame(boolean prompt) {
        Specification specification = null;
        if (this.getGame() != null) {
            if (this.isMapEditor()) {
                specification = this.getGame().getSpecification();
            } else if (!prompt || this.gui.confirmStopGame()) {
                this.getConnectController().quitGame(true);
                FreeColSeed.incrementFreeColSeed();
            } else {
                return;
            }
        }
        this.gui.removeInGameComponents();
        this.gui.showNewPanel(specification);
    }

    public void continuePlaying() {
        this.askServer().continuePlaying();
    }

    public void skipTurns(int turns) {
        if (this.freeColServer == null) {
            return;
        }
        if (turns <= 0) {
            this.freeColServer.getInGameController().setSkippedTurns(0);
            return;
        }
        this.gui.closeMenus();
        this.freeColServer.getInGameController().setSkippedTurns(turns);
        this.askServer().startSkipping();
    }

    public void askToQuit() {
        if (this.gui.confirm("quitDialog.areYouSure.text", "ok", "cancel")) {
            this.quit();
        }
    }

    public void retire() {
        if (this.gui.confirm("retireDialog.areYouSure.text", "ok", "cancel")) {
            Player player = this.getMyPlayer();
            player.changePlayerType(Player.PlayerType.RETIRED);
            this.askServer().retire();
            this.gui.showHighScoresPanel(null, this.askServer().getHighScores());
        }
    }

    public void quit() {
        this.getConnectController().quitGame(this.isSinglePlayer());
        try {
            String[] flist;
            long validPeriod = 86400000L * (long)this.clientOptions.getInteger("model.option.autosaveValidity");
            long timeNow = System.currentTimeMillis();
            File autoSave = FreeColDirectories.getAutosaveDirectory();
            if (validPeriod != 0L && autoSave != null && (flist = autoSave.list()) != null) {
                for (String f : flist) {
                    File saveGameFile;
                    if (!f.endsWith(".fsg") || (saveGameFile = new File(autoSave, f)).lastModified() + validPeriod >= timeNow) continue;
                    saveGameFile.delete();
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to delete autosave", e);
        }
        try {
            this.gui.quit();
        }
        catch (Exception e) {
            System.exit(1);
        }
        System.exit(0);
    }
}

