//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#ifndef _GPDLINETOOL_H
#define _GPDLINETOOL_H

#include "declarations.h"

#include <string>
#include <iostream>

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

/// a class that has some tools to extrcat data from a line
/** the data is stored in key - value pairs like key="value"
    for example type="waypoint" or latitude="47.0000"
*/
class GPDLineTool
{

     public:
      ///  fills the private string 'line' with the given string
      void operator<< (string);
      /// same as operator<<  
      void setLine(string);

      /// gets exactly one line from istream 
      void readLine(istream &);

      /// retuns the value of key ...
      string readValue(string key);

      /// returns the string thas is worked on
      string line(void);

      /// same as above, kept for backward compatibility, don't use it !
      string getLine(void);

      /// string to double 
      double s2d(string);

      /// string to float
      float s2f(string);

      /// double to string , 5 digits after point !
      string d2s(double);

      /// double to string , rounds
      string d2s(double,int);

      /// float to string
      string f2s(float);

      /// float to string, rounds 
      string f2s(float,int);

		/// long to string
		string l2s(long);
		string toGPD(long);

		/// int to string
		string i2s(int);

      /// string to int
      int s2i(string);

      /// string to long
      long s2l(string);

      /// replaces " by \" and so on
      string toGPD(string);

      // int to string
      string toGPD(int);

      // int to string
      string toString(int);

   protected:

   private:
      string sline;

};

}
#endif
