/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Interner;
import java.io.File;
import java.util.Optional;
import java.util.function.Predicate;
import net.rubygrapefruit.platform.NativeIntegrationUnavailableException;
import net.rubygrapefruit.platform.file.FileSystems;
import org.apache.tools.ant.DirectoryScanner;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.BuildSessionScopeFileTimeStampInspector;
import org.gradle.api.internal.changedetection.state.CachingFileHasher;
import org.gradle.api.internal.changedetection.state.CrossBuildFileHashCache;
import org.gradle.api.internal.changedetection.state.DefaultResourceSnapshotterCacheService;
import org.gradle.api.internal.changedetection.state.FileHasherStatistics;
import org.gradle.api.internal.changedetection.state.GradleUserHomeScopeFileTimeStampInspector;
import org.gradle.api.internal.changedetection.state.PropertiesFileFilter;
import org.gradle.api.internal.changedetection.state.ResourceEntryFilter;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.api.internal.changedetection.state.ResourceSnapshotterCacheService;
import org.gradle.api.internal.changedetection.state.SplitFileHasher;
import org.gradle.api.internal.changedetection.state.SplitResourceSnapshotterCacheService;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.initialization.loadercache.DefaultClasspathHasher;
import org.gradle.cache.GlobalCacheLocations;
import org.gradle.cache.IndexedCache;
import org.gradle.cache.IndexedCacheParameters;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.cache.scopes.BuildTreeScopedCacheBuilderFactory;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.internal.buildoption.IntegerInternalOption;
import org.gradle.internal.buildoption.InternalFlag;
import org.gradle.internal.buildoption.InternalOption;
import org.gradle.internal.buildoption.InternalOptions;
import org.gradle.internal.classloader.ClasspathHasher;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.execution.FileCollectionFingerprinterRegistry;
import org.gradle.internal.execution.FileCollectionSnapshotter;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.OutputSnapshotter;
import org.gradle.internal.execution.impl.DefaultFileCollectionFingerprinterRegistry;
import org.gradle.internal.execution.impl.DefaultInputFingerprinter;
import org.gradle.internal.execution.impl.DefaultOutputSnapshotter;
import org.gradle.internal.file.DefaultFileSystemDefaultExcludesProvider;
import org.gradle.internal.file.FileHierarchySet;
import org.gradle.internal.file.FileMetadataAccessor;
import org.gradle.internal.file.FileSystemDefaultExcludesProvider;
import org.gradle.internal.file.Stat;
import org.gradle.internal.fingerprint.LineEndingSensitivity;
import org.gradle.internal.fingerprint.classpath.ClasspathFingerprinter;
import org.gradle.internal.fingerprint.classpath.impl.DefaultClasspathFingerprinter;
import org.gradle.internal.fingerprint.impl.DefaultFileCollectionSnapshotter;
import org.gradle.internal.fingerprint.impl.FileCollectionFingerprinterRegistrations;
import org.gradle.internal.hash.DefaultFileHasher;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.nativeintegration.NativeCapabilities;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.service.PrivateService;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.scopes.AbstractGradleModuleServices;
import org.gradle.internal.service.scopes.DefaultFileChangeListeners;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.internal.snapshot.impl.DirectorySnapshotterStatistics;
import org.gradle.internal.vfs.FileSystemAccess;
import org.gradle.internal.vfs.VirtualFileSystem;
import org.gradle.internal.vfs.impl.DefaultFileSystemAccess;
import org.gradle.internal.vfs.impl.DefaultSnapshotHierarchy;
import org.gradle.internal.watch.registry.FileWatcherRegistryFactory;
import org.gradle.internal.watch.registry.impl.DarwinFileWatcherRegistryFactory;
import org.gradle.internal.watch.registry.impl.LinuxFileWatcherRegistryFactory;
import org.gradle.internal.watch.registry.impl.WindowsFileWatcherRegistryFactory;
import org.gradle.internal.watch.vfs.BuildLifecycleAwareVirtualFileSystem;
import org.gradle.internal.watch.vfs.FileChangeListeners;
import org.gradle.internal.watch.vfs.WatchableFileSystemDetector;
import org.gradle.internal.watch.vfs.impl.DefaultWatchableFileSystemDetector;
import org.gradle.internal.watch.vfs.impl.FileWatchingFilter;
import org.gradle.internal.watch.vfs.impl.WatchingNotSupportedVirtualFileSystem;
import org.gradle.internal.watch.vfs.impl.WatchingVirtualFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualFileSystemServices
extends AbstractGradleModuleServices {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualFileSystemServices.class);
    public static final InternalFlag VFS_DROP_PROPERTY = new InternalFlag("org.gradle.vfs.drop");
    private static final int DEFAULT_MAX_HIERARCHIES_TO_WATCH = 50;
    public static final IntegerInternalOption MAX_HIERARCHIES_TO_WATCH_PROPERTY = new IntegerInternalOption("org.gradle.vfs.watch.hierarchies.max", 50);
    private static final int FILE_HASHER_MEMORY_CACHE_SIZE = 400000;

    public static boolean isDropVfs(InternalOptions options) {
        return (Boolean)options.getOption((InternalOption)VFS_DROP_PROPERTY).get();
    }

    public static int getMaximumNumberOfWatchedHierarchies(InternalOptions options) {
        return (Integer)options.getOption((InternalOption)MAX_HIERARCHIES_TO_WATCH_PROPERTY).get();
    }

    public void registerGlobalServices(ServiceRegistration registration) {
        registration.addProvider((ServiceRegistrationProvider)new GlobalScopeServices());
    }

    public void registerGradleUserHomeServices(ServiceRegistration registration) {
        registration.addProvider((ServiceRegistrationProvider)new GradleUserHomeServices());
    }

    public void registerBuildSessionServices(ServiceRegistration registration) {
        registration.addProvider((ServiceRegistrationProvider)new BuildSessionServices());
    }

    @VisibleForTesting
    static class BuildSessionServices
    implements ServiceRegistrationProvider {
        BuildSessionServices() {
        }

        @Provides
        FileSystemDefaultExcludesProvider createFileSystemDefaultExcludesProvider(ListenerManager listenerManager) {
            return new DefaultFileSystemDefaultExcludesProvider(listenerManager);
        }

        @Provides
        @PrivateService
        CrossBuildFileHashCache createCrossBuildFileHashCache(BuildTreeScopedCacheBuilderFactory cacheBuilderFactory, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
            return new CrossBuildFileHashCache(cacheBuilderFactory, inMemoryCacheDecoratorFactory, CrossBuildFileHashCache.Kind.FILE_HASHES);
        }

        @Provides
        FileHasher createFileHasher(GlobalCacheLocations globalCacheLocations, BuildSessionScopeFileTimeStampInspector fileTimeStampInspector, CrossBuildFileHashCache cacheAccess, FileHasher globalHasher, FileSystem fileSystem, StreamHasher streamHasher, StringInterner stringInterner, FileHasherStatistics.Collector statisticsCollector) {
            CachingFileHasher localHasher = new CachingFileHasher((FileHasher)new DefaultFileHasher(streamHasher), cacheAccess, stringInterner, fileTimeStampInspector, "fileHashes", fileSystem, 400000, statisticsCollector);
            return new SplitFileHasher(globalHasher, localHasher, globalCacheLocations);
        }

        @Provides
        FileSystemAccess createFileSystemAccess(FileHasher hasher, ListenerManager listenerManager, FileMetadataAccessor stat, StringInterner stringInterner, VirtualFileSystem root, FileSystemAccess.WriteListener writeListener, DirectorySnapshotterStatistics.Collector statisticsCollector) {
            DefaultFileSystemAccess buildSessionsScopedVirtualFileSystem = new DefaultFileSystemAccess(hasher, (Interner)stringInterner, stat, root, writeListener, statisticsCollector, DirectoryScanner.getDefaultExcludes());
            listenerManager.addListener((Object)buildSessionsScopedVirtualFileSystem);
            listenerManager.addListener(arg_0 -> ((DefaultFileSystemAccess)buildSessionsScopedVirtualFileSystem).invalidate(arg_0));
            return buildSessionsScopedVirtualFileSystem;
        }

        @Provides
        FileCollectionSnapshotter createFileCollectionSnapshotter(FileSystemAccess fileSystemAccess, Stat stat) {
            return new DefaultFileCollectionSnapshotter(fileSystemAccess, stat);
        }

        @Provides
        OutputSnapshotter createOutputSnapshotter(FileCollectionSnapshotter fileCollectionSnapshotter) {
            return new DefaultOutputSnapshotter(fileCollectionSnapshotter);
        }

        @Provides
        FileCollectionFingerprinterRegistrations createFileCollectionFingerprinterRegistrations(StringInterner stringInterner, FileCollectionSnapshotter fileCollectionSnapshotter, ResourceSnapshotterCacheService resourceSnapshotterCacheService) {
            return new FileCollectionFingerprinterRegistrations(stringInterner, fileCollectionSnapshotter, resourceSnapshotterCacheService, ResourceFilter.FILTER_NOTHING, ResourceEntryFilter.FILTER_NOTHING, PropertiesFileFilter.FILTER_NOTHING);
        }

        @Provides
        FileCollectionFingerprinterRegistry createFileCollectionFingerprinterRegistry(FileCollectionFingerprinterRegistrations fileCollectionFingerprinterRegistrations) {
            return new DefaultFileCollectionFingerprinterRegistry(fileCollectionFingerprinterRegistrations.getRegistrants());
        }

        @Provides
        InputFingerprinter createInputFingerprinter(FileCollectionSnapshotter snapshotter, FileCollectionFingerprinterRegistry fingerprinterRegistry, ValueSnapshotter valueSnapshotter) {
            return new DefaultInputFingerprinter(snapshotter, fingerprinterRegistry, valueSnapshotter);
        }

        @Provides
        ResourceSnapshotterCacheService createResourceSnapshotterCacheService(GlobalCacheLocations globalCacheLocations, CrossBuildFileHashCache store, ResourceSnapshotterCacheService globalCache) {
            IndexedCache resourceHashesCache = store.createIndexedCache(IndexedCacheParameters.of((String)"resourceHashesCache", HashCode.class, (Serializer)new HashCodeSerializer()), 800000, true);
            DefaultResourceSnapshotterCacheService localCache = new DefaultResourceSnapshotterCacheService(resourceHashesCache);
            return new SplitResourceSnapshotterCacheService(globalCache, localCache, globalCacheLocations);
        }
    }

    @VisibleForTesting
    static class GradleUserHomeServices
    implements ServiceRegistrationProvider {
        GradleUserHomeServices() {
        }

        @Provides
        @PrivateService
        CrossBuildFileHashCache createCrossBuildFileHashCache(GlobalScopedCacheBuilderFactory cacheBuilderFactory, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
            return new CrossBuildFileHashCache(cacheBuilderFactory, inMemoryCacheDecoratorFactory, CrossBuildFileHashCache.Kind.FILE_HASHES);
        }

        @Provides
        FileHasher createCachingFileHasher(FileHasherStatistics.Collector statisticsCollector, CrossBuildFileHashCache fileStore, FileSystem fileSystem, GradleUserHomeScopeFileTimeStampInspector fileTimeStampInspector, StreamHasher streamHasher, StringInterner stringInterner) {
            CachingFileHasher fileHasher = new CachingFileHasher((FileHasher)new DefaultFileHasher(streamHasher), fileStore, stringInterner, fileTimeStampInspector, "fileHashes", fileSystem, 400000, statisticsCollector);
            fileTimeStampInspector.attach(fileHasher);
            return fileHasher;
        }

        @Provides
        FileWatchingFilter createFileWatchingFilter(GlobalCacheLocations globalCacheLocations, ListenerManager listenerManager) {
            final FileWatchingFilter fileWatchingFilter = new FileWatchingFilter(globalCacheLocations.getCacheRoots());
            listenerManager.addListener((Object)new RootBuildLifecycleListener(){

                @Override
                public void afterStart() {
                    fileWatchingFilter.buildStarted();
                }

                @Override
                public void beforeComplete() {
                    fileWatchingFilter.buildFinished();
                }
            });
            return fileWatchingFilter;
        }

        @Provides
        WatchableFileSystemDetector createWatchableFileSystemDetector(FileSystems fileSystems) {
            return new DefaultWatchableFileSystemDetector(fileSystems);
        }

        @Provides
        BuildLifecycleAwareVirtualFileSystem createVirtualFileSystem(FileWatchingFilter fileWatchingFilter, DocumentationRegistry documentationRegistry, NativeCapabilities nativeCapabilities, ListenerManager listenerManager, FileChangeListeners fileChangeListeners, FileSystem fileSystem, WatchableFileSystemDetector watchableFileSystemDetector) {
            CaseSensitivity caseSensitivity = fileSystem.isCaseSensitive() ? CaseSensitivity.CASE_SENSITIVE : CaseSensitivity.CASE_INSENSITIVE;
            SnapshotHierarchy root = DefaultSnapshotHierarchy.empty((CaseSensitivity)caseSensitivity);
            BuildLifecycleAwareVirtualFileSystem virtualFileSystem = GradleUserHomeServices.determineWatcherRegistryFactory(OperatingSystem.current(), nativeCapabilities, arg_0 -> ((FileHierarchySet)fileWatchingFilter.getImmutableLocations()).contains(arg_0)).map(watcherRegistryFactory -> new WatchingVirtualFileSystem(watcherRegistryFactory, root, sectionId -> documentationRegistry.getDocumentationRecommendationFor("details", "file_system_watching", sectionId), fileWatchingFilter, watchableFileSystemDetector, fileChangeListeners)).orElse((BuildLifecycleAwareVirtualFileSystem)new WatchingNotSupportedVirtualFileSystem(root));
            listenerManager.addListener(buildState -> {
                File buildRootDir = buildState.getBuildRootDir();
                virtualFileSystem.registerWatchableHierarchy(buildRootDir);
            });
            return virtualFileSystem;
        }

        @Provides
        FileSystemAccess createFileSystemAccess(FileHasher hasher, VirtualFileSystem virtualFileSystem, FileMetadataAccessor stat, StringInterner stringInterner, FileSystemAccess.WriteListener writeListener, DirectorySnapshotterStatistics.Collector statisticsCollector, ListenerManager listenerManager) {
            DefaultFileSystemAccess defaultFileSystemAccess = new DefaultFileSystemAccess(hasher, (Interner)stringInterner, stat, virtualFileSystem, writeListener, statisticsCollector, DirectoryScanner.getDefaultExcludes());
            listenerManager.addListener((Object)defaultFileSystemAccess);
            return defaultFileSystemAccess;
        }

        private static Optional<FileWatcherRegistryFactory> determineWatcherRegistryFactory(OperatingSystem operatingSystem, NativeCapabilities nativeCapabilities, Predicate<String> immutableLocationsFilter) {
            if (nativeCapabilities.useFileSystemWatching()) {
                try {
                    if (operatingSystem.isMacOsX()) {
                        return Optional.of(new DarwinFileWatcherRegistryFactory(immutableLocationsFilter));
                    }
                    if (operatingSystem.isWindows()) {
                        return Optional.of(new WindowsFileWatcherRegistryFactory(immutableLocationsFilter));
                    }
                    if (operatingSystem.isLinux()) {
                        return Optional.of(new LinuxFileWatcherRegistryFactory(immutableLocationsFilter));
                    }
                }
                catch (NativeIntegrationUnavailableException e) {
                    NativeServices.logFileSystemWatchingUnavailable((NativeIntegrationUnavailableException)e);
                }
            }
            return Optional.empty();
        }

        @Provides
        FileCollectionSnapshotter createFileCollectionSnapshotter(FileSystemAccess fileSystemAccess, Stat stat) {
            return new DefaultFileCollectionSnapshotter(fileSystemAccess, stat);
        }

        @Provides
        ResourceSnapshotterCacheService createResourceSnapshotterCacheService(CrossBuildFileHashCache store) {
            IndexedCache resourceHashesCache = store.createIndexedCache(IndexedCacheParameters.of((String)"resourceHashesCache", HashCode.class, (Serializer)new HashCodeSerializer()), 400000, true);
            return new DefaultResourceSnapshotterCacheService(resourceHashesCache);
        }

        @Provides
        ClasspathFingerprinter createClasspathFingerprinter(ResourceSnapshotterCacheService resourceSnapshotterCacheService, FileCollectionSnapshotter fileCollectionSnapshotter, StringInterner stringInterner) {
            return new DefaultClasspathFingerprinter(resourceSnapshotterCacheService, fileCollectionSnapshotter, ResourceFilter.FILTER_NOTHING, ResourceEntryFilter.FILTER_NOTHING, PropertiesFileFilter.FILTER_NOTHING, stringInterner, LineEndingSensitivity.DEFAULT);
        }

        @Provides
        ClasspathHasher createClasspathHasher(ClasspathFingerprinter fingerprinter, FileCollectionFactory fileCollectionFactory) {
            return new DefaultClasspathHasher(fingerprinter, fileCollectionFactory);
        }

        @Provides
        FileChangeListeners createFileChangeListeners(ListenerManager listenerManager) {
            return new DefaultFileChangeListeners(listenerManager);
        }
    }

    private static class GlobalScopeServices
    implements ServiceRegistrationProvider {
        private GlobalScopeServices() {
        }

        @Provides
        FileHasherStatistics.Collector createCachingFileHasherStatisticsCollector() {
            return new FileHasherStatistics.Collector();
        }

        @Provides
        DirectorySnapshotterStatistics.Collector createDirectorySnapshotterStatisticsCollector() {
            return new DirectorySnapshotterStatistics.Collector();
        }
    }
}

