/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.core.settings.TimeoutConstraint;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.url.BasicURLHandler;
import org.apache.ivy.util.url.TimeoutConstrainedURLHandler;
import org.apache.ivy.util.url.URLHandler;

public class URLHandlerDispatcher
implements TimeoutConstrainedURLHandler {
    private final Map<String, URLHandler> handlers = new HashMap<String, URLHandler>();
    private URLHandler defaultHandler = new BasicURLHandler();

    @Override
    public boolean isReachable(URL url) {
        return this.isReachable(url, null);
    }

    @Override
    public boolean isReachable(URL url, int timeout) {
        return this.isReachable(url, URLHandlerDispatcher.createTimeoutConstraints(timeout));
    }

    @Override
    public boolean isReachable(URL url, TimeoutConstraint timeoutConstraint) {
        URLHandler handler = this.getHandler(url.getProtocol());
        if (handler instanceof TimeoutConstrainedURLHandler) {
            return ((TimeoutConstrainedURLHandler)handler).isReachable(url, timeoutConstraint);
        }
        return handler.isReachable(url, timeoutConstraint != null ? timeoutConstraint.getConnectionTimeout() : 0);
    }

    @Override
    public long getContentLength(URL url) {
        return this.getContentLength(url, null);
    }

    @Override
    public long getContentLength(URL url, int timeout) {
        return this.getContentLength(url, URLHandlerDispatcher.createTimeoutConstraints(timeout));
    }

    @Override
    public long getContentLength(URL url, TimeoutConstraint timeoutConstraint) {
        URLHandler handler = this.getHandler(url.getProtocol());
        if (handler instanceof TimeoutConstrainedURLHandler) {
            return ((TimeoutConstrainedURLHandler)handler).getContentLength(url, timeoutConstraint);
        }
        return handler.getContentLength(url, timeoutConstraint != null ? timeoutConstraint.getConnectionTimeout() : 0);
    }

    @Override
    public long getLastModified(URL url) {
        return this.getLastModified(url, null);
    }

    @Override
    public long getLastModified(URL url, int timeout) {
        return this.getLastModified(url, URLHandlerDispatcher.createTimeoutConstraints(timeout));
    }

    @Override
    public long getLastModified(URL url, TimeoutConstraint timeoutConstraint) {
        URLHandler handler = this.getHandler(url.getProtocol());
        if (handler instanceof TimeoutConstrainedURLHandler) {
            return ((TimeoutConstrainedURLHandler)handler).getLastModified(url, timeoutConstraint);
        }
        return handler.getLastModified(url, timeoutConstraint != null ? timeoutConstraint.getConnectionTimeout() : 0);
    }

    @Override
    public URLHandler.URLInfo getURLInfo(URL url) {
        return this.getURLInfo(url, null);
    }

    @Override
    public URLHandler.URLInfo getURLInfo(URL url, int timeout) {
        return this.getURLInfo(url, URLHandlerDispatcher.createTimeoutConstraints(timeout));
    }

    @Override
    public URLHandler.URLInfo getURLInfo(URL url, TimeoutConstraint timeoutConstraint) {
        URLHandler handler = this.getHandler(url.getProtocol());
        if (handler instanceof TimeoutConstrainedURLHandler) {
            return ((TimeoutConstrainedURLHandler)handler).getURLInfo(url, timeoutConstraint);
        }
        return handler.getURLInfo(url, timeoutConstraint != null ? timeoutConstraint.getConnectionTimeout() : 0);
    }

    @Override
    public InputStream openStream(URL url) throws IOException {
        return this.openStream(url, null);
    }

    @Override
    public InputStream openStream(URL url, TimeoutConstraint timeoutConstraint) throws IOException {
        URLHandler handler = this.getHandler(url.getProtocol());
        if (handler instanceof TimeoutConstrainedURLHandler) {
            return ((TimeoutConstrainedURLHandler)handler).openStream(url, timeoutConstraint);
        }
        return handler.openStream(url);
    }

    @Override
    public void download(URL src, File dest, CopyProgressListener l) throws IOException {
        this.download(src, dest, l, null);
    }

    @Override
    public void download(URL src, File dest, CopyProgressListener listener, TimeoutConstraint timeoutConstraint) throws IOException {
        URLHandler handler = this.getHandler(src.getProtocol());
        if (handler instanceof TimeoutConstrainedURLHandler) {
            ((TimeoutConstrainedURLHandler)handler).download(src, dest, listener, timeoutConstraint);
            return;
        }
        handler.download(src, dest, listener);
    }

    @Override
    public void upload(File src, URL dest, CopyProgressListener l) throws IOException {
        this.upload(src, dest, l, null);
    }

    @Override
    public void upload(File src, URL dest, CopyProgressListener listener, TimeoutConstraint timeoutConstraint) throws IOException {
        URLHandler handler = this.getHandler(dest.getProtocol());
        if (handler instanceof TimeoutConstrainedURLHandler) {
            ((TimeoutConstrainedURLHandler)handler).upload(src, dest, listener, timeoutConstraint);
            return;
        }
        handler.upload(src, dest, listener);
    }

    @Override
    public void setRequestMethod(int requestMethod) {
        this.defaultHandler.setRequestMethod(requestMethod);
        for (URLHandler handler : this.handlers.values()) {
            handler.setRequestMethod(requestMethod);
        }
    }

    public void setDownloader(String protocol, URLHandler downloader) {
        this.handlers.put(protocol, downloader);
    }

    public URLHandler getHandler(String protocol) {
        URLHandler downloader = this.handlers.get(protocol);
        return downloader == null ? this.defaultHandler : downloader;
    }

    public URLHandler getDefault() {
        return this.defaultHandler;
    }

    public void setDefault(URLHandler default1) {
        this.defaultHandler = default1;
    }

    private static TimeoutConstraint createTimeoutConstraints(final int connectionTimeout) {
        return new TimeoutConstraint(){

            @Override
            public int getConnectionTimeout() {
                return connectionTimeout;
            }

            @Override
            public int getReadTimeout() {
                return -1;
            }
        };
    }
}

