/*
 * Decompiled with CFR 0.152.
 */
package smr.JavaDeps;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import smr.JavaDeps.DepTable;
import smr.JavaDeps.InvalidOptionException;
import smr.JavaDeps.Java;
import smr.JavaDeps.ParameterEnumeration;
import smr.JavaDeps.ParseException;
import smr.JavaDeps.ParseOptions;

public class JavaDeps {
    public static PrintStream out = System.out;
    static String lineSeparator = System.getProperty("line.separator");
    static String version = "JavaDeps version 1.1";
    static String usage = "Usage: jdeps [options] [srcfile ... | -f file]" + lineSeparator + "For a list of options, use --help";
    static String copyright = "Copyright 1997,1998 Steve M. Robbins";
    static String bugs = "Please report bugs to <steve@nyongwa.montreal.qc.ca>";
    static String url = "http://www.cs.mcgill.ca/~stever/software/JavaDeps";
    static String buildCommand = "$(JAVACOMPILE)";
    static String headerBuildCommand = "$(JAVAHEADER)";
    static boolean buildStubs = false;
    static String classVariable = "CLASSES";
    static String destDir = null;
    static boolean jmkSyntax = false;
    static boolean emitComments = true;
    static boolean noBuildCommands = false;
    static boolean beVerbose = false;
    static boolean enableDebugging = false;

    static void die(String string) {
        System.err.println(string);
        System.err.println();
        System.err.println(bugs);
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        Object object;
        ParameterEnumeration parameterEnumeration;
        Object object2;
        ParseOptions parseOptions = null;
        String[] stringArray2 = new String[]{"debug", "help", "native", "silent", "version", "verbose", "jmk"};
        String[] stringArray3 = new String[]{"build", "classvar", "dir", "output"};
        try {
            parseOptions = new ParseOptions(stringArray, "hnvj", "bCdfo", stringArray2, stringArray3);
        }
        catch (InvalidOptionException invalidOptionException) {
            System.err.println(invalidOptionException.getMessage());
            System.exit(1);
        }
        enableDebugging = parseOptions.seenOption("debug");
        if (parseOptions.seenOption('h') || parseOptions.seenOption("help")) {
            JavaDeps.printHelp();
            System.exit(0);
        } else if (parseOptions.seenOption("version")) {
            JavaDeps.printVersion();
            System.exit(0);
        }
        noBuildCommands = parseOptions.seenOption('n');
        emitComments = parseOptions.seenOption("silent") ^ true;
        beVerbose = parseOptions.seenOption('v') || parseOptions.seenOption("verbose");
        boolean bl = jmkSyntax = parseOptions.seenOption('j') || parseOptions.seenOption("jmk");
        if (jmkSyntax) {
            buildCommand = "exec JAVACOMPILE COMPILEARGS";
        }
        buildCommand = parseOptions.getOptionArgument('b', buildCommand);
        buildCommand = parseOptions.getOptionArgument("build", buildCommand);
        if (parseOptions.seenOption("native")) {
            if ("stubs".equalsIgnoreCase(parseOptions.getOptionArgument("native"))) {
                buildStubs = true;
            }
        } else {
            headerBuildCommand = null;
        }
        classVariable = parseOptions.getOptionArgument('C', classVariable);
        classVariable = parseOptions.getOptionArgument("classvar", classVariable);
        destDir = parseOptions.getOptionArgument('d', destDir);
        destDir = parseOptions.getOptionArgument("dir", destDir);
        if (parseOptions.seenOption('f')) {
            try {
                object2 = new FileInputStream(parseOptions.getOptionArgument('f'));
                parameterEnumeration = new ParameterEnumeration((InputStream)object2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                parameterEnumeration = null;
                System.err.println(fileNotFoundException.getMessage());
                System.exit(1);
            }
        } else {
            parameterEnumeration = new ParameterEnumeration(parseOptions.getRemainingArgs());
        }
        if (parseOptions.seenOption('o') || parseOptions.seenOption("output")) {
            object2 = parseOptions.getOptionArgument('o');
            object2 = parseOptions.getOptionArgument("output", (String)object2);
            try {
                object = new FileOutputStream(parseOptions.getOptionArgument('o'));
                out = new PrintStream((OutputStream)object);
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                System.exit(1);
            }
        }
        if (!parameterEnumeration.hasMoreElements()) {
            JavaDeps.die(usage);
        }
        if (noBuildCommands) {
            buildCommand = null;
        }
        object2 = new DepTable(destDir);
        DepTable.setJmk(jmkSyntax);
        object = null;
        boolean bl2 = true;
        while (parameterEnumeration.hasMoreElements()) {
            String string = (String)parameterEnumeration.nextElement();
            JavaDeps.message("Processing file " + string);
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                ((DepTable)object2).startFile(string);
                if (object == null) {
                    object = new Java(fileInputStream);
                    ((Java)object).setTable((DepTable)object2);
                } else {
                    Java.ReInit(fileInputStream);
                }
                Java.CompilationUnit();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Can not find file: " + string);
                bl2 = false;
            }
            catch (ParseException parseException) {
                System.err.println("Parse error in file " + string + ":");
                System.err.println(parseException.getMessage());
                bl2 = false;
            }
            System.runFinalization();
            System.gc();
        }
        if (bl2) {
            JavaDeps.message("Successful parse; writing output");
            ((DepTable)object2).dump(enableDebugging, emitComments, buildStubs, buildCommand, headerBuildCommand, classVariable);
            if (parseOptions.seenOption('o')) {
                out.flush();
                out.close();
            }
        } else {
            System.err.println("Errors encountered; no output");
        }
    }

    static void message(String string) {
        if (beVerbose) {
            System.err.println(string);
        }
    }

    static void printHelp() {
        System.err.println(version);
        System.err.println(usage);
        System.err.println();
        System.err.println("  -b CMD, --build=CMD\tCommand used in build rules [" + buildCommand + "]");
        System.err.println("  -C VARNAME, --classvar=VARNAME");
        System.err.println("\t\t\tMakefile variable for classes [" + classVariable + "]");
        System.err.println("  -d DIR, --dir=DIR\tDirectory for class files");
        System.err.println("\t\t\tThis must be the same as in the javac command");
        System.err.println("  --debug\t\tEnable debugging");
        System.err.println("  -f FILE\t\tRead list of source files from FILE,");
        System.err.println("\t\t\trather than from the command line");
        System.err.println("  -h, --help\t\tShow this help text, then exit");
        System.err.println("  -j, --jmk\t\tGenerate jmk syntax rules");
        System.err.println("  -n\t\t\tDo not emit build commands");
        System.err.println("  --native\t\tOutput commands to build header files");
        System.err.println("  --native=stubs\tOutput commands to build both headers and stubs");
        System.err.println("  -o FILE, --output=FILE\tWrite output to FILE");
        System.err.println("  --silent\t\tDo not emit comments");
        System.err.println("  -v, --verbose\t\tBe verbose");
        System.err.println("  --version\t\tShow version, then exit");
        System.err.println();
        System.err.println(bugs);
    }

    static void printVersion() {
        System.err.println(version);
        System.err.println(copyright);
        System.err.println("See " + url + " for updates.");
        System.err.println();
        System.err.println(bugs);
    }
}

