/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.engine;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.Translucent;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.util.Vector;
import net.claribole.zvtm.engine.CameraPortal;

public class CameraPortalST
extends CameraPortal
implements Translucent {
    AlphaComposite acST;
    float alpha = 0.5f;

    public CameraPortalST(int x, int y, int w, int h, Camera c, float a) {
        super(x, y, w, h, c);
        this.alpha = a;
        this.acST = AlphaComposite.getInstance(3, this.alpha);
    }

    public void setTranslucencyValue(float a) {
        block2: {
            try {
                this.acST = AlphaComposite.getInstance(3, a);
                this.alpha = a;
            }
            catch (IllegalArgumentException ex) {
                if (!VirtualSpaceManager.debugModeON()) break block2;
                System.err.println("Error animating translucency of " + this.toString());
            }
        }
    }

    public float getTranslucencyValue() {
        return this.alpha;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g2d, int viewWidth, int viewHeight) {
        if (!this.visible) {
            return;
        }
        g2d.setClip(this.x, this.y, this.w, this.h);
        g2d.setComposite(this.acST);
        if (this.bkgColor != null) {
            g2d.setColor(this.bkgColor);
            g2d.fillRect(this.x, this.y, this.w, this.h);
        }
        this.standardStroke = g2d.getStroke();
        this.standardTransform = g2d.getTransform();
        Vector vector = this.drawnGlyphs = this.cameraSpace.getDrawnGlyphs(this.camIndex);
        synchronized (vector) {
            this.drawnGlyphs.removeAllElements();
            this.uncoef = (this.camera.focal + this.camera.altitude) / this.camera.focal;
            this.viewWC = (long)((float)this.camera.posx - (float)(this.w / 2) * this.uncoef);
            this.viewNC = (long)((float)this.camera.posy + (float)(this.h / 2) * this.uncoef);
            this.viewEC = (long)((float)this.camera.posx + (float)(this.w / 2) * this.uncoef);
            this.viewSC = (long)((float)this.camera.posy - (float)(this.h / 2) * this.uncoef);
            this.gll = this.cameraSpace.getDrawingList();
            for (int i = 0; i < this.gll.length; ++i) {
                if (this.gll[i] == null) continue;
                Glyph glyph = this.gll[i];
                synchronized (glyph) {
                    if (this.gll[i].visibleInRegion(this.viewWC, this.viewNC, this.viewEC, this.viewSC, this.camIndex)) {
                        this.gll[i].project(this.camera, this.size);
                        if (this.gll[i].isVisible()) {
                            this.gll[i].draw(g2d, this.w, this.h, this.camIndex, this.standardStroke, this.standardTransform, this.x, this.y);
                        }
                    }
                    continue;
                }
            }
        }
        g2d.setClip(0, 0, viewWidth, viewHeight);
        if (this.borderColor != null) {
            g2d.setColor(this.borderColor);
            g2d.drawRect(this.x, this.y, this.w, this.h);
        }
        g2d.setComposite(acO);
    }
}

