require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_BITOPS_H_)) {
    eval 'sub _SYS_BITOPS_H_ () {1;}' unless defined(&_SYS_BITOPS_H_);
    require 'sys/stdint.ph';
    unless(defined(&ffs32)) {
	eval 'sub ffs32 {
	    my($_n) = @_;
    	    eval q({ \'int\'  &_v;  &if (!$_n) 0;  &_v = 1;  &if (($_n & 0xffff) == 0) { $_n >>= 16;  &_v += 16; }  &if (($_n & 0xff) == 0) { $_n >>= 8;  &_v += 8; }  &if (($_n & 0xf) == 0) { $_n >>= 4;  &_v += 4; }  &if (($_n & 0x3) == 0) { $_n >>= 2;  &_v += 2; }  &if (($_n & 0x1) == 0) { $_n >>= 1;  &_v += 1; }  &_v; });
	}' unless defined(&ffs32);
    }
    unless(defined(&ffs64)) {
	eval 'sub ffs64 {
	    my($_n) = @_;
    	    eval q({ \'int\'  &_v;  &if (!$_n) 0;  &_v = 1;  &if (($_n & 0xffffffff) == 0) { $_n >>= 32;  &_v += 32; }  &if (($_n & 0xffff) == 0) { $_n >>= 16;  &_v += 16; }  &if (($_n & 0xff) == 0) { $_n >>= 8;  &_v += 8; }  &if (($_n & 0xf) == 0) { $_n >>= 4;  &_v += 4; }  &if (($_n & 0x3) == 0) { $_n >>= 2;  &_v += 2; }  &if (($_n & 0x1) == 0) { $_n >>= 1;  &_v += 1; }  &_v; });
	}' unless defined(&ffs64);
    }
    unless(defined(&fls32)) {
	eval 'sub fls32 {
	    my($_n) = @_;
    	    eval q({ \'int\'  &_v;  &if (!$_n) 0;  &_v = 32;  &if (($_n & 0xffff0000) == 0) { $_n <<= 16;  &_v -= 16; }  &if (($_n & 0xff000000) == 0) { $_n <<= 8;  &_v -= 8; }  &if (($_n & 0xf0000000) == 0) { $_n <<= 4;  &_v -= 4; }  &if (($_n & 0xc0000000) == 0) { $_n <<= 2;  &_v -= 2; }  &if (($_n & 0x80000000) == 0) { $_n <<= 1;  &_v -= 1; }  &_v; });
	}' unless defined(&fls32);
    }
    unless(defined(&fls64)) {
	eval 'sub fls64 {
	    my($_n) = @_;
    	    eval q({ \'int\'  &_v;  &if (!$_n) 0;  &_v = 64;  &if (($_n & 0xffffffff00000000) == 0) { $_n <<= 32;  &_v -= 32; }  &if (($_n & 0xffff000000000000) == 0) { $_n <<= 16;  &_v -= 16; }  &if (($_n & 0xff00000000000000) == 0) { $_n <<= 8;  &_v -= 8; }  &if (($_n & 0xf000000000000000) == 0) { $_n <<= 4;  &_v -= 4; }  &if (($_n & 0xc000000000000000) == 0) { $_n <<= 2;  &_v -= 2; }  &if (($_n & 0x8000000000000000) == 0) { $_n <<= 1;  &_v -= 1; }  &_v; });
	}' unless defined(&fls64);
    }
    eval 'sub _ilog2_helper {
        my($_n, $_x) = @_;
	    eval q((($_n) & (1 << ($_x))) ? $_x :);
    }' unless defined(&_ilog2_helper);
    eval 'sub _ilog2_const {
        my($_n) = @_;
	    eval q((  &_ilog2_helper($_n, 63)  &_ilog2_helper($_n, 62)  &_ilog2_helper($_n, 61)  &_ilog2_helper($_n, 60)  &_ilog2_helper($_n, 59)  &_ilog2_helper($_n, 58)  &_ilog2_helper($_n, 57)  &_ilog2_helper($_n, 56)  &_ilog2_helper($_n, 55)  &_ilog2_helper($_n, 54)  &_ilog2_helper($_n, 53)  &_ilog2_helper($_n, 52)  &_ilog2_helper($_n, 51)  &_ilog2_helper($_n, 50)  &_ilog2_helper($_n, 49)  &_ilog2_helper($_n, 48)  &_ilog2_helper($_n, 47)  &_ilog2_helper($_n, 46)  &_ilog2_helper($_n, 45)  &_ilog2_helper($_n, 44)  &_ilog2_helper($_n, 43)  &_ilog2_helper($_n, 42)  &_ilog2_helper($_n, 41)  &_ilog2_helper($_n, 40)  &_ilog2_helper($_n, 39)  &_ilog2_helper($_n, 38)  &_ilog2_helper($_n, 37)  &_ilog2_helper($_n, 36)  &_ilog2_helper($_n, 35)  &_ilog2_helper($_n, 34)  &_ilog2_helper($_n, 33)  &_ilog2_helper($_n, 32)  &_ilog2_helper($_n, 31)  &_ilog2_helper($_n, 30)  &_ilog2_helper($_n, 29)  &_ilog2_helper($_n, 28)  &_ilog2_helper($_n, 27)  &_ilog2_helper($_n, 26)  &_ilog2_helper($_n, 25)  &_ilog2_helper($_n, 24)  &_ilog2_helper($_n, 23)  &_ilog2_helper($_n, 22)  &_ilog2_helper($_n, 21)  &_ilog2_helper($_n, 20)  &_ilog2_helper($_n, 19)  &_ilog2_helper($_n, 18)  &_ilog2_helper($_n, 17)  &_ilog2_helper($_n, 16)  &_ilog2_helper($_n, 15)  &_ilog2_helper($_n, 14)  &_ilog2_helper($_n, 13)  &_ilog2_helper($_n, 12)  &_ilog2_helper($_n, 11)  &_ilog2_helper($_n, 10)  &_ilog2_helper($_n, 9)  &_ilog2_helper($_n, 8)  &_ilog2_helper($_n, 7)  &_ilog2_helper($_n, 6)  &_ilog2_helper($_n, 5)  &_ilog2_helper($_n, 4)  &_ilog2_helper($_n, 3)  &_ilog2_helper($_n, 2)  &_ilog2_helper($_n, 1)  &_ilog2_helper($_n, 0) -1));
    }' unless defined(&_ilog2_const);
    eval 'sub ilog2 {
        my($_n) = @_;
	    eval q((  &__builtin_constant_p($_n) ?  &_ilog2_const($_n) : (($sizeof{$_n} > 4?  &fls64($_n) :  &fls32($_n)) - 1) ));
    }' unless defined(&ilog2);
    eval 'sub fast_divide32_prepare {
        my($_div,$_m,$_s1,$_s2) = @_;
	    eval q({  &uint64_t  &_mt; \'int\'  &_l;  &_l =  &fls32($_div - 1);  &_mt = ( &uint64_t)(0x100000000 * ((1 <<  &_l) - $_div)); *$_m = ( &uint32_t)( &_mt / $_div + 1); *$_s1 = ( &_l > 1) ? 1 : ( &uint8_t) &_l; *$_s2 = ( &_l == 0) ? 0: ( &uint8_t)( &_l - 1); });
    }' unless defined(&fast_divide32_prepare);
    eval 'sub fast_remainder32 {
        my($_v,$_div,$_m,$_s1,$_s2) = @_;
	    eval q({ $_v - $_div *  &fast_divide32($_v, $_div, $_m, $_s1, $_s2); });
    }' unless defined(&fast_remainder32);
    eval 'sub __BITMAP_TYPE {
        my($__s, $__t, $__n) = @_;
	    eval q(\'struct __s\' { $__t  $_b[ &__BITMAP_SIZE($__t, $__n)]; });
    }' unless defined(&__BITMAP_TYPE);
    eval 'sub __BITMAP_BITS {
        my($__t) = @_;
	    eval q(($sizeof{$__t} *  &NBBY));
    }' unless defined(&__BITMAP_BITS);
    eval 'sub __BITMAP_SHIFT {
        my($__t) = @_;
	    eval q(( &ilog2( &__BITMAP_BITS($__t))));
    }' unless defined(&__BITMAP_SHIFT);
    eval 'sub __BITMAP_MASK {
        my($__t) = @_;
	    eval q(( &__BITMAP_BITS($__t) - 1));
    }' unless defined(&__BITMAP_MASK);
    eval 'sub __BITMAP_SIZE {
        my($__t, $__n) = @_;
	    eval q(((($__n) + ( &__BITMAP_BITS($__t) - 1)) /  &__BITMAP_BITS($__t)));
    }' unless defined(&__BITMAP_SIZE);
    eval 'sub __BITMAP_BIT {
        my($__n, $__v) = @_;
	    eval q((( &__typeof__(($__v)-> $_b[0]))1<< (($__n) &  &__BITMAP_MASK(*($__v)-> &_b))));
    }' unless defined(&__BITMAP_BIT);
    eval 'sub __BITMAP_WORD {
        my($__n, $__v) = @_;
	    eval q((($__n) >>  &__BITMAP_SHIFT(*($__v)-> &_b)));
    }' unless defined(&__BITMAP_WORD);
    eval 'sub __BITMAP_SET {
        my($__n, $__v) = @_;
	    eval q((($__v)-> $_b[ &__BITMAP_WORD($__n, $__v)] |=  &__BITMAP_BIT($__n, $__v)));
    }' unless defined(&__BITMAP_SET);
    eval 'sub __BITMAP_CLR {
        my($__n, $__v) = @_;
	    eval q((($__v)-> $_b[ &__BITMAP_WORD($__n, $__v)] &= ~ &__BITMAP_BIT($__n, $__v)));
    }' unless defined(&__BITMAP_CLR);
    eval 'sub __BITMAP_ISSET {
        my($__n, $__v) = @_;
	    eval q((($__v)-> $_b[ &__BITMAP_WORD($__n, $__v)] &  &__BITMAP_BIT($__n, $__v)));
    }' unless defined(&__BITMAP_ISSET);
    if( &__GNUC_PREREQ__(2, 95)) {
	eval 'sub __BITMAP_ZERO {
	    my($__v) = @_;
    	    eval q(( &void) &__builtin_memset(($__v), 0, $sizeof{$__v}));
	}' unless defined(&__BITMAP_ZERO);
    } else {
	eval 'sub __BITMAP_ZERO {
	    my($__v) = @_;
    	    eval q( &do { \'size_t\'  &__i;  &for ( &__i = 0;  &__i <  &__arraycount(($__v)-> &_b);  &__i++) ($__v)-> $_b[ &__i] = 0; }  &while ( 0));
	}' unless defined(&__BITMAP_ZERO);
    }
}
1;
