/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.InputStream;
import org.apache.xmlrpc.AuthenticatedXmlRpcHandler;
import org.apache.xmlrpc.AuthenticationFailed;
import org.apache.xmlrpc.ContextXmlRpcHandler;
import org.apache.xmlrpc.DefaultXmlRpcContext;
import org.apache.xmlrpc.ParseFailed;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcContext;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcHandlerMapping;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.XmlRpcRequestProcessor;
import org.apache.xmlrpc.XmlRpcResponseProcessor;

public class XmlRpcWorker {
    protected XmlRpcRequestProcessor requestProcessor = new XmlRpcRequestProcessor();
    protected XmlRpcResponseProcessor responseProcessor = new XmlRpcResponseProcessor();
    protected XmlRpcHandlerMapping handlerMapping;

    public XmlRpcWorker(XmlRpcHandlerMapping xmlRpcHandlerMapping) {
        this.handlerMapping = xmlRpcHandlerMapping;
    }

    protected static Object invokeHandler(Object object, XmlRpcRequest xmlRpcRequest, XmlRpcContext xmlRpcContext) throws Exception {
        block12: {
            long l;
            block11: {
                block10: {
                    l = 0L;
                    try {
                        if (XmlRpc.debug) {
                            l = System.currentTimeMillis();
                        }
                        if (object == null) {
                            throw new NullPointerException("Null handler passed to XmlRpcWorker.invokeHandler");
                        }
                        if (!(object instanceof ContextXmlRpcHandler)) break block10;
                        Object object2 = ((ContextXmlRpcHandler)object).execute(xmlRpcRequest.getMethodName(), xmlRpcRequest.getParameters(), xmlRpcContext);
                        Object var7_7 = null;
                        if (XmlRpc.debug) {
                            System.out.println("Spent " + (System.currentTimeMillis() - l) + " millis processing request");
                        }
                        return object2;
                    }
                    catch (Throwable throwable) {
                        block13: {
                            Object var7_10 = null;
                            if (!XmlRpc.debug) break block13;
                            System.out.println("Spent " + (System.currentTimeMillis() - l) + " millis processing request");
                        }
                        throw throwable;
                    }
                }
                if (!(object instanceof XmlRpcHandler)) break block11;
                Object object3 = ((XmlRpcHandler)object).execute(xmlRpcRequest.getMethodName(), xmlRpcRequest.getParameters());
                Object var7_8 = null;
                if (XmlRpc.debug) {
                    System.out.println("Spent " + (System.currentTimeMillis() - l) + " millis processing request");
                }
                return object3;
            }
            if (!(object instanceof AuthenticatedXmlRpcHandler)) break block12;
            Object object4 = ((AuthenticatedXmlRpcHandler)object).execute(xmlRpcRequest.getMethodName(), xmlRpcRequest.getParameters(), xmlRpcContext.getUserName(), xmlRpcContext.getPassword());
            Object var7_9 = null;
            if (XmlRpc.debug) {
                System.out.println("Spent " + (System.currentTimeMillis() - l) + " millis processing request");
            }
            return object4;
        }
        throw new ClassCastException("Handler class " + object.getClass().getName() + " is not a valid XML-RPC handler");
    }

    public byte[] execute(InputStream inputStream, String string, String string2) {
        return this.execute(inputStream, this.defaultContext(string, string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] execute(InputStream inputStream, XmlRpcContext xmlRpcContext) {
        long l = 0L;
        if (XmlRpc.debug) {
            l = System.currentTimeMillis();
        }
        try {
            byte[] byArray;
            try {
                XmlRpcRequest xmlRpcRequest = this.requestProcessor.processRequest(inputStream);
                Object object = this.handlerMapping.getHandler(xmlRpcRequest.getMethodName());
                Object object2 = XmlRpcWorker.invokeHandler(object, xmlRpcRequest, xmlRpcContext);
                byArray = this.responseProcessor.processResponse(object2, this.requestProcessor.getEncoding());
                Object var10_12 = null;
                if (!XmlRpc.debug) return byArray;
            }
            catch (AuthenticationFailed authenticationFailed) {
                throw authenticationFailed;
            }
            catch (ParseFailed parseFailed) {
                throw parseFailed;
            }
            catch (Exception exception) {
                if (XmlRpc.debug) {
                    exception.printStackTrace();
                }
                byte[] byArray2 = this.responseProcessor.processException(exception, this.requestProcessor.getEncoding());
                Object var10_13 = null;
                if (!XmlRpc.debug) return byArray2;
                System.out.println("Spent " + (System.currentTimeMillis() - l) + " millis in request/process/response");
                return byArray2;
            }
            System.out.println("Spent " + (System.currentTimeMillis() - l) + " millis in request/process/response");
            return byArray;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (!XmlRpc.debug) throw throwable;
            System.out.println("Spent " + (System.currentTimeMillis() - l) + " millis in request/process/response");
            throw throwable;
        }
    }

    protected XmlRpcContext defaultContext(String string, String string2) {
        return new DefaultXmlRpcContext(string, string2, this.handlerMapping);
    }
}

