/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginTable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import java.awt.Component;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class UninstallPluginAction
extends AnAction
implements DumbAware {
    private final PluginTable pluginTable;
    private final PluginManagerMain host;

    public UninstallPluginAction(PluginManagerMain mgr, PluginTable table) {
        super(IdeBundle.message((String)"action.uninstall.plugin", (Object[])new Object[0]), IdeBundle.message((String)"action.uninstall.plugin", (Object[])new Object[0]), AllIcons.Actions.Uninstall);
        this.pluginTable = table;
        this.host = mgr;
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enabled;
        if (e == null) {
            UninstallPluginAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        if (!this.pluginTable.isShowing()) {
            presentation.setEnabled(false);
            return;
        }
        IdeaPluginDescriptor[] selection = this.pluginTable.getSelectedObjects();
        boolean bl = enabled = selection != null;
        if (enabled) {
            for (IdeaPluginDescriptor descriptor : selection) {
                IdeaPluginDescriptorImpl ideaPluginDescriptor;
                if (descriptor instanceof IdeaPluginDescriptorImpl && ((ideaPluginDescriptor = (IdeaPluginDescriptorImpl)descriptor).isDeleted() || ideaPluginDescriptor.isBundled())) {
                    enabled = false;
                    break;
                }
                if (!(descriptor instanceof PluginNode)) continue;
                enabled = false;
                break;
            }
        }
        presentation.setEnabled(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            UninstallPluginAction.$$$reportNull$$$0(1);
        }
        UninstallPluginAction.uninstall(this.host, false, this.pluginTable.getSelectedObjects());
        this.pluginTable.updateUI();
    }

    public static void uninstall(PluginManagerMain host, boolean confirmed, IdeaPluginDescriptor ... selection) {
        String message = selection.length == 1 ? IdeBundle.message((String)"prompt.uninstall.plugin", (Object[])new Object[]{selection[0].getName()}) : IdeBundle.message((String)"prompt.uninstall.several.plugins", (Object[])new Object[]{selection.length});
        if (!confirmed && Messages.showYesNoDialog((Component)host.getMainPanel(), (String)message, (String)IdeBundle.message((String)"title.plugin.uninstall", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
            return;
        }
        for (IdeaPluginDescriptor descriptor : selection) {
            IdeaPluginDescriptorImpl pluginDescriptor = (IdeaPluginDescriptorImpl)descriptor;
            boolean actualDelete = true;
            List<IdeaPluginDescriptorImpl> dependant = host.getDependentList(pluginDescriptor);
            if (dependant.size() > 0) {
                message = IdeBundle.message((String)"several.plugins.depend.on.0.continue.to.remove", (Object[])new Object[]{pluginDescriptor.getName()});
                boolean bl = actualDelete = Messages.showYesNoDialog((Component)host.getMainPanel(), (String)message, (String)IdeBundle.message((String)"title.plugin.uninstall", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0;
            }
            if (!actualDelete) continue;
            UninstallPluginAction.uninstallPlugin(pluginDescriptor, host);
        }
    }

    private static void uninstallPlugin(IdeaPluginDescriptorImpl descriptor, PluginManagerMain host) {
        PluginId pluginId = descriptor.getPluginId();
        descriptor.setDeleted(true);
        try {
            PluginInstaller.prepareToUninstall(pluginId);
            host.setRequireShutdown(descriptor.isEnabled());
        }
        catch (IOException e1) {
            PluginManagerMain.LOG.error((Throwable)e1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/ide/plugins/UninstallPluginAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

