/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.DeferredIconImpl;
import com.intellij.ui.IconDeferrer;
import com.intellij.util.Function;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class IconDeferrerImpl
extends IconDeferrer {
    private final Object LOCK;
    private final Map<Object, Icon> myIconsCache;
    private long myLastClearTimestamp;
    private static final ThreadLocal<Boolean> myEvaluationIsInProgress = ThreadLocal.withInitial(() -> Boolean.FALSE);

    public IconDeferrerImpl(@NotNull MessageBus bus) {
        if (bus == null) {
            IconDeferrerImpl.$$$reportNull$$$0(0);
        }
        this.LOCK = new Object();
        this.myIconsCache = new FixedHashMap(100);
        MessageBusConnection connection = bus.connect();
        connection.subscribe(PsiModificationTracker.TOPIC, this::clear);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                IconDeferrerImpl.this.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/ui/IconDeferrerImpl$1", "after"));
            }
        });
        connection.subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener(){

            public void afterProjectClosed(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                IconDeferrerImpl.this.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/IconDeferrerImpl$2", "afterProjectClosed"));
            }
        });
        LowMemoryWatcher.register(this::clear, (Disposable)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clear() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myIconsCache.clear();
            ++this.myLastClearTimestamp;
        }
    }

    public <T> Icon defer(Icon base, T param, @NotNull Function<T, Icon> evaluator) {
        if (evaluator == null) {
            IconDeferrerImpl.$$$reportNull$$$0(1);
        }
        return this.deferImpl(base, param, evaluator, false);
    }

    public <T> Icon deferAutoUpdatable(Icon base, T param, @NotNull Function<? super T, ? extends Icon> evaluator) {
        if (evaluator == null) {
            IconDeferrerImpl.$$$reportNull$$$0(2);
        }
        return this.deferImpl(base, param, evaluator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Icon deferImpl(Icon base, T param, @NotNull Function<? super T, ? extends Icon> evaluator, boolean autoUpdatable) {
        if (evaluator == null) {
            IconDeferrerImpl.$$$reportNull$$$0(3);
        }
        if (myEvaluationIsInProgress.get().booleanValue()) {
            return (Icon)evaluator.fun(param);
        }
        Object object = this.LOCK;
        synchronized (object) {
            Object result2 = this.myIconsCache.get(param);
            if (result2 == null) {
                long started = this.myLastClearTimestamp;
                result2 = new DeferredIconImpl<Object>(base, param, evaluator, (source, key, r) -> {
                    Object object = this.LOCK;
                    synchronized (object) {
                        if (started == this.myLastClearTimestamp) {
                            this.myIconsCache.put(key, (Icon)(autoUpdatable ? source : r));
                        }
                    }
                }, autoUpdatable);
                this.myIconsCache.put(param, (Icon)result2);
            }
            return result2;
        }
    }

    static void evaluateDeferred(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            IconDeferrerImpl.$$$reportNull$$$0(4);
        }
        try {
            myEvaluationIsInProgress.set(Boolean.TRUE);
            runnable2.run();
        }
        finally {
            myEvaluationIsInProgress.set(Boolean.FALSE);
        }
    }

    public boolean equalIcons(Icon icon1, Icon icon2) {
        return DeferredIconImpl.equalIcons(icon1, icon2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/IconDeferrerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "defer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "deferAutoUpdatable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "deferImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateDeferred";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

