/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.FilePathRegExpCreator;
import com.intellij.javascript.debugger.JSLineBreakpointManagerBase;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.JavaScriptLineBreakpointManagerKt;
import com.intellij.javascript.debugger.LineVisitor;
import com.intellij.javascript.debugger.PsiVisitorKt;
import com.intellij.javascript.debugger.breakpoints.JavaScriptBreakpointType;
import com.intellij.javascript.debugger.breakpoints.JavaScriptLineBreakpointProperties;
import com.intellij.javascript.debugger.sourcemap.SourceMapHelperKt;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.DocumentUtil;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.PsiVisitors;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptRegExpBreakpointTarget;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00019B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J.\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\"\u0010\u001b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u001cH\u0002J<\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u00182\u0006\u0010\u0019\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J$\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00182\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)2\u0006\u0010*\u001a\u00020\u0011J`\u0010+\u001a\b\u0012\u0004\u0012\u00020\r0\u00182\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&2\u0010\b\u0002\u0010,\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010-2\b\b\u0002\u0010.\u001a\u00020\u0016J\u0010\u0010/\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0010\u00100\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u00101\u001a\u0002022\u0006\u0010\u001f\u001a\u00020 2\u0006\u00103\u001a\u00020\u00112\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u0011J\u0016\u00105\u001a\u0002022\u0006\u0010\u001f\u001a\u00020 2\u0006\u00103\u001a\u00020\u0011J0\u00106\u001a\b\u0012\u0004\u0012\u0002070\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&J\u0010\u00108\u001a\u0002022\u0006\u0010\u0013\u001a\u00020\u0007H\u0014R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager;", "Lcom/intellij/javascript/debugger/JSLineBreakpointManagerBase;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "anyFirstLineBreakpoints", "Lcom/intellij/util/containers/ConcurrentList;", "Lorg/jetbrains/debugger/Breakpoint;", "kotlin.jvm.PlatformType", "checkDuplicates", "newTarget", "Lorg/jetbrains/debugger/BreakpointTarget;", "location", "Lorg/jetbrains/debugger/Location;", "breakpointManager", "Lorg/jetbrains/debugger/BreakpointManager;", "createNameRegExp", "", "createTarget", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "isTemporary", "", "doRunToLocation", "", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "findExisting", "Lorg/jetbrains/debugger/ScriptRegExpBreakpointTarget;", "findRawLocationsFromExactPosition", "Lorg/jetbrains/debugger/SourceInfo;", "vm", "Lorg/jetbrains/debugger/Vm;", "map", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "script", "Lorg/jetbrains/debugger/Script;", "scriptUrl", "Lcom/intellij/util/Url;", "findTopFirstLineBreakpoints", "context", "Lorg/jetbrains/debugger/SuspendContext;", "scriptName", "getActualLocations", "outSourceMappedLocationFound", "Lcom/intellij/openapi/util/Ref;", "keepEmptySourceMappedLocation", "isAnyFirstLineBreakpoint", "isUseScriptIdTarget", "setAnyFirstLineBreakpoint", "", "regExp", "condition", "setMeteorAnyClientScriptBreakpointIfNeed", "sourceMapFound", "Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager$VmBreakpointLocation;", "unregisterAnyFirstLineBreakpoint", "VmBreakpointLocation", "intellij.javascript.debugger"})
public final class JavaScriptLineBreakpointManager
extends JSLineBreakpointManagerBase {
    private final ConcurrentList<Breakpoint> anyFirstLineBreakpoints;

    @Override
    public boolean isAnyFirstLineBreakpoint(@NotNull Breakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
        return this.anyFirstLineBreakpoints.contains((Object)breakpoint);
    }

    @Override
    protected void unregisterAnyFirstLineBreakpoint(@NotNull Breakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
        this.anyFirstLineBreakpoints.remove((Object)breakpoint);
    }

    public final void setAnyFirstLineBreakpoint(@NotNull Vm vm, @NotNull String regExp, @Nullable String condition) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)regExp, (String)"regExp");
        BreakpointManager breakpointManager = vm.getBreakpointManager();
        JavaScriptDebugProcessKt.getLOG().assertTrue(breakpointManager.getRegExpBreakpointSupported());
        int n = 0;
        Url url = null;
        String string = condition;
        BreakpointManager.SetBreakpointResult setBreakpointResult = BreakpointManager.DefaultImpls.setBreakpoint$default((BreakpointManager)breakpointManager, (BreakpointTarget)((BreakpointTarget)new ScriptRegExpBreakpointTarget(regExp, null, 2, null)), (int)0, (int)0, url, (String)string, (int)n, (int)36, null);
        if (setBreakpointResult instanceof BreakpointManager.BreakpointCreated) {
            this.anyFirstLineBreakpoints.add((Object)((BreakpointManager.BreakpointCreated)setBreakpointResult).getBreakpoint());
        }
    }

    public static /* synthetic */ void setAnyFirstLineBreakpoint$default(JavaScriptLineBreakpointManager javaScriptLineBreakpointManager, Vm vm, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        javaScriptLineBreakpointManager.setAnyFirstLineBreakpoint(vm, string, string2);
    }

    public final void setMeteorAnyClientScriptBreakpointIfNeed(@NotNull Vm vm, @NotNull String regExp) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)regExp, (String)"regExp");
        for (Breakpoint breakpoint : this.anyFirstLineBreakpoints) {
            BreakpointTarget breakpointTarget = breakpoint.getTarget();
            if (breakpointTarget == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.ScriptRegExpBreakpointTarget");
            }
            if (!Intrinsics.areEqual((Object)((ScriptRegExpBreakpointTarget)breakpointTarget).toString(), (Object)regExp)) continue;
            return;
        }
        JavaScriptLineBreakpointManager.setAnyFirstLineBreakpoint$default(this, vm, regExp, null, 4, null);
    }

    private final boolean isUseScriptIdTarget(Location location) {
        Url url = location.getUrl();
        Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"location.url");
        if (Intrinsics.areEqual((Object)url.getScheme(), (Object)"vm")) {
            return true;
        }
        if (this.getDebugProcess$intellij_javascript_debugger().getScriptsCanBeReloaded()) {
            return false;
        }
        if (this.getDebugProcess$intellij_javascript_debugger().isFilesOnlyInLocalFileSystem()) {
            return true;
        }
        if (!this.anyFirstLineBreakpoints.isEmpty()) {
            String string = location.getUrl().toExternalForm();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"location.url.toExternalForm()");
            String scriptUrl = string;
            for (Breakpoint breakpoint : this.anyFirstLineBreakpoints) {
                if (!(breakpoint.getTarget() instanceof ScriptRegExpBreakpointTarget)) continue;
                String string2 = breakpoint.getTarget().toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"breakpoint.target.toString()");
                if (!JavaScriptLineBreakpointManagerKt.match(string2, scriptUrl)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    protected BreakpointTarget createTarget(@Nullable XLineBreakpoint<?> breakpoint, @NotNull BreakpointManager breakpointManager, @NotNull Location location, boolean isTemporary) {
        Script script;
        block9: {
            block10: {
                CharSequence charSequence;
                Intrinsics.checkParameterIsNotNull((Object)breakpointManager, (String)"breakpointManager");
                Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
                script = location.getScript();
                if (!isTemporary) {
                    if (script != null && this.isUseScriptIdTarget(location)) {
                        return (BreakpointTarget)new BreakpointTarget.ScriptId(script);
                    }
                    if (script != null) {
                        String string = script.getUrl().toExternalForm();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"script.url.toExternalForm()");
                        charSequence = string;
                        if (!(charSequence.length() == 0)) {
                            return (BreakpointTarget)new BreakpointTarget.ScriptName(script.getUrl().toExternalForm());
                        }
                    }
                }
                if (isTemporary && script != null) {
                    return (BreakpointTarget)new BreakpointTarget.ScriptId(script);
                }
                if (!breakpointManager.getRegExpBreakpointSupported()) break block9;
                Url url = location.getUrl();
                Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"location.url");
                if (url.isInLocalFileSystem()) break block10;
                Url url2 = location.getUrl();
                Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"location.url");
                charSequence = url2.getAuthority();
                if (charSequence == null || charSequence.length() == 0) break block9;
            }
            return (BreakpointTarget)new ScriptRegExpBreakpointTarget(this.createNameRegExp(location), this.getDebugProcess$intellij_javascript_debugger().getBreakpointLanguageHint(breakpoint, location));
        }
        if (script == null) {
            return (BreakpointTarget)new BreakpointTarget.ScriptName(location.getUrl().toExternalForm());
        }
        return (BreakpointTarget)new BreakpointTarget.ScriptId(script);
    }

    @Override
    @Nullable
    protected Breakpoint checkDuplicates(@NotNull BreakpointTarget newTarget, @NotNull Location location, @NotNull BreakpointManager breakpointManager) {
        Intrinsics.checkParameterIsNotNull((Object)newTarget, (String)"newTarget");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)breakpointManager, (String)"breakpointManager");
        if (location.getScript() != null && newTarget instanceof ScriptRegExpBreakpointTarget) {
            Breakpoint breakpoint = this.findExisting(breakpointManager, location, (ScriptRegExpBreakpointTarget)newTarget);
            if (breakpoint != null) {
                Breakpoint breakpoint2;
                Breakpoint it = breakpoint2 = breakpoint;
                return it;
            }
        }
        return super.checkDuplicates(newTarget, location, breakpointManager);
    }

    private final Breakpoint findExisting(BreakpointManager breakpointManager, Location location, ScriptRegExpBreakpointTarget newTarget) {
        for (Breakpoint breakpoint : breakpointManager.getBreakpoints()) {
            BreakpointTarget target = breakpoint.getTarget();
            if (!(target instanceof ScriptRegExpBreakpointTarget) || this.isAnyFirstLineBreakpoint(breakpoint) || !breakpoint.getEnabled() || breakpoint.getLine() != location.getLine() || breakpoint.getColumn() != -1 && breakpoint.getColumn() != location.getColumn()) continue;
            String string = newTarget.toString();
            String string2 = target.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"target.toString()");
            if (!StringsKt.endsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) continue;
            return breakpoint;
        }
        return null;
    }

    private final String createNameRegExp(Location location) {
        boolean useCaseSensitiveUrl = this.getDebugProcess$intellij_javascript_debugger().isUrlsCaseSensitive();
        if (this.getDebugProcess$intellij_javascript_debugger().isFilesOnlyInLocalFileSystem() && this.getDebugProcess$intellij_javascript_debugger() instanceof FilePathRegExpCreator) {
            FilePathRegExpCreator filePathRegExpCreator = (FilePathRegExpCreator)((Object)this.getDebugProcess$intellij_javascript_debugger());
            Url url = location.getUrl();
            Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"location.url");
            return filePathRegExpCreator.createFilePathRegExp(url, false, useCaseSensitiveUrl);
        }
        return JavaScriptLineBreakpointManagerKt.access$createUrlRegExp(location, useCaseSensitiveUrl);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<VmBreakpointLocation> sourceMapFound(@NotNull Vm vm, @NotNull SourceMap map, @Nullable Script script, @Nullable Url scriptUrl) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        if (!this.getDebugProcess$intellij_javascript_debugger().isFilesOnlyInLocalFileSystem() || script == null) ** GOTO lbl-1000
        v0 = script.getUrl().getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"script.url.path");
        if (StringsKt.contains$default((CharSequence)v0, (CharSequence)"/node_modules/", (boolean)false, (int)2, null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        isScriptInNodeModules = v1;
        sourceMapFound = null;
        v2 = ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<? extends XLineBreakpoint<JavaScriptLineBreakpointProperties>>>(this){
            final /* synthetic */ JavaScriptLineBreakpointManager this$0;

            @NotNull
            public final Collection<? extends XLineBreakpoint<JavaScriptLineBreakpointProperties>> compute() {
                XDebugSession xDebugSession = this.this$0.getDebugProcess$intellij_javascript_debugger().getSession();
                Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
                XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)xDebugSession.getProject());
                Intrinsics.checkExpressionValueIsNotNull((Object)xDebuggerManager, (String)"XDebuggerManager.getInst\u2026gProcess.session.project)");
                return xDebuggerManager.getBreakpointManager().getBreakpoints(JavaScriptBreakpointType.class);
            }
            {
                this.this$0 = javaScriptLineBreakpointManager;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"ApplicationManager.getAp\u2026tType::class.java)\n    })");
        breakpoints = (Collection)v2;
        for (XLineBreakpoint breakpoint : breakpoints) {
            if (!(breakpoint instanceof XLineBreakpoint)) continue;
            if (breakpoint.getSourcePosition() == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)breakpointLocation, (String)"breakpoint.sourcePosition ?: continue");
            if (isScriptInNodeModules) {
                v3 = breakpointLocation.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"breakpointLocation.file");
                v4 = v3.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"breakpointLocation.file.path");
                if (!StringsKt.contains$default((CharSequence)v4, (CharSequence)"/node_modules/", (boolean)false, (int)2, null)) continue;
            }
            sourceMappedLocationFound = Ref.create((Object)false);
            var14_14 = $receiver$iv = (Iterable)JavaScriptLineBreakpointManager.getActualLocations$default(this, breakpoint, vm, map, script, scriptUrl, sourceMappedLocationFound, false, 64, null);
            destination$iv$iv = new ArrayList<E>();
            for (T element$iv$iv : $receiver$iv$iv) {
                block11: {
                    actualLocation = (Location)element$iv$iv;
                    newTarget = this.createTarget(breakpoint, vm.getBreakpointManager(), actualLocation, false);
                    $receiver$iv = vm.getBreakpointManager().getBreakpoints();
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        v5 = false;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            it = (Breakpoint)element$iv;
                            if (!Intrinsics.areEqual((Object)it.getTarget(), (Object)newTarget)) continue;
                            v5 = true;
                            break block11;
                        }
                        v5 = false;
                    }
                }
                v6 = !v5;
                if (!v6) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            actualLocations = (List)destination$iv$iv;
            if (actualLocations.isEmpty()) continue;
            v7 = sourceMappedLocationFound.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"sourceMappedLocationFound.get()");
            if (!((Boolean)v7).booleanValue() && !this.getVmBreakpoints(vm, breakpoint).isEmpty()) continue;
            if (sourceMapFound == null) {
                sourceMapFound = (List)new SmartList();
            }
            sourceMapFound.add(new VmBreakpointLocation(breakpoint, actualLocations));
        }
        v8 = sourceMapFound;
        if (v8 == null) {
            v8 = CollectionsKt.emptyList();
        }
        return v8;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Location> getActualLocations(@NotNull XLineBreakpoint<?> breakpoint, @NotNull Vm vm, @Nullable SourceMap map, @Nullable Script script, @Nullable Url scriptUrl, @Nullable Ref<Boolean> outSourceMappedLocationFound, boolean keepEmptySourceMappedLocation) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        XDebugSession xDebugSession = this.getDebugProcess$intellij_javascript_debugger().getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
        Project project = xDebugSession.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
        List<SourceInfo> positionsInLine = PsiVisitorKt.getPositionsInLine(breakpoint, project);
        Iterable iterable = $receiver$iv = (Iterable)positionsInLine;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            List<Location> rawLocationsFromExactPosition;
            SourceInfo it = (SourceInfo)element$iv$iv;
            List rawLocations = SourceMapHelperKt.getRawLocations(this.getDebugProcess$intellij_javascript_debugger(), vm, it.getFile(), it.getLine(), map, script, scriptUrl, it.getColumn());
            if (rawLocations.size() > 1 && it.getColumn() == -1 && !(rawLocationsFromExactPosition = this.findRawLocationsFromExactPosition(it, vm, map, script, scriptUrl)).isEmpty()) {
                rawLocations = rawLocationsFromExactPosition;
            }
            if (outSourceMappedLocationFound != null && !rawLocations.isEmpty()) {
                outSourceMappedLocationFound.set((Object)true);
            }
            Iterable list$iv$iv = keepEmptySourceMappedLocation && rawLocations.isEmpty() ? CollectionsKt.listOf((Object)new Location(it.getUrl(), it.getLine(), it.getColumn())) : rawLocations;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static /* synthetic */ List getActualLocations$default(JavaScriptLineBreakpointManager javaScriptLineBreakpointManager, XLineBreakpoint xLineBreakpoint, Vm vm, SourceMap sourceMap, Script script, Url url, Ref ref, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            sourceMap = null;
        }
        if ((n & 8) != 0) {
            script = null;
        }
        if ((n & 0x10) != 0) {
            url = null;
        }
        if ((n & 0x20) != 0) {
            ref = null;
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        return javaScriptLineBreakpointManager.getActualLocations(xLineBreakpoint, vm, sourceMap, script, url, (Ref<Boolean>)ref, bl);
    }

    private final List<Location> findRawLocationsFromExactPosition(SourceInfo position, Vm vm, SourceMap map, Script script, Url scriptUrl) {
        List<Location> list;
        Ref firstVarColumn = new Ref((Object)-1);
        XSourcePosition xSourcePosition = (XSourcePosition)position;
        XDebugSession xDebugSession = this.getDebugProcess$intellij_javascript_debugger().getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
        PsiVisitors.visit((XSourcePosition)xSourcePosition, (Project)xDebugSession.getProject(), (PsiVisitors.Visitor)new LineVisitor(this, firstVarColumn){
            final /* synthetic */ JavaScriptLineBreakpointManager this$0;
            final /* synthetic */ Ref $firstVarColumn;

            public void visitJSElement(@Nullable JSElement node) {
                if (node instanceof JSVarStatement) {
                    JSVariable[] variables;
                    JSVariable[] jSVariableArray = ((JSVarStatement)node).getVariables();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jSVariableArray, (String)"node.variables");
                    JSVariable[] jSVariableArray2 = variables = jSVariableArray;
                    if (!(jSVariableArray2.length == 0)) {
                        XDebugSession xDebugSession = this.this$0.getDebugProcess$intellij_javascript_debugger().getSession();
                        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"debugProcess.session");
                        Document document = PsiDocumentManager.getInstance((Project)xDebugSession.getProject()).getDocument(((JSVarStatement)node).getContainingFile());
                        if (document != null) {
                            JSVariable jSVariable = variables[0];
                            Intrinsics.checkExpressionValueIsNotNull((Object)jSVariable, (String)"variables[0]");
                            TextRange textRange = jSVariable.getTextRange();
                            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"variables[0].textRange");
                            int offset = textRange.getStartOffset();
                            this.$firstVarColumn.set((Object)(offset - DocumentUtil.getLineStartOffset((int)offset, (Document)document)));
                        }
                    }
                }
                this.isStopped = true;
            }
            {
                this.this$0 = $outer;
                this.$firstVarColumn = $captured_local_variable$1;
            }
        });
        Integer n = (Integer)firstVarColumn.get();
        if (n == null || n != -1) {
            JavaScriptDebugProcess<?> javaScriptDebugProcess = this.getDebugProcess$intellij_javascript_debugger();
            VirtualFile virtualFile = position.getFile();
            int n2 = position.getLine();
            Object object = firstVarColumn.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"firstVarColumn.get()");
            list = SourceMapHelperKt.getRawLocations(javaScriptDebugProcess, vm, virtualFile, n2, map, script, scriptUrl, ((Number)object).intValue());
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final List<XLineBreakpoint<?>> findTopFirstLineBreakpoints(@NotNull SuspendContext<?> context, @NotNull String scriptName) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)scriptName, (String)"scriptName");
        CallFrame callFrame = context.getTopFrame();
        int breakLine = callFrame != null ? callFrame.getLine() : 0;
        for (Breakpoint breakpoint : context.getVm().getBreakpointManager().getBreakpoints()) {
            boolean bl;
            if (this.isAnyFirstLineBreakpoint(breakpoint) || !breakpoint.getEnabled() || breakpoint.getLine() != 0 && breakpoint.getLine() != breakLine) continue;
            BreakpointTarget breakpointTarget = breakpoint.getTarget();
            BreakpointTarget breakpointTarget2 = breakpointTarget;
            if (breakpointTarget2 instanceof ScriptRegExpBreakpointTarget) {
                String string = breakpointTarget.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"breakpointTarget.toString()");
                bl = JavaScriptLineBreakpointManagerKt.match(string, scriptName);
            } else {
                Script script;
                bl = breakpointTarget2 instanceof BreakpointTarget.ScriptName ? Intrinsics.areEqual((Object)scriptName, (Object)breakpointTarget.toString()) : (breakpointTarget2 instanceof BreakpointTarget.ScriptId ? Intrinsics.areEqual((Object)scriptName, (Object)(script = ((BreakpointTarget.ScriptId)breakpointTarget).script).getUrl().trimParameters().toExternalForm()) || Intrinsics.areEqual((Object)scriptName, (Object)script.getUrl().trimParameters().toDecodedForm()) : false);
            }
            if (!bl) continue;
            List list = (List)this.getVmToIdeBreakpoints().get((Object)breakpoint);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<Breakpoint> doRunToLocation(@NotNull XSourcePosition position) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        Vm vm = this.getDebugProcess$intellij_javascript_debugger().getActiveOrMainVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        Vm activeVm = vm;
        List locations2 = SourceMapHelperKt.getRawLocations$default(this.getDebugProcess$intellij_javascript_debugger(), activeVm, position, null, null, null, 56, null);
        if (locations2.isEmpty()) {
            DebuggableFileFinder debuggableFileFinder = this.getDebugProcess$intellij_javascript_debugger().getFinder();
            VirtualFile virtualFile = position.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"position.file");
            if (debuggableFileFinder.isOnlySourceMappedBreakpoints(virtualFile)) {
                String message = "Cannot run to location, source location is not mapped: " + position;
                this.getDebugProcess$intellij_javascript_debugger().getSession().reportError(message);
                JavaScriptDebugProcessKt.getLOG().warn(message);
                return CollectionsKt.emptyList();
            }
        }
        if (locations2.isEmpty()) {
            DebuggableFileFinder debuggableFileFinder = this.getDebugProcess$intellij_javascript_debugger().getFinder();
            VirtualFile virtualFile = position.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"position.file");
            List<Url> urls = debuggableFileFinder.getRemoteUrls(virtualFile);
            Url url = (Url)CollectionsKt.first(urls);
            int n = position.getLine();
            XSourcePosition xSourcePosition = position;
            if (!(xSourcePosition instanceof SourceInfo)) {
                xSourcePosition = null;
            }
            SourceInfo sourceInfo = (SourceInfo)xSourcePosition;
            list = CollectionsKt.listOfNotNull((Object)JSLineBreakpointManagerBase.doSetBreakpoint$default(this, activeVm, null, new Location(url, n, sourceInfo != null ? sourceInfo.getColumn() : -1), true, null, 16, null));
        } else {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)locations2;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                Breakpoint breakpoint;
                Object element$iv$iv = element$iv$iv$iv;
                Location it = (Location)element$iv$iv;
                if (JSLineBreakpointManagerBase.doSetBreakpoint$default(this, activeVm, null, it, true, null, 16, null) == null) continue;
                Breakpoint it$iv$iv = breakpoint;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    public JavaScriptLineBreakpointManager(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        super(debugProcess);
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentList, (String)"ContainerUtil.createConcurrentList<Breakpoint>()");
        this.anyFirstLineBreakpoints = concurrentList;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\r\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager$VmBreakpointLocation;", "", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "actualLocations", "", "Lorg/jetbrains/debugger/Location;", "(Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;Ljava/util/List;)V", "getActualLocations", "()Ljava/util/List;", "getBreakpoint", "()Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.javascript.debugger"})
    public static final class VmBreakpointLocation {
        @NotNull
        private final XLineBreakpoint<?> breakpoint;
        @NotNull
        private final List<Location> actualLocations;

        @NotNull
        public final XLineBreakpoint<?> getBreakpoint() {
            return this.breakpoint;
        }

        @NotNull
        public final List<Location> getActualLocations() {
            return this.actualLocations;
        }

        public VmBreakpointLocation(@NotNull XLineBreakpoint<?> breakpoint, @NotNull List<Location> actualLocations) {
            Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
            Intrinsics.checkParameterIsNotNull(actualLocations, (String)"actualLocations");
            this.breakpoint = breakpoint;
            this.actualLocations = actualLocations;
        }

        @NotNull
        public final XLineBreakpoint<?> component1() {
            return this.breakpoint;
        }

        @NotNull
        public final List<Location> component2() {
            return this.actualLocations;
        }

        @NotNull
        public final VmBreakpointLocation copy(@NotNull XLineBreakpoint<?> breakpoint, @NotNull List<Location> actualLocations) {
            Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
            Intrinsics.checkParameterIsNotNull(actualLocations, (String)"actualLocations");
            return new VmBreakpointLocation(breakpoint, actualLocations);
        }

        @NotNull
        public static /* synthetic */ VmBreakpointLocation copy$default(VmBreakpointLocation vmBreakpointLocation, XLineBreakpoint xLineBreakpoint, List list, int n, Object object) {
            if ((n & 1) != 0) {
                xLineBreakpoint = vmBreakpointLocation.breakpoint;
            }
            if ((n & 2) != 0) {
                list = vmBreakpointLocation.actualLocations;
            }
            return vmBreakpointLocation.copy(xLineBreakpoint, list);
        }

        @NotNull
        public String toString() {
            return "VmBreakpointLocation(breakpoint=" + this.breakpoint + ", actualLocations=" + this.actualLocations + ")";
        }

        public int hashCode() {
            XLineBreakpoint<?> xLineBreakpoint = this.breakpoint;
            List<Location> list = this.actualLocations;
            return (xLineBreakpoint != null ? xLineBreakpoint.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof VmBreakpointLocation)) break block3;
                    VmBreakpointLocation vmBreakpointLocation = (VmBreakpointLocation)object;
                    if (!Intrinsics.areEqual(this.breakpoint, vmBreakpointLocation.breakpoint) || !Intrinsics.areEqual(this.actualLocations, vmBreakpointLocation.actualLocations)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

