/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerSettings;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerLinkImpl;
import com.intellij.docker.agent.settings.DockerPathMappingImpl;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.settings.DockerExtraHost;
import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.settingsSummary.ProblemType;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.remote.docker.PhpDockerContainerSettingsManager;
import com.jetbrains.php.remote.docker.PhpDockerProcessUtil;
import com.jetbrains.php.settingsSummary.util.PhpSettingsCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerProblemType
implements ProblemType {
    public String toString() {
        return "Docker";
    }

    @NotNull
    public String collectInfo(@NotNull Project project) {
        if (project == null) {
            DockerProblemType.$$$reportNull$$$0(0);
        }
        StringBuilder output = new StringBuilder();
        PhpSettingsCollector.collectCurrentPHPInterpreter((Project)project, (StringBuilder)output);
        PhpInterpreter interpreter = PhpProjectConfigurationFacade.getInstance((Project)project).getInterpreter();
        if (interpreter != null) {
            PhpSdkAdditionalData phpSdkAdditionalData = interpreter.getPhpSdkAdditionalData();
            if (phpSdkAdditionalData instanceof RemoteSdkAdditionalData) {
                try {
                    output.append("=====DOCKER SETTINGS=====\n");
                    DockerCloudConfiguration configuration = (DockerCloudConfiguration)PhpDockerProcessUtil.getAccount((RemoteSdkAdditionalData)phpSdkAdditionalData).getConfiguration();
                    DockerProblemType.appendEntry("API URL", configuration.getApiUrl(), output);
                    DockerProblemType.appendEntry("Certificates folder", configuration.getCertificatesPath(), output);
                    DockerProblemType.appendEntry("Docker Compose", DockerSettings.getInstance().getDockerComposePath(), output);
                    DockerProblemType.appendEntry("Docker Machine", configuration.getMachine(), output);
                    for (DockerPathMappingImpl mapping : configuration.getPathMappings()) {
                        DockerProblemType.appendEscapedMappingEntry(mapping.getVirtualMachinePath(), mapping.getLocalPath(), output);
                    }
                    output.append("=====DOCKER CONTAINER=====\n");
                    DockerContainerSettings containerSettings = PhpDockerContainerSettingsManager.getInstance(project).getSettings(interpreter.getId());
                    DockerProblemType.appendEntry("Disable networking", containerSettings.isNetworkDisabled(), output);
                    DockerProblemType.appendEntry("Network mode", containerSettings.getNetworkMode(), output);
                    DockerProblemType.appendEntry("Publish all ports", containerSettings.isPublishAllPorts(), output);
                    DockerProblemType.appendEntry("Port bindings:", "", output);
                    for (DockerPortBindingImpl portBinding : containerSettings.getPortBindings()) {
                        DockerProblemType.appendEntry(String.valueOf(portBinding.getContainerPort()), portBinding.getProtocol() + " " + portBinding.getHostIp() + " " + portBinding.getHostPort(), output);
                    }
                    DockerProblemType.appendEntry("Links:", "", output);
                    for (DockerLinkImpl dockerLink : containerSettings.getLinks()) {
                        DockerProblemType.appendEntry(dockerLink.getName(), dockerLink.getAlias(), output);
                    }
                    DockerProblemType.appendEntry("Extra hosts:", "", output);
                    for (DockerExtraHost dockerExtraHost : containerSettings.getExtraHosts()) {
                        DockerProblemType.appendEntry(dockerExtraHost.getHostname(), dockerExtraHost.getIP(), output);
                    }
                    DockerProblemType.appendEntry("Volume bindings:", "", output);
                    for (DockerVolumeBindingImpl volumeBinding : containerSettings.getVolumeBindings()) {
                        DockerProblemType.appendEscapedMappingEntry(volumeBinding.getContainerPath(), volumeBinding.getHostPath() + " " + volumeBinding.isReadOnly(), output);
                    }
                    DockerProblemType.appendEntry("Environment variables:", "", output);
                    for (DockerEnvVarImpl envVar : containerSettings.getEnvVars()) {
                        DockerProblemType.appendEntry(envVar.getName(), envVar.getValue(), output);
                    }
                }
                catch (Exception ignored) {
                    output.append(ignored.getMessage());
                }
            } else {
                output.append("Non Docker PHP interpreter");
            }
        } else {
            output.append("No PHP interpreter is chosen\n");
        }
        String string = output.toString();
        if (string == null) {
            DockerProblemType.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static void appendEntry(@Nullable String key, @Nullable String value, @NotNull StringBuilder output) {
        if (output == null) {
            DockerProblemType.$$$reportNull$$$0(2);
        }
        output.append(key).append(" : ").append(value).append("\n");
    }

    private static void appendEntry(@Nullable String key, int value, @NotNull StringBuilder output) {
        if (output == null) {
            DockerProblemType.$$$reportNull$$$0(3);
        }
        DockerProblemType.appendEntry(key, String.valueOf(value), output);
    }

    private static void appendEntry(@Nullable String key, boolean value, @NotNull StringBuilder output) {
        if (output == null) {
            DockerProblemType.$$$reportNull$$$0(4);
        }
        DockerProblemType.appendEntry(key, String.valueOf(value), output);
    }

    private static void appendEscapedEntry(@Nullable String key, @Nullable String value, @NotNull StringBuilder output) {
        if (output == null) {
            DockerProblemType.$$$reportNull$$$0(5);
        }
        output.append(key).append(" : \"").append(value).append("\"\n");
    }

    private static void appendEscapedMappingEntry(@Nullable String key, @Nullable String value, @NotNull StringBuilder output) {
        if (output == null) {
            DockerProblemType.$$$reportNull$$$0(6);
        }
        output.append("\"").append(key).append("\" : \"").append(value).append("\"\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/docker/DockerProblemType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/docker/DockerProblemType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectInfo";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendEntry";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendEscapedEntry";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendEscapedMappingEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

