/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiTable;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlColumnAliasDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTargetContextProvider;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.SqlWhenClause;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.impl.SqlReturningClauseImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlTriggerStub;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCreateTriggerStatementImpl
extends SqlStubbedDefinitionImpl<SqlTriggerStub>
implements SqlCreateTriggerStatement {
    public SqlCreateTriggerStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            SqlCreateTriggerStatementImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public SqlCreateTriggerStatementImpl(SqlTriggerStub stub) {
        super(stub, SqlCompositeElementTypes.SQL_CREATE_TRIGGER_STATEMENT);
    }

    @Override
    protected SqlReferenceElementType getExpectedNameReferenceElementType() {
        return SqlCompositeElementTypes.SQL_TRIGGER_REFERENCE;
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlCreateTriggerStatement((SqlCreateTriggerStatement)this);
    }

    public SqlReferenceExpression getTargetContextExpression() {
        SqlTriggerStub stub = (SqlTriggerStub)this.getStub();
        if (stub != null) {
            return stub.getTableReference();
        }
        SqlOnTargetClauseImpl target = (SqlOnTargetClauseImpl)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_ON_TARGET_CLAUSE);
        return target == null ? null : (SqlReferenceExpression)ObjectUtils.tryCast((Object)target.getTargetExpression(), SqlReferenceExpression.class);
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        if (!SqlImplUtil.isProcessingOneOf(processor, ObjectKind.TABLE, ObjectKind.COLUMN)) {
            return true;
        }
        SqlReferenceExpression expression = this.getTargetContextExpression();
        if (lastParent.getParent() == this && expression != null && expression != lastParent) {
            if (!this.processFakeDefinitions(processor, state, lastParent, place)) {
                return false;
            }
            if (lastParent instanceof SqlAsExpression) {
                return false;
            }
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    public String getTableName() {
        SqlReferenceExpression ref = this.getTargetContextExpression();
        return ref == null ? null : ref.getName();
    }

    public DasTable getTable() {
        SqlReferenceExpression ref = this.getTargetContextExpression();
        PsiElement resolve = ref == null ? null : ref.resolve();
        return resolve instanceof DasTable ? (DasTable)resolve : null;
    }

    @Nullable
    public SqlExpression getTriggerProcedure() {
        return null;
    }

    protected boolean processFakeDefinitions(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        return true;
    }

    @NotNull
    public Set<TrigEvent> getEvents() {
        SqlTriggerStub stub = (SqlTriggerStub)this.getStub();
        if (stub != null) {
            Set<TrigEvent> set = Collections.emptySet();
            if (set == null) {
                SqlCreateTriggerStatementImpl.$$$reportNull$$$0(1);
            }
            return set;
        }
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        JBIterable events = api.children((Object)this).filter(e -> api.typeOf(e) == SqlCompositeElementTypes.SQL_TRIGGER_EVENT_CLAUSE);
        if (events.isEmpty()) {
            Set<TrigEvent> set = Collections.emptySet();
            if (set == null) {
                SqlCreateTriggerStatementImpl.$$$reportNull$$$0(2);
            }
            return set;
        }
        Set set = events.transform(e -> SqlCreateTriggerStatementImpl.getEvent(e)).filter(Conditions.notNull()).toSet();
        if (set == null) {
            SqlCreateTriggerStatementImpl.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Nullable
    private static TrigEvent getEvent(PsiElement element2) {
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        return (TrigEvent)api.children((Object)element2).transform(api.TO_TYPE).transform(e -> SqlCreateTriggerStatementImpl.getEvent(e)).filter(Conditions.notNull()).first();
    }

    @Nullable
    private static TrigEvent getEvent(IElementType e) {
        if (e == SqlCommonKeywords.SQL_SELECT) {
            return TrigEvent.SELECT;
        }
        if (e == SqlCommonKeywords.SQL_INSERT) {
            return TrigEvent.INSERT;
        }
        if (e == SqlCommonKeywords.SQL_UPDATE) {
            return TrigEvent.UPDATE;
        }
        if (e == SqlCommonKeywords.SQL_DELETE) {
            return TrigEvent.DELETE;
        }
        return null;
    }

    @Nullable
    public TrigTurn getTurn() {
        SqlTriggerStub stub = (SqlTriggerStub)this.getStub();
        if (stub != null) {
            return null;
        }
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        PsiElement gran = (PsiElement)api.children((Object)this).filter(e -> api.typeOf(e) == SqlCompositeElementTypes.SQL_TRIGGER_GRANULARITY_CLAUSE).first();
        boolean forRow = gran != null && !api.children((Object)gran).filter(e -> api.typeOf(e) == SqlCommonKeywords.SQL_ROW).isEmpty();
        PsiElement timeClause = (PsiElement)api.children((Object)this).filter(e -> api.typeOf(e) == SqlCompositeElementTypes.SQL_TRIGGER_TIME_CLAUSE).first();
        if (timeClause == null) {
            return null;
        }
        return (TrigTurn)api.children((Object)timeClause).transform(api.TO_TYPE).transform(e -> SqlCreateTriggerStatementImpl.getTurn(e, forRow)).filter(Conditions.notNull()).first();
    }

    @Nullable
    private static TrigTurn getTurn(IElementType e, boolean row) {
        if (e == SqlCommonKeywords.SQL_INSTEAD) {
            return TrigTurn.INSTEAD_OF;
        }
        if (e == SqlCommonKeywords.SQL_BEFORE) {
            return row ? TrigTurn.BEFORE_ROW : TrigTurn.BEFORE_STMT;
        }
        if (e == SqlCommonKeywords.SQL_AFTER) {
            return row ? TrigTurn.AFTER_ROW : TrigTurn.AFTER_STMT;
        }
        if (e == SqlCommonKeywords.SQL_FOR) {
            return row ? TrigTurn.AFTER_ROW : TrigTurn.AFTER_STMT;
        }
        return null;
    }

    @Nullable
    public String getCondition() {
        SqlTriggerStub stub = (SqlTriggerStub)this.getStub();
        if (stub != null) {
            return null;
        }
        SqlWhenClause whenClause = (SqlWhenClause)PsiTreeUtil.getChildOfType((PsiElement)this, SqlWhenClause.class);
        SqlExpression expr = whenClause != null ? whenClause.getExpression() : null;
        return expr == null ? null : expr.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FakeSynonym
    extends SqlFileImpl.FakeDefinition
    implements SqlAsExpression,
    SqlIdentifier {
        private final PsiElement myTarget;

        public FakeSynonym(@NotNull PsiElement parent2, @Nullable PsiElement target, @NotNull String name) {
            if (parent2 == null) {
                FakeSynonym.$$$reportNull$$$0(0);
            }
            if (name == null) {
                FakeSynonym.$$$reportNull$$$0(1);
            }
            super(parent2, name, name);
            this.myTarget = target;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = SqlDbElementType.LOCAL_ALIAS;
            if (objectKind == null) {
                FakeSynonym.$$$reportNull$$$0(2);
            }
            return objectKind;
        }

        public boolean isNameQuoted() {
            return true;
        }

        @NotNull
        public SqlIdentifier getNameElement() {
            FakeSynonym fakeSynonym = this;
            if (fakeSynonym == null) {
                FakeSynonym.$$$reportNull$$$0(3);
            }
            return fakeSynonym;
        }

        @Nullable
        public SqlExpression getTargetContextExpression() {
            SqlTargetContextProvider trig = (SqlTargetContextProvider)ObjectUtils.tryCast((Object)this.getParent(), SqlTargetContextProvider.class);
            if (trig != null) {
                return trig.getTargetContextExpression();
            }
            SqlReturningClauseImpl returning = (SqlReturningClauseImpl)((Object)ObjectUtils.tryCast((Object)this.getParent(), SqlReturningClauseImpl.class));
            if (returning != null) {
                return returning.getTargetExpression();
            }
            return null;
        }

        @NotNull
        public SqlType getSqlType() {
            if (this.myTarget instanceof PsiTable) {
                SqlTableType sqlTableType = SqlTableTypeBase.createType((PsiTable)this.myTarget, (PsiElement)this);
                if (sqlTableType == null) {
                    FakeSynonym.$$$reportNull$$$0(4);
                }
                return sqlTableType;
            }
            SqlExpression expression = this.getTargetContextExpression();
            if (expression == null) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                if (sqlPrimitiveType == null) {
                    FakeSynonym.$$$reportNull$$$0(5);
                }
                return sqlPrimitiveType;
            }
            SqlType type = expression.getSqlType();
            SqlTableType tableType = (SqlTableType)ObjectUtils.tryCast((Object)type, SqlTableType.class);
            if (tableType == null) {
                SqlType sqlType = type;
                if (sqlType == null) {
                    FakeSynonym.$$$reportNull$$$0(6);
                }
                return sqlType;
            }
            SqlTableType sqlTableType = tableType.alias(this.getName(), (PsiElement)this, Collections.emptyList());
            if (sqlTableType == null) {
                FakeSynonym.$$$reportNull$$$0(7);
            }
            return sqlTableType;
        }

        @Nullable
        public SqlExpression getExpression() {
            return (SqlExpression)ObjectUtils.chooseNotNull((Object)this.getTargetContextExpression(), (Object)((Object)this));
        }

        @NotNull
        public List<SqlColumnAliasDefinition> getColumnAliasList() {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                FakeSynonym.$$$reportNull$$$0(8);
            }
            return list;
        }

        public TextRange getNameRange() {
            return TextRange.EMPTY_RANGE;
        }

        @Nullable
        public String getNamePrefix() {
            return null;
        }

        @Override
        public FakeSynonym setName(@NotNull String name) throws IncorrectOperationException {
            if (name == null) {
                FakeSynonym.$$$reportNull$$$0(9);
            }
            super.setName(name);
            return this;
        }

        @Override
        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = (PsiElement)ObjectUtils.chooseNotNull((Object)this.myTarget, (Object)ObjectUtils.chooseNotNull((Object)this.getTargetContextExpression(), (Object)ObjectUtils.chooseNotNull((Object)this.getNameElement(), (Object)((Object)this))));
            if (psiElement == null) {
                FakeSynonym.$$$reportNull$$$0(10);
            }
            return psiElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl$FakeSynonym";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl$FakeSynonym";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameElement";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSqlType";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnAliasList";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class FakeTablesHandler {
        private final PsiElement myProvider;
        private final PsiElement myTarget;
        private final FakeSynonym[] mySynonyms;

        public FakeTablesHandler(@NotNull PsiElement provider, @Nullable PsiElement target, String ... names) {
            if (provider == null) {
                FakeTablesHandler.$$$reportNull$$$0(0);
            }
            if (names == null) {
                FakeTablesHandler.$$$reportNull$$$0(1);
            }
            this.myProvider = provider;
            this.myTarget = target;
            this.mySynonyms = new FakeSynonym[names.length];
            for (int i2 = 0; i2 < names.length; ++i2) {
                this.mySynonyms[i2] = new FakeSynonym(provider, this.myTarget, names[i2]);
            }
        }

        @NotNull
        public PsiElement getProvider() {
            PsiElement psiElement = this.myProvider;
            if (psiElement == null) {
                FakeTablesHandler.$$$reportNull$$$0(2);
            }
            return psiElement;
        }

        public FakeTablesHandler(@NotNull PsiElement provider, String ... names) {
            if (provider == null) {
                FakeTablesHandler.$$$reportNull$$$0(3);
            }
            if (names == null) {
                FakeTablesHandler.$$$reportNull$$$0(4);
            }
            this(provider, (PsiElement)null, names);
        }

        public boolean processSimple(PsiScopeProcessor processor, ResolveState state) {
            for (FakeSynonym synonym : this.mySynonyms) {
                if (processor.execute((PsiElement)synonym, state)) continue;
                return false;
            }
            return true;
        }

        public boolean processAliased(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
            SqlAsExpression[] aliases;
            if (PsiUtilCore.getElementType((PsiElement)lastParent) == SqlCompositeElementTypes.SQL_REFERENCING_CLAUSE) {
                return this.processSimple(processor, state);
            }
            boolean[] marks = new boolean[this.mySynonyms.length];
            PsiElement referencing = PsiTreeUtil.findSiblingForward((PsiElement)this.myProvider.getFirstChild(), (IElementType)SqlCompositeElementTypes.SQL_REFERENCING_CLAUSE, null);
            SqlAsExpression[] sqlAsExpressionArray = aliases = referencing == null ? null : (SqlAsExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)referencing, SqlAsExpression.class);
            if (aliases == null) {
                return this.processSimple(processor, state);
            }
            for (SqlAsExpression expr : aliases) {
                String name;
                SqlNameElement aliased = (SqlNameElement)ObjectUtils.tryCast((Object)expr.getExpression(), SqlNameElement.class);
                String string = name = aliased == null ? null : aliased.getName();
                if (!StringUtil.isNotEmpty((String)name)) continue;
                for (int i2 = 0; i2 < this.mySynonyms.length; ++i2) {
                    if (!this.mySynonyms[i2].getName().equalsIgnoreCase(name)) continue;
                    marks[i2] = true;
                }
            }
            for (int i3 = 0; i3 < this.mySynonyms.length; ++i3) {
                if (marks[i3] || processor.execute((PsiElement)this.mySynonyms[i3], state)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "names";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl$FakeTablesHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl$FakeTablesHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

