/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.exceptions.UnexpectedDBException;
import org.jetbrains.dekaf.exceptions.UnexpectedReflectionException;
import org.jetbrains.dekaf.jdbc.JdbcRowFetcher;
import org.jetbrains.dekaf.jdbc.JdbcUtil;
import org.jetbrains.dekaf.jdbc.JdbcValueGetter;
import org.jetbrains.dekaf.jdbc.JdbcValueGetters;
import org.jetbrains.dekaf.util.NameAndClass;

public class JdbcRowFetchers {
    public static <V> OneValueFetcher<V> createOneValueFetcher(int position, JdbcValueGetter<V> getter) {
        return new OneValueFetcher<V>(position, getter);
    }

    public static <V> ArrayFetcher<V> createArrayFetcher(int position, Class<V> commonClass, JdbcValueGetter<? extends V>[] getters) {
        return new ArrayFetcher(position, commonClass, getters);
    }

    public static IntArrayFetcher createIntArrayFetcher(int position) {
        return new IntArrayFetcher(position);
    }

    public static LongArrayFetcher createLongArrayFetcher(int position) {
        return new LongArrayFetcher(position);
    }

    public static TupleFetcher createTupleFetcher(NameAndClass[] components) {
        return new TupleFetcher(components);
    }

    public static <S> StructFetcher<S> createStructFetcher(Class<S> structClass, NameAndClass[] components) {
        return new StructFetcher<S>(structClass, components);
    }

    protected static Field getClassField(@NotNull Class<?> structClass, String name) throws NoSuchFieldException {
        return structClass.getDeclaredField(name);
    }

    public static final class StructFetcher<S>
    extends ComplexFetcher<S> {
        private final Class<S> structClass;
        private final Constructor<S> structConstructor;
        private final Field[] fields;
        private boolean myRequiresInit = true;

        public StructFetcher(@NotNull Class<S> structClass, @NotNull NameAndClass[] components) {
            super(components);
            this.structClass = structClass;
            int n = components.length;
            this.fields = new Field[n];
            try {
                this.structConstructor = structClass.getDeclaredConstructor(new Class[0]);
                this.structConstructor.setAccessible(true);
                for (int i = 0; i < n; ++i) {
                    String name = components[i].name;
                    Field f = JdbcRowFetchers.getClassField(structClass, name);
                    if (f == null) continue;
                    f.setAccessible(true);
                    this.fields[i] = f;
                }
            }
            catch (Exception e) {
                throw new UnexpectedReflectionException("Failed to analyze class " + structClass.getName(), e);
            }
        }

        @Override
        S fetchRow(@NotNull ResultSet rset) throws SQLException {
            if (this.myRequiresInit) {
                this.initGetters(rset.getMetaData());
            }
            try {
                S struct = this.structConstructor.newInstance(new Object[0]);
                int n = this.columnIndices.length;
                for (int i = 0; i < n; ++i) {
                    Object value;
                    int columnIndex = this.columnIndices[i];
                    Field f = this.fields[i];
                    JdbcValueGetter g = this.getters[i];
                    if (columnIndex <= 0 || f == null || g == null || (value = g.getValue(rset, columnIndex)) == null) continue;
                    f.set(struct, value);
                }
                return struct;
            }
            catch (InstantiationException e) {
                throw new UnexpectedReflectionException("Failed to create/populate class " + this.structClass, e);
            }
            catch (IllegalAccessException e) {
                throw new UnexpectedReflectionException("Failed to create/populate class " + this.structClass, e);
            }
            catch (InvocationTargetException e) {
                throw new UnexpectedReflectionException("Failed to create/populate class " + this.structClass, e);
            }
        }
    }

    public static final class TupleFetcher
    extends ComplexFetcher<Object[]> {
        public TupleFetcher(@NotNull NameAndClass[] components) {
            super(components);
        }

        @Override
        Object[] fetchRow(@NotNull ResultSet rset) throws SQLException {
            if (this.myRequiresInit) {
                this.initGetters(rset.getMetaData());
            }
            Object[] tuple = new Object[this.components.length];
            int n = this.columnIndices.length;
            for (int i = 0; i < n; ++i) {
                int columnIndex = this.columnIndices[i];
                JdbcValueGetter g = this.getters[i];
                if (columnIndex <= 0 || g == null) continue;
                Object value = g.getValue(rset, columnIndex);
                tuple[i] = value;
            }
            return tuple;
        }
    }

    public static abstract class ComplexFetcher<X>
    extends JdbcRowFetcher<X> {
        protected final NameAndClass[] components;
        protected final int[] columnIndices;
        protected final JdbcValueGetter<?>[] getters;
        protected boolean myRequiresInit = true;

        public ComplexFetcher(@NotNull NameAndClass[] components) {
            this.components = components;
            int n = components.length;
            this.columnIndices = new int[n];
            this.getters = new JdbcValueGetter[n];
        }

        protected void initGetters(@NotNull ResultSetMetaData md) {
            try {
                int n = this.components.length;
                TreeMap<String, Integer> columnNames = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
                int cn = md.getColumnCount();
                for (int j = 1; j <= cn; ++j) {
                    String columnName = JdbcUtil.getColumnName(md, j);
                    columnNames.put(columnName, j);
                }
                for (int i = 0; i < n; ++i) {
                    String name = this.components[i].name;
                    Integer columnIndex = (Integer)columnNames.get(name);
                    if (columnIndex == null) continue;
                    int jdbcType = md.getColumnType(columnIndex);
                    JdbcValueGetter valueGetter = JdbcValueGetters.of(jdbcType, this.components[i].clazz);
                    this.columnIndices[i] = columnIndex;
                    this.getters[i] = valueGetter;
                }
            }
            catch (SQLException sqle) {
                throw new UnexpectedDBException("Analysing metadata of the query result", sqle, null);
            }
            this.myRequiresInit = false;
        }
    }

    public static final class LongArrayFetcher
    extends JdbcRowFetcher<long[]> {
        private final int position;
        private JdbcValueGetter<Long>[] getters;

        private LongArrayFetcher(int position) {
            this.position = position;
        }

        private void init(@NotNull ResultSetMetaData md) throws SQLException {
            int n = Math.max(md.getColumnCount() - (this.position - 1), 0);
            this.getters = new JdbcValueGetter[n];
            for (int i = 0; i < n; ++i) {
                int jdbcType = md.getColumnType(this.position + i);
                JdbcValueGetter<Long> valueGetter = JdbcValueGetters.of(jdbcType, Long.TYPE);
                this.getters[i] = valueGetter;
            }
        }

        @Override
        long[] fetchRow(@NotNull ResultSet rset) throws SQLException {
            if (this.getters == null) {
                this.init(rset.getMetaData());
            }
            int n = this.getters.length;
            long[] array = new long[n];
            for (int j = 0; j < n; ++j) {
                Long value = this.getters[j].getValue(rset, this.position + j);
                array[j] = value == null ? 0L : value;
            }
            return array;
        }
    }

    public static final class IntArrayFetcher
    extends JdbcRowFetcher<int[]> {
        private final int position;
        private JdbcValueGetter<Integer>[] getters;

        private IntArrayFetcher(int position) {
            this.position = position;
        }

        private void init(@NotNull ResultSetMetaData md) throws SQLException {
            int n = Math.max(md.getColumnCount() - (this.position - 1), 0);
            this.getters = new JdbcValueGetter[n];
            for (int i = 0; i < n; ++i) {
                int jdbcType = md.getColumnType(this.position + i);
                JdbcValueGetter<Integer> valueGetter = JdbcValueGetters.of(jdbcType, Integer.TYPE);
                this.getters[i] = valueGetter;
            }
        }

        @Override
        int[] fetchRow(@NotNull ResultSet rset) throws SQLException {
            if (this.getters == null) {
                this.init(rset.getMetaData());
            }
            int n = this.getters.length;
            int[] array = new int[n];
            for (int j = 0; j < n; ++j) {
                Integer value = this.getters[j].getValue(rset, this.position + j);
                array[j] = value == null ? 0 : value;
            }
            return array;
        }
    }

    public static final class ArrayFetcher<V>
    extends JdbcRowFetcher<V[]> {
        private final int position;
        private final Class<V> commonClass;
        private final JdbcValueGetter<? extends V>[] getters;

        private ArrayFetcher(int position, Class<V> commonClass, JdbcValueGetter<? extends V>[] getters) {
            this.position = position;
            this.commonClass = commonClass;
            this.getters = getters;
        }

        @Override
        V[] fetchRow(@NotNull ResultSet rset) throws SQLException {
            int n = this.getters.length;
            Object[] array = (Object[])Array.newInstance(this.commonClass, n);
            for (int j = 0; j < n; ++j) {
                array[j] = this.getters[j].getValue(rset, this.position + j);
            }
            return array;
        }
    }

    public static final class OneValueFetcher<V>
    extends JdbcRowFetcher<V> {
        private final int position;
        private final JdbcValueGetter<V> getter;

        OneValueFetcher(int position, JdbcValueGetter<V> getter) {
            this.position = position;
            this.getter = getter;
        }

        @Override
        V fetchRow(@NotNull ResultSet rset) throws SQLException {
            return this.getter.getValue(rset, this.position);
        }
    }
}

