/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.protractor;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.protractor.ProtractorRunConfigurationEditor;
import com.intellij.javascript.protractor.ProtractorRunSettings;
import com.intellij.javascript.protractor.ProtractorRunState;
import com.intellij.javascript.protractor.ProtractorUtil;
import com.intellij.javascript.protractor.scope.ProtractorScopeKind;
import com.intellij.javascript.testFramework.PreferableRunConfiguration;
import com.intellij.javascript.testFramework.util.JsTestFqn;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtractorRunConfiguration
extends LocatableConfigurationBase
implements NodeDebugRunConfiguration,
PreferableRunConfiguration,
JSRunProfileWithCompileBeforeLaunchOption {
    private ProtractorRunSettings mySettings;

    public ProtractorRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, String name) {
        if (project == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(1);
        }
        super(project, factory, name);
        this.mySettings = ProtractorRunSettings.builder().build();
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(2);
        }
        if (environment == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(3);
        }
        NodePackage pkg = this.getProtractorPackage();
        return new ProtractorRunState(this, environment, pkg);
    }

    @NotNull
    public ProtractorRunConfigurationEditor getConfigurationEditor() {
        ProtractorRunConfigurationEditor protractorRunConfigurationEditor = new ProtractorRunConfigurationEditor(this.getProject());
        if (protractorRunConfigurationEditor == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(4);
        }
        return protractorRunConfigurationEditor;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(5);
        }
        super.readExternal(element);
        this.mySettings = ProtractorUtil.readXml(element);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(6);
        }
        super.writeExternal(element);
        ProtractorUtil.writeXml(element, this.mySettings);
    }

    @NotNull
    public ProtractorRunSettings getRunSettings() {
        ProtractorRunSettings protractorRunSettings = this.mySettings;
        if (protractorRunSettings == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(7);
        }
        return protractorRunSettings;
    }

    public void setRunSettings(@NotNull ProtractorRunSettings settings) {
        NodePackage pkg;
        if (settings == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(8);
        }
        if ((pkg = settings.getPackage()) != null && pkg.isEmptyPath() && RunManager.getInstance((Project)this.getProject()).isTemplate((RunConfiguration)this)) {
            settings = settings.toBuilder().setPackage(null).build();
        }
        this.mySettings = settings;
        if (settings.getPackage() != null) {
            ProtractorUtil.setProtractorPackage(this.getProject(), settings.getPackage());
        }
    }

    @NotNull
    NodePackage getProtractorPackage() {
        if (RunManager.getInstance((Project)this.getProject()).isTemplate((RunConfiguration)this)) {
            NodePackage nodePackage = (NodePackage)ObjectUtils.notNull((Object)this.mySettings.getPackage(), (Object)new NodePackage(""));
            if (nodePackage == null) {
                ProtractorRunConfiguration.$$$reportNull$$$0(9);
            }
            return nodePackage;
        }
        NodePackage pkg = this.mySettings.getPackage();
        if (pkg == null) {
            Project project = this.getProject();
            pkg = new NodePackageDescriptor("protractor").findFirstDirectDependencyPackage(project, null, this.getContextFile());
            if (pkg.isEmptyPath()) {
                pkg = ProtractorUtil.getProtractorPackage(project);
            } else {
                ProtractorUtil.setProtractorPackage(project, pkg);
            }
            this.mySettings = this.mySettings.toBuilder().setPackage(pkg).build();
        }
        NodePackage nodePackage = pkg;
        if (nodePackage == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(10);
        }
        return nodePackage;
    }

    @Nullable
    private VirtualFile getContextFile() {
        return ProtractorRunConfiguration.findFile(this.mySettings.getConfigFileSystemDependentPath());
    }

    @Nullable
    private static VirtualFile findFile(@NotNull String path) {
        if (path == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(11);
        }
        return FileUtil.isAbsolute((String)path) ? LocalFileSystem.getInstance().findFileByPath(path) : null;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        ProtractorRunConfiguration.validatePath(false, "configuration file", this.mySettings.getConfigFileSystemDependentPath());
        NodeInterpreterUtil.checkForRunConfiguration(this.mySettings.getInterpreterRef().resolve(this.getProject()));
        NodePackage pkg = this.getProtractorPackage();
        ProtractorRunConfiguration.validatePath(true, "protractor package", pkg.getSystemDependentPath());
        File protractorMainJsFile = ProtractorUtil.getProtractorMainJsFile(pkg);
        ProtractorRunConfiguration.validatePath(false, "bin/protractor file in protractor package", protractorMainJsFile.getAbsolutePath());
        ProtractorScopeKind scopeKind = this.mySettings.getScopeKind();
        if (scopeKind == ProtractorScopeKind.TEST_FILE || scopeKind == ProtractorScopeKind.SUITE || scopeKind == ProtractorScopeKind.TEST) {
            ProtractorRunConfiguration.validatePath(false, "test file", this.mySettings.getTestFileSystemDependentPath());
            if (scopeKind == ProtractorScopeKind.SUITE && this.mySettings.getTestNames().isEmpty()) {
                throw new RuntimeConfigurationError("Unspecified suite name");
            }
            if (scopeKind == ProtractorScopeKind.TEST && this.mySettings.getTestNames().isEmpty()) {
                throw new RuntimeConfigurationError("Unspecified test name");
            }
        }
    }

    public void onNewConfigurationCreated() {
        List<VirtualFile> configs;
        ProtractorRunSettings runSettings = this.mySettings;
        if (runSettings.getConfigFileSystemDependentPath().isEmpty() && (configs = ProtractorUtil.listExactConfigFilesInProject(this.getProject())).size() == 1) {
            this.setConfigFile(configs.get(0));
            this.setGeneratedName();
        }
        this.setNameChangedByUser(false);
    }

    public void setConfigFile(VirtualFile config2) {
        this.mySettings = this.mySettings.toBuilder().setConfigFilePath(config2.getPath()).build();
    }

    public boolean isPreferredOver(@NotNull RunConfiguration otherRc, @NotNull PsiElement sourceElement) {
        VirtualFile dir;
        if (otherRc == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(12);
        }
        if (sourceElement == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(13);
        }
        if (ProtractorUtil.isProtractorConfigFile(sourceElement.getContainingFile().getName())) {
            return true;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)this.getProject());
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)sourceElement.getContainingFile());
        if (file2 == null) {
            return false;
        }
        VirtualFile virtualFile = dir = file2.isDirectory() ? file2 : file2.getParent();
        if (dir == null) {
            return false;
        }
        VirtualFile contentRoot = fileIndex.getContentRootForFile(dir, false);
        while (dir != null && contentRoot != null) {
            CharSequence dirName = dir.getNameSequence();
            if (StringUtil.equals((CharSequence)"e2e", (CharSequence)dirName)) {
                return true;
            }
            if (dir.equals(contentRoot)) {
                dir = dir.getParent();
                contentRoot = fileIndex.getContentRootForFile(dir, false);
                continue;
            }
            dir = dir.getParent();
        }
        return false;
    }

    private static void validatePath(boolean shouldBeDirectory, @NotNull String name, @Nullable String path) throws RuntimeConfigurationException {
        boolean exists;
        if (name == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(14);
        }
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            throw new RuntimeConfigurationError("Unspecified " + name);
        }
        File file2 = new File(path);
        if (!file2.isAbsolute()) {
            throw new RuntimeConfigurationError("No such " + name);
        }
        boolean bl = exists = shouldBeDirectory ? file2.isDirectory() : file2.isFile();
        if (!exists) {
            throw new RuntimeConfigurationError("No such " + name);
        }
    }

    public String suggestedName() {
        ProtractorRunSettings settings = this.mySettings;
        ProtractorScopeKind scopeKind = settings.getScopeKind();
        if (scopeKind == ProtractorScopeKind.ALL) {
            List options;
            Optional<String> option;
            String prefix = "--suite=";
            if (settings.getProtractorOptions().contains(prefix) && (option = (options = ParametersListUtil.parse((String)settings.getProtractorOptions())).stream().filter(o -> o.startsWith(prefix)).findFirst()).isPresent()) {
                return option.get().substring(prefix.length());
            }
            return PathUtil.getFileName((String)settings.getConfigFileSystemDependentPath());
        }
        if (scopeKind == ProtractorScopeKind.TEST_FILE) {
            return PathUtil.getFileName((String)settings.getTestFileSystemDependentPath());
        }
        if (scopeKind == ProtractorScopeKind.SUITE || scopeKind == ProtractorScopeKind.TEST) {
            return JsTestFqn.getPresentableName(settings.getTestNames());
        }
        return super.suggestedName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/protractor/ProtractorRunConfiguration";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherRc";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/protractor/ProtractorRunConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunSettings";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtractorPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setRunSettings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isPreferredOver";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "validatePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

