/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.editor;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.laf.darcula.DarculaLookAndFeelInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.javafx.JavaFxHtmlPanel;
import com.jetbrains.rest.editor.RestPreviewPanel;
import java.net.URL;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.html.HTMLAnchorElement;

public class RestJavaFxHtmlPanel
extends JavaFxHtmlPanel
implements RestPreviewPanel {
    private volatile int myYScrollPosition = 0;
    private volatile int myXScrollPosition = 0;

    public RestJavaFxHtmlPanel() {
        LafManager.getInstance().addLafManagerListener((LafManagerListener)new RestLafManagerListener());
        this.runInPlatformWhenAvailable(() -> {
            WebView webView = this.getWebViewGuaranteed();
            webView.fontSmoothingTypeProperty().setValue((Object)FontSmoothingType.LCD);
            webView.getEngine().getLoadWorker().stateProperty().addListener((ChangeListener)new HyperlinkRedirectListener(webView));
            this.updateLaf(LafManager.getInstance().getCurrentLookAndFeel() instanceof DarculaLookAndFeelInfo);
            webView.getEngine().getLoadWorker().stateProperty().addListener((ov, oldState, newState) -> {
                if (newState == Worker.State.SUCCEEDED) {
                    RestJavaFxHtmlPanel.scrollTo(webView, this.myXScrollPosition, this.myYScrollPosition);
                }
            });
        });
    }

    private URL getStyle(boolean isDarcula) {
        return this.getClass().getResource(isDarcula ? "/styles/darcula.css" : "/styles/default.css");
    }

    private void updateLaf(boolean isDarcula) {
        ApplicationManager.getApplication().invokeLater(() -> this.runInPlatformWhenAvailable(() -> {
            WebView webView = this.getWebViewGuaranteed();
            webView.getEngine().setUserStyleSheetLocation(this.getStyle(isDarcula).toExternalForm());
        }));
    }

    private static void scrollTo(WebView view, int x, int y) {
        view.getEngine().executeScript("window.scrollTo(" + x + ", " + y + ")");
    }

    private static int getVScrollValue(WebView view) {
        return (Integer)view.getEngine().executeScript("document.body.scrollTop");
    }

    private static int getHScrollValue(WebView view) {
        return (Integer)view.getEngine().executeScript("document.body.scrollLeft");
    }

    @Override
    public void setHtml(@NotNull String html) {
        if (html == null) {
            RestJavaFxHtmlPanel.$$$reportNull$$$0(0);
        }
        this.runInPlatformWhenAvailable(() -> {
            this.myYScrollPosition = RestJavaFxHtmlPanel.getVScrollValue(this.getWebViewGuaranteed());
            this.myXScrollPosition = RestJavaFxHtmlPanel.getHScrollValue(this.getWebViewGuaranteed());
        });
        super.setHtml(html);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "html", "com/jetbrains/rest/editor/RestJavaFxHtmlPanel", "setHtml"));
    }

    private static class HyperlinkRedirectListener
    implements ChangeListener<Worker.State> {
        private static final String EVENT_TYPE_CLICK = "click";
        private final WebEngine myEngine;

        private HyperlinkRedirectListener(WebView view) {
            this.myEngine = view.getEngine();
        }

        public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
            if (newValue == Worker.State.SUCCEEDED) {
                EventListener listener = HyperlinkRedirectListener.makeHyperLinkListener();
                this.addListenerToAllHyperlinkItems(listener);
            }
        }

        private void addListenerToAllHyperlinkItems(EventListener listener) {
            Document doc = this.myEngine.getDocument();
            if (doc != null) {
                NodeList nodeList = doc.getElementsByTagName("a");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    ((EventTarget)((Object)nodeList.item(i))).addEventListener(EVENT_TYPE_CLICK, listener, false);
                }
            }
        }

        @NotNull
        private static EventListener makeHyperLinkListener() {
            EventListener eventListener = new EventListener(){

                @Override
                public void handleEvent(Event ev) {
                    EventTarget target = ev.getCurrentTarget();
                    HTMLAnchorElement anchorElement = (HTMLAnchorElement)((Object)target);
                    String href = anchorElement.getHref();
                    if (href == null) {
                        return;
                    }
                    BrowserUtil.browse((String)href);
                    ev.preventDefault();
                }
            };
            if (eventListener == null) {
                HyperlinkRedirectListener.$$$reportNull$$$0(0);
            }
            return eventListener;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/rest/editor/RestJavaFxHtmlPanel$HyperlinkRedirectListener", "makeHyperLinkListener"));
        }
    }

    private class RestLafManagerListener
    implements LafManagerListener {
        private RestLafManagerListener() {
        }

        public void lookAndFeelChanged(@NotNull LafManager manager) {
            if (manager == null) {
                RestLafManagerListener.$$$reportNull$$$0(0);
            }
            RestJavaFxHtmlPanel.this.updateLaf(manager.getCurrentLookAndFeel() instanceof DarculaLookAndFeelInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/jetbrains/rest/editor/RestJavaFxHtmlPanel$RestLafManagerListener", "lookAndFeelChanged"));
        }
    }
}

