/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.media.css3;

import org.w3c.css.media.MediaFeature;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssResolution;
import org.w3c.css.values.CssValue;

public class MediaResolution
extends MediaFeature {
    public MediaResolution() {
    }

    public MediaResolution(ApplContext ac, String modifier, CssExpression expression, boolean check2) throws InvalidParamException {
        if (expression != null) {
            CssResolution valnum;
            if (expression.getCount() > 1) {
                throw new InvalidParamException("unrecognize", ac);
            }
            CssValue val = expression.getValue();
            if (val.getType() == 10) {
                valnum = (CssResolution)val;
                if (valnum.getFloatValue() < 0.0f) {
                    throw new InvalidParamException("negative-value", val.toString(), ac);
                }
            } else {
                throw new InvalidParamException("unrecognize", ac);
            }
            this.value = valnum;
            this.setModifier(ac, modifier);
        } else if (modifier != null) {
            throw new InvalidParamException("nomodifiershortmedia", this.getFeatureName(), ac);
        }
    }

    public MediaResolution(ApplContext ac, String modifier, CssExpression expression) throws InvalidParamException {
        this(ac, modifier, expression, false);
    }

    public Object get() {
        return this.value;
    }

    @Override
    public final String getFeatureName() {
        return "resolution";
    }

    @Override
    public boolean equals(MediaFeature other) {
        try {
            MediaResolution mr = (MediaResolution)other;
            return (this.value == null && mr.value == null || this.value != null && this.value.equals(mr.value)) && (this.modifier == null && mr.modifier == null || this.modifier != null && this.modifier.equals(mr.modifier));
        }
        catch (ClassCastException cce) {
            return false;
        }
    }
}

