/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.changeSignature;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.refactoring.ui.StringTableCellEditor;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragmentImpl;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterTableModelItem;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpParameterTableModel
extends ParameterTableModelBase<PhpParameterInfo, PhpParameterTableModelItem> {
    private final Project myProject;

    public PhpParameterTableModel(PsiElement typeContext, PsiElement defaultValueContext, Project project) {
        super(typeContext, defaultValueContext, PhpParameterTableModel.getColumns(project));
        this.myProject = project;
    }

    private static ColumnInfo[] getColumns(Project project) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add((Object)new PhpParameterColumn(project));
        result.add((Object)new PhpDefaultValueColumn(project));
        return result.toArray(ColumnInfo.EMPTY_ARRAY);
    }

    protected PhpParameterTableModelItem createRowItem(@Nullable PhpParameterInfo parameterInfo) {
        if (parameterInfo == null) {
            parameterInfo = new PhpParameterInfo(-1);
        }
        PsiCodeFragment typeCodeFragment = PhpParameterTableModel.createCodeFragment(this.myProject, StringUtil.notNullize((String)parameterInfo.getTypeText()), null);
        PsiCodeFragment defaultValueCodeFragment = PhpParameterTableModel.createCodeFragment(this.myProject, StringUtil.notNullize((String)parameterInfo.getDefaultValue()), this.myDefaultValueContext);
        return new PhpParameterTableModelItem(parameterInfo, typeCodeFragment, PhpFunctionCodeGenerator.generateParameter(parameterInfo), defaultValueCodeFragment);
    }

    @NotNull
    public static PsiCodeFragment createCodeFragment(@NotNull Project project, @NotNull CharSequence text, @Nullable PsiElement context) {
        if (project == null) {
            PhpParameterTableModel.$$$reportNull$$$0(0);
        }
        if (text == null) {
            PhpParameterTableModel.$$$reportNull$$$0(1);
        }
        String name = "fragment." + PhpFileType.INSTANCE.getDefaultExtension();
        GlobalSearchScope resolveScope = ProjectScope.getAllScope((Project)project);
        PhpExpressionCodeFragmentImpl fragment = new PhpExpressionCodeFragmentImpl(project, name, text, context, true);
        fragment.forceResolveScope(resolveScope);
        fragment.setContentElementType((IElementType)PhpStubElementTypes.FILE);
        PhpExpressionCodeFragmentImpl phpExpressionCodeFragmentImpl = fragment;
        if (phpExpressionCodeFragmentImpl == null) {
            PhpParameterTableModel.$$$reportNull$$$0(2);
        }
        return phpExpressionCodeFragmentImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/changeSignature/PhpParameterTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/changeSignature/PhpParameterTableModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCodeFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCodeFragment";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpParameterColumn
    extends ParameterTableModelBase.ColumnInfoBase<PhpParameterInfo, PhpParameterTableModelItem, String> {
        private final Project myProject;

        PhpParameterColumn(Project project) {
            super(PhpBundle.message("change.signature.column.name.parameter", new Object[0]));
            this.myProject = project;
        }

        public boolean isCellEditable(PhpParameterTableModelItem item) {
            return true;
        }

        public void setValue(PhpParameterTableModelItem item, String value) {
            item.parameterCodeFragment = value;
        }

        public String valueOf(PhpParameterTableModelItem item) {
            return item.parameterCodeFragment;
        }

        protected TableCellRenderer doCreateRenderer(PhpParameterTableModelItem item) {
            return new ColoredTableCellRenderer(){

                public void customizeCellRenderer(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    if (value == null) {
                        return;
                    }
                    if (isSelected || hasFocus) {
                        this.acquireState(table, true, false, row, column);
                        this.getCellState().updateRenderer((JComponent)((Object)this));
                        this.setPaintFocusBorder(false);
                    }
                    this.append((String)value, new SimpleTextAttributes(0, null));
                }
            };
        }

        protected TableCellEditor doCreateEditor(PhpParameterTableModelItem s) {
            return new StringTableCellEditor(this.myProject);
        }
    }

    private static class PhpDefaultValueColumn
    extends ParameterTableModelBase.DefaultValueColumn<PhpParameterInfo, PhpParameterTableModelItem> {
        PhpDefaultValueColumn(Project project) {
            super(project, (FileType)PhpFileType.INSTANCE);
        }

        public boolean isCellEditable(PhpParameterTableModelItem item) {
            return true;
        }
    }
}

