/*
 * Decompiled with CFR 0.152.
 */
package scalacache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scalacache.AbstractCache;
import scalacache.CacheAlg;
import scalacache.CacheConfig;
import scalacache.Entry;
import scalacache.Flags;
import scalacache.LoggingSupport;
import scalacache.Mode;
import scalacache.caffeine.CaffeineCache$;

@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u0001\u0003\u0001\u001d\u0011QbQ1gM\u0016Lg.Z\"bG\",'BA\u0002\u0005\u0003!\u0019\u0017M\u001a4fS:,'\"A\u0003\u0002\u0015M\u001c\u0017\r\\1dC\u000eDWm\u0001\u0001\u0016\u0005!)2c\u0001\u0001\n\u001fA\u0011!\"D\u0007\u0002\u0017)\tA\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000f\u0017\t1\u0011I\\=SK\u001a\u00042\u0001E\t\u0014\u001b\u0005!\u0011B\u0001\n\u0005\u00055\t%m\u001d;sC\u000e$8)Y2iKB\u0011A#\u0006\u0007\u0001\t\u00151\u0002A1\u0001\u0018\u0005\u00051\u0016C\u0001\r\u001c!\tQ\u0011$\u0003\u0002\u001b\u0017\t9aj\u001c;iS:<\u0007C\u0001\u0006\u001d\u0013\ti2BA\u0002B]fD\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u000bk:$WM\u001d7zS:<\u0007\u0003B\u0011,[aj\u0011A\t\u0006\u0003G\u0011\nQaY1dQ\u0016T!aA\u0013\u000b\u0005\u0019:\u0013\u0001\u00032f]6\fg.Z:\u000b\u0005!J\u0013AB4ji\",(MC\u0001+\u0003\r\u0019w.\\\u0005\u0003Y\t\u0012QaQ1dQ\u0016\u0004\"AL\u001b\u000f\u0005=\u001a\u0004C\u0001\u0019\f\u001b\u0005\t$B\u0001\u001a\u0007\u0003\u0019a$o\\8u}%\u0011AgC\u0001\u0007!J,G-\u001a4\n\u0005Y:$AB*ue&twM\u0003\u00025\u0017A\u0019\u0001#O\n\n\u0005i\"!!B#oiJL\b\u0002\u0003\u001f\u0001\u0005\u000b\u0007I1A\u001f\u0002\r\r|gNZ5h+\u0005q\u0004C\u0001\t@\u0013\t\u0001EAA\u0006DC\u000eDWmQ8oM&<\u0007\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \u0002\u000f\r|gNZ5hA!AA\t\u0001B\u0001B\u0003-Q)A\u0003dY>\u001c7\u000e\u0005\u0002G\u00176\tqI\u0003\u0002I\u0013\u0006!A/[7f\u0015\u0005Q\u0015\u0001\u00026bm\u0006L!\u0001T$\u0003\u000b\rcwnY6\t\u000b9\u0003A\u0011A(\u0002\rqJg.\u001b;?)\t\u0001V\u000bF\u0002R'R\u00032A\u0015\u0001\u0014\u001b\u0005\u0011\u0001\"\u0002\u001fN\u0001\bq\u0004b\u0002#N!\u0003\u0005\u001d!\u0012\u0005\u0006?5\u0003\r\u0001\t\u0005\b/\u0002\u0011\r\u0011\"\u0016Y\u0003\u0019awnZ4feV\t\u0011\f\u0005\u0002[?6\t1L\u0003\u0002];\u0006)1\u000f\u001c45U*\ta,A\u0002pe\u001eL!\u0001Y.\u0003\r1{wmZ3s\u0011\u0019\u0011\u0007\u0001)A\u00073\u00069An\\4hKJ\u0004\u0003\"\u00023\u0001\t\u0003)\u0017!\u00023p\u000f\u0016$XC\u00014j)\t9w\u000f\u0006\u0002icB\u0019A#\u001b8\u0005\u000b)\u001c'\u0019A6\u0003\u0003\u0019+\"a\u00067\u0005\u000b5L'\u0019A\f\u0003\u0003}\u00032AC8\u0014\u0013\t\u00018B\u0001\u0004PaRLwN\u001c\u0005\u0006e\u000e\u0004\u001da]\u0001\u0005[>$W\rE\u0002\u0011iZL!!\u001e\u0003\u0003\t5{G-\u001a\t\u0003)%DQ\u0001_2A\u00025\n1a[3z\u0011\u0015Q\b\u0001\"\u0001|\u0003\u0015!w\u000eU;u+\tax\u0010F\u0004~\u0003\u0017\ti!!\u0005\u0015\u0007y\f)\u0001E\u0002\u0015\u007fn!aA[=C\u0002\u0005\u0005QcA\f\u0002\u0004\u0011)Qn b\u0001/!1!/\u001fa\u0002\u0003\u000f\u0001B\u0001\u0005;\u0002\nA\u0011Ac \u0005\u0006qf\u0004\r!\f\u0005\u0007\u0003\u001fI\b\u0019A\n\u0002\u000bY\fG.^3\t\u000f\u0005M\u0011\u00101\u0001\u0002\u0016\u0005\u0019A\u000f\u001e7\u0011\t)y\u0017q\u0003\t\u0005\u00033\t\u0019#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003!!WO]1uS>t'bAA\u0011\u0017\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005\u0015\u00121\u0004\u0002\t\tV\u0014\u0018\r^5p]\"9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0012\u0001\u00033p%\u0016lwN^3\u0016\t\u00055\u00121\u0007\u000b\u0005\u0003_\ty\u0004\u0006\u0003\u00022\u0005e\u0002\u0003\u0002\u000b\u00024m!qA[A\u0014\u0005\u0004\t)$F\u0002\u0018\u0003o!a!\\A\u001a\u0005\u00049\u0002b\u0002:\u0002(\u0001\u000f\u00111\b\t\u0005!Q\fi\u0004E\u0002\u0015\u0003gAa\u0001_A\u0014\u0001\u0004i\u0003bBA\"\u0001\u0011\u0005\u0013QI\u0001\fI>\u0014V-\\8wK\u0006cG.\u0006\u0003\u0002H\u00055CCAA%)\u0011\tY%a\u0015\u0011\tQ\tie\u0007\u0003\bU\u0006\u0005#\u0019AA(+\r9\u0012\u0011\u000b\u0003\u0007[\u00065#\u0019A\f\t\u000fI\f\t\u0005q\u0001\u0002VA!\u0001\u0003^A,!\r!\u0012Q\n\u0005\b\u00037\u0002A\u0011IA/\u0003\u0015\u0019Gn\\:f+\u0011\ty&!\u001a\u0015\u0005\u0005\u0005D\u0003BA2\u0003W\u0002B\u0001FA37\u00119!.!\u0017C\u0002\u0005\u001dTcA\f\u0002j\u00111Q.!\u001aC\u0002]AqA]A-\u0001\b\ti\u0007\u0005\u0003\u0011i\u0006=\u0004c\u0001\u000b\u0002f!9\u00111\u000f\u0001\u0005\n\u0005U\u0014\u0001\u0004;p\u000bb\u0004\u0018N]=US6,G\u0003BA<\u0003{\u00022ARA=\u0013\r\tYh\u0012\u0002\b\u0013:\u001cH/\u00198u\u0011!\t\u0019\"!\u001dA\u0002\u0005]qaBAA\u0005!\u0005\u00111Q\u0001\u000e\u0007\u00064g-Z5oK\u000e\u000b7\r[3\u0011\u0007I\u000b)I\u0002\u0004\u0002\u0005!\u0005\u0011qQ\n\u0004\u0003\u000bK\u0001b\u0002(\u0002\u0006\u0012\u0005\u00111\u0012\u000b\u0003\u0003\u0007C\u0001\"a$\u0002\u0006\u0012\u0005\u0011\u0011S\u0001\u0006CB\u0004H._\u000b\u0005\u0003'\u000bI\n\u0006\u0003\u0002\u0016\u0006m\u0005\u0003\u0002*\u0001\u0003/\u00032\u0001FAM\t\u00191\u0012Q\u0012b\u0001/!1A(!$A\u0004yB\u0001\"a$\u0002\u0006\u0012\u0005\u0011qT\u000b\u0005\u0003C\u000bI\u000b\u0006\u0003\u0002$\u00065F\u0003BAS\u0003W\u0003BA\u0015\u0001\u0002(B\u0019A#!+\u0005\rY\tiJ1\u0001\u0018\u0011\u0019a\u0014Q\u0014a\u0002}!9q$!(A\u0002\u0005=\u0006#B\u0011,[\u0005E\u0006\u0003\u0002\t:\u0003OC!\"!.\u0002\u0006F\u0005I\u0011AA\\\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU!\u0011\u0011XAl)\u0011\tY,a4+\u0007\u0015\u000bil\u000b\u0002\u0002@B!\u0011\u0011YAf\u001b\t\t\u0019M\u0003\u0003\u0002F\u0006\u001d\u0017!C;oG\",7m[3e\u0015\r\tImC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAg\u0003\u0007\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011\u001dy\u00121\u0017a\u0001\u0003#\u0004R!I\u0016.\u0003'\u0004B\u0001E\u001d\u0002VB\u0019A#a6\u0005\rY\t\u0019L1\u0001\u0018\u0001")
public class CaffeineCache<V>
implements AbstractCache<V> {
    private final Cache<String, Entry<V>> underlying;
    private final CacheConfig config;
    private final Clock clock;
    private final Logger logger;

    public static <V> Clock $lessinit$greater$default$3(Cache<String, Entry<V>> cache) {
        return CaffeineCache$.MODULE$.$lessinit$greater$default$3(cache);
    }

    public static <V> CaffeineCache<V> apply(Cache<String, Entry<V>> cache, CacheConfig cacheConfig) {
        return CaffeineCache$.MODULE$.apply(cache, cacheConfig);
    }

    public static <V> CaffeineCache<V> apply(CacheConfig cacheConfig) {
        return CaffeineCache$.MODULE$.apply(cacheConfig);
    }

    public final <F> F get(Seq<Object> keyParts, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.get$((AbstractCache)this, keyParts, mode, (Flags)flags);
    }

    public final <F> F put(Seq<Object> keyParts, V value, Option<Duration> ttl, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.put$((AbstractCache)this, keyParts, value, ttl, mode, (Flags)flags);
    }

    public final <F> F remove(Seq<Object> keyParts, Mode<F> mode) {
        return (F)AbstractCache.remove$((AbstractCache)this, keyParts, mode);
    }

    public final <F> F removeAll(Mode<F> mode) {
        return (F)AbstractCache.removeAll$((AbstractCache)this, mode);
    }

    public final <F> F caching(Seq<Object> keyParts, Option<Duration> ttl, Function0<V> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.caching$((AbstractCache)this, keyParts, ttl, f, mode, (Flags)flags);
    }

    public <F> F cachingF(Seq<Object> keyParts, Option<Duration> ttl, Function0<F> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingF$((AbstractCache)this, keyParts, ttl, f, mode, (Flags)flags);
    }

    public <F> F cachingForMemoize(String baseKey, Option<Duration> ttl, Function0<V> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingForMemoize$((AbstractCache)this, (String)baseKey, ttl, f, mode, (Flags)flags);
    }

    public <F> F cachingForMemoizeF(String baseKey, Option<Duration> ttl, Function0<F> f, Mode<F> mode, Flags flags) {
        return (F)AbstractCache.cachingForMemoizeF$((AbstractCache)this, (String)baseKey, ttl, f, mode, (Flags)flags);
    }

    public final <F> Option<Duration> caching$default$2(Seq<Object> keyParts) {
        return AbstractCache.caching$default$2$((AbstractCache)this, keyParts);
    }

    public <F> Option<Duration> cachingF$default$2(Seq<Object> keyParts) {
        return AbstractCache.cachingF$default$2$((AbstractCache)this, keyParts);
    }

    public <F> Option<Duration> cachingForMemoize$default$2(String baseKey) {
        return AbstractCache.cachingForMemoize$default$2$((AbstractCache)this, (String)baseKey);
    }

    public <A> void logCacheHitOrMiss(String key, Option<A> result) {
        LoggingSupport.logCacheHitOrMiss$((LoggingSupport)this, (String)key, result);
    }

    public void logCachePut(String key, Option<Duration> ttl) {
        LoggingSupport.logCachePut$((LoggingSupport)this, (String)key, ttl);
    }

    public <F> Option<Duration> put$default$3(Seq<Object> keyParts) {
        return CacheAlg.put$default$3$((CacheAlg)this, keyParts);
    }

    public CacheConfig config() {
        return this.config;
    }

    public final Logger logger() {
        return this.logger;
    }

    public <F> F doGet(String key, Mode<F> mode) {
        return (F)mode.M().delay((Function0 & java.io.Serializable & Serializable)() -> {
            void var3_4;
            Entry entry;
            Entry baseValue = (Entry)$this.underlying.getIfPresent((Object)key);
            None$ result = baseValue != null ? ((entry = baseValue).isExpired($this.clock) ? None$.MODULE$ : new Some(entry.value())) : None$.MODULE$;
            this.logCacheHitOrMiss(key, (Option)result);
            return var3_4;
        });
    }

    public <F> F doPut(String key, V value, Option<Duration> ttl, Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            Entry entry = new Entry(value, ttl.map((Function1 & java.io.Serializable & Serializable)ttl -> this.toExpiryTime((Duration)ttl)));
            $this.underlying.put((Object)key, (Object)entry);
            this.logCachePut(key, ttl);
        });
    }

    public <F> F doRemove(String key, Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> $this.underlying.invalidate((Object)key));
    }

    public <F> F doRemoveAll(Mode<F> mode) {
        return (F)mode.M().delay((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> $this.underlying.invalidateAll());
    }

    public <F> F close(Mode<F> mode) {
        return (F)mode.M().pure((Object)BoxedUnit.UNIT);
    }

    private Instant toExpiryTime(Duration ttl) {
        return Instant.now(this.clock).plus(ttl.toMillis(), ChronoUnit.MILLIS);
    }

    public CaffeineCache(Cache<String, Entry<V>> underlying, CacheConfig config, Clock clock) {
        this.underlying = underlying;
        this.config = config;
        this.clock = clock;
        LoggingSupport.$init$((LoggingSupport)this);
        AbstractCache.$init$((AbstractCache)this);
        this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
    }
}

