/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.fw.gui.FontChooser;
import net.sourceforge.squirrel_sql.fw.gui.FontInfo;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.gui.OutputLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPlugin;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPreferences;
import net.sourceforge.squirrel_sql.plugins.laf.LAFRegister;

class LAFFontsTab
implements IGlobalPreferencesPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(LAFFontsTab.class);
    private static final ILogger s_log = LoggerController.createLogger(LAFFontsTab.class);
    private LAFPlugin _plugin;
    private LAFRegister _lafRegister;
    private FontSelectionPanel _myPanel;

    public LAFFontsTab(LAFPlugin plugin, LAFRegister lafRegister) {
        if (plugin == null) {
            throw new IllegalArgumentException("Null LAFPlugin passed");
        }
        if (lafRegister == null) {
            throw new IllegalArgumentException("Null LAFRegister passed");
        }
        this._plugin = plugin;
        this._lafRegister = lafRegister;
    }

    public void initialize(IApplication app) {
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        ((FontSelectionPanel)this.getPanelComponent()).loadData();
    }

    public void uninitialize(IApplication app) {
    }

    public synchronized Component getPanelComponent() {
        if (this._myPanel == null) {
            this._myPanel = new FontSelectionPanel(this._plugin, this._lafRegister);
        }
        return this._myPanel;
    }

    public void applyChanges() {
        this._myPanel.applyChanges();
    }

    public String getTitle() {
        return FontSelectionPanel.i18n.TAB_TITLE;
    }

    public String getHint() {
        return FontSelectionPanel.i18n.TAB_HINT;
    }

    private static final class FontSelectionPanel
    extends JPanel {
        private FontButton _menuFontBtn;
        private FontButton _staticFontBtn;
        private FontButton _statusBarFontBtn;
        private FontButton _otherFontBtn;
        private JLabel _menuFontLbl = new OutputLabel(" ");
        private JLabel _staticFontLbl = new OutputLabel(" ");
        private JLabel _statusBarFontLbl = new OutputLabel(" ");
        private JLabel _otherFontLbl = new OutputLabel(" ");
        private JCheckBox _menuFontEnabledChk = new JCheckBox(LAFFontsTab.access$000().getString("laf.menuFontEanbled"));
        private JCheckBox _staticFontEnabledChk = new JCheckBox(LAFFontsTab.access$000().getString("laf.staticFontEanbled"));
        private JCheckBox _statusBarFontEnabledChk = new JCheckBox(LAFFontsTab.access$000().getString("laf.statusFontEanbled"));
        private JCheckBox _otherFontEnabledChk = new JCheckBox(LAFFontsTab.access$000().getString("laf.otherFontEanbled"));
        private LAFPlugin _plugin;
        private LAFRegister _lafRegister;
        private LAFPreferences _prefs;

        FontSelectionPanel(LAFPlugin plugin, LAFRegister lafRegister) {
            this._plugin = plugin;
            this._lafRegister = lafRegister;
            this._prefs = this._plugin.getLAFPreferences();
            this.createUserInterface();
        }

        void loadData() {
            this._menuFontEnabledChk.setSelected(this._prefs.isMenuFontEnabled());
            this._staticFontEnabledChk.setSelected(this._prefs.isStaticFontEnabled());
            this._statusBarFontEnabledChk.setSelected(this._prefs.isStatusBarFontEnabled());
            this._otherFontEnabledChk.setSelected(this._prefs.isOtherFontEnabled());
            FontInfo fi = this._prefs.getMenuFontInfo();
            this._menuFontLbl.setText(fi != null ? fi.toString() : "");
            fi = this._prefs.getStaticFontInfo();
            this._staticFontLbl.setText(fi != null ? fi.toString() : "");
            fi = this._prefs.getStatusBarFontInfo();
            this._statusBarFontLbl.setText(fi != null ? fi.toString() : "");
            fi = this._prefs.getOtherFontInfo();
            this._otherFontLbl.setText(fi != null ? fi.toString() : "");
            this._menuFontBtn.setEnabled(this._prefs.isMenuFontEnabled());
            this._staticFontBtn.setEnabled(this._prefs.isStaticFontEnabled());
            this._statusBarFontBtn.setEnabled(this._prefs.isStatusBarFontEnabled());
            this._otherFontBtn.setEnabled(this._prefs.isOtherFontEnabled());
        }

        void applyChanges() {
            this._prefs.setMenuFontInfo(this._menuFontBtn.getFontInfo());
            this._prefs.setStaticFontInfo(this._staticFontBtn.getFontInfo());
            this._prefs.setStatusBarFontInfo(this._statusBarFontBtn.getFontInfo());
            this._prefs.setOtherFontInfo(this._otherFontBtn.getFontInfo());
            this._prefs.setMenuFontEnabled(this._menuFontEnabledChk.isSelected());
            this._prefs.setStaticFontEnabled(this._staticFontEnabledChk.isSelected());
            this._prefs.setStatusBarFontEnabled(this._statusBarFontEnabledChk.isSelected());
            this._prefs.setOtherFontEnabled(this._otherFontEnabledChk.isSelected());
            try {
                this._lafRegister.updateApplicationFonts();
            }
            catch (Exception ex) {
                s_log.error((Object)"Error updating fonts", (Throwable)ex);
            }
        }

        private void createUserInterface() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.add((Component)this.createFontsPanel(), gbc);
            ++gbc.gridy;
            gbc.gridwidth = 0;
            this.add((Component)new MultipleLineLabel(i18n.LAF_WARNING), gbc);
        }

        private JPanel createFontsPanel() {
            this._menuFontBtn = new FontButton(s_stringMgr.getString("laf.menus"), this._menuFontLbl, this._prefs.getMenuFontInfo());
            this._staticFontBtn = new FontButton(s_stringMgr.getString("laf.staticText"), this._staticFontLbl, this._prefs.getStaticFontInfo());
            this._statusBarFontBtn = new FontButton(s_stringMgr.getString("laf.statusBars"), this._statusBarFontLbl, this._prefs.getStatusBarFontInfo());
            this._otherFontBtn = new FontButton(s_stringMgr.getString("laf.other"), this._otherFontLbl, this._prefs.getOtherFontInfo());
            FontButtonListener lis = new FontButtonListener();
            this._menuFontBtn.addActionListener(lis);
            this._staticFontBtn.addActionListener(lis);
            this._statusBarFontBtn.addActionListener(lis);
            this._otherFontBtn.addActionListener(lis);
            this._menuFontEnabledChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FontSelectionPanel.this._menuFontBtn.setEnabled(FontSelectionPanel.this._menuFontEnabledChk.isSelected());
                }
            });
            this._staticFontEnabledChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FontSelectionPanel.this._staticFontBtn.setEnabled(FontSelectionPanel.this._staticFontEnabledChk.isSelected());
                }
            });
            this._statusBarFontEnabledChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FontSelectionPanel.this._statusBarFontBtn.setEnabled(FontSelectionPanel.this._statusBarFontEnabledChk.isSelected());
                }
            });
            this._otherFontEnabledChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FontSelectionPanel.this._otherFontBtn.setEnabled(FontSelectionPanel.this._otherFontEnabledChk.isSelected());
                }
            });
            JPanel pnl = new JPanel();
            pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("laf.tabFonts")));
            pnl.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.gridx = 0;
            gbc.gridy = 0;
            pnl.add((Component)this._menuFontEnabledChk, gbc);
            ++gbc.gridy;
            pnl.add((Component)this._staticFontEnabledChk, gbc);
            ++gbc.gridy;
            pnl.add((Component)this._statusBarFontEnabledChk, gbc);
            ++gbc.gridy;
            pnl.add((Component)this._otherFontEnabledChk, gbc);
            ++gbc.gridx;
            gbc.gridy = 0;
            pnl.add((Component)this._menuFontBtn, gbc);
            ++gbc.gridy;
            pnl.add((Component)this._staticFontBtn, gbc);
            ++gbc.gridy;
            pnl.add((Component)this._statusBarFontBtn, gbc);
            ++gbc.gridy;
            pnl.add((Component)this._otherFontBtn, gbc);
            ++gbc.gridx;
            gbc.gridy = 0;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            pnl.add((Component)this._menuFontLbl, gbc);
            ++gbc.gridy;
            pnl.add((Component)this._staticFontLbl, gbc);
            ++gbc.gridy;
            pnl.add((Component)this._statusBarFontLbl, gbc);
            ++gbc.gridy;
            pnl.add((Component)this._otherFontLbl, gbc);
            return pnl;
        }

        private static final class FontButtonListener
        implements ActionListener {
            private FontButtonListener() {
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() instanceof FontButton) {
                    FontButton btn = (FontButton)evt.getSource();
                    FontInfo fi = btn.getFontInfo();
                    Font font = null;
                    if (fi != null) {
                        font = fi.createFont();
                    }
                    if ((font = new FontChooser().showDialog(font)) != null) {
                        btn.setSelectedFont(font);
                        btn._lbl.setText(new FontInfo(font).toString());
                    }
                }
            }
        }

        private static final class FontButton
        extends JButton {
            private FontInfo _fi;
            private JLabel _lbl;
            private Font _font;
            private boolean _dirty;

            FontButton(String text, JLabel lbl, FontInfo fi) {
                super(text);
                this._lbl = lbl;
                this._fi = fi;
            }

            FontInfo getFontInfo() {
                return this._fi;
            }

            Font getSelectedFont() {
                return this._font;
            }

            void setSelectedFont(Font font) {
                this._font = font;
                if (this._fi == null) {
                    this._fi = new FontInfo(font);
                } else {
                    this._fi.setFont(font);
                }
                this._dirty = true;
            }

            boolean isDirty() {
                return this._dirty;
            }
        }

        static interface i18n {
            public static final String LAF_WARNING = LAFFontsTab.access$000().getString("laf.warning");
            public static final String TAB_TITLE = LAFFontsTab.access$000().getString("laf.tabTitle");
            public static final String TAB_HINT = LAFFontsTab.access$000().getString("laf.tabHint");
        }
    }
}

