/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations.predefined;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.stress.Operation;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.operations.predefined.PredefinedOperation;
import org.apache.cassandra.stress.report.Timer;
import org.apache.cassandra.stress.settings.Command;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.ThriftClient;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;

public final class ThriftReader
extends PredefinedOperation {
    public ThriftReader(Timer timer, PartitionGenerator generator, SeedManager seedManager, StressSettings settings) {
        super(Command.READ, timer, generator, seedManager, settings);
    }

    @Override
    public void run(final ThriftClient client) throws IOException {
        final PredefinedOperation.ColumnSelection select = this.select();
        final ByteBuffer key = this.getKey();
        final List<ByteBuffer> expect = this.getColumnValues(select);
        this.timeWithRetry(new Operation.RunOp(){

            @Override
            public boolean run() throws Exception {
                List<ColumnOrSuperColumn> row = client.get_slice(key, new ColumnParent(ThriftReader.this.type.table), select.predicate(), ThriftReader.this.settings.command.consistencyLevel);
                if (expect == null) {
                    return !row.isEmpty();
                }
                if (row == null) {
                    return false;
                }
                if (row.size() != expect.size()) {
                    return false;
                }
                for (int i = 0; i < row.size(); ++i) {
                    if (row.get(i).getColumn().bufferForValue().equals(expect.get(i))) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int partitionCount() {
                return 1;
            }

            @Override
            public int rowCount() {
                return 1;
            }
        });
    }
}

