#!/usr/bin/python
#
# Test the outcome of a single ATF test, by running the full test
# suite and extracting the result from a single test.
#
# Derived from bisect/test-failure.py
#

from __future__ import print_function
import re

from bracket import *

def make_fastcheck_func(tp, tc):
    def f(ts):
        try:
            return atf_test_results(ts)[(tp, tc)]
        except:
            return None
    return f

def make_test_func(tp, tc):
    def f(ts):
        return atf_test_results(ts)[(tp, tc)]
    return f

# Parse a test name of the form tp:tc or tp/tc, return a tuple

def parse_testname(s):
    a = s.split(':')
    if len(a) == 2:
        return tuple(a)
    return tuple(s.rsplit('/', 1))
    
def op(testname):
    tp, tc = parse_testname(testname)
    return TestOp(make_test_func(tp, tc), [test_completed_op],
                  name =  'atf_' + re.sub('/', '_', tp) + '_' + tc,
                  fastcheck = make_fastcheck_func(tp, tc))
