/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.math;

import edu.umd.marbl.mhap.math.MathRuntimeException;

public final class BasicMath {
    public static final double PI = Math.PI;
    public static final double TWOPI = Math.PI * 2;

    public static double abs(double a) {
        return Math.abs(a);
    }

    public static double[] abs(double[] a) {
        double[] val = new double[a.length];
        for (int iter = 0; iter < a.length; ++iter) {
            val[iter] = BasicMath.abs(a[iter]);
        }
        return val;
    }

    public static double acos(double x) {
        return Math.acos(x);
    }

    public static final double[] add(double[] a, double b) {
        double[] val = new double[a.length];
        for (int iter = 0; iter < a.length; ++iter) {
            val[iter] = a[iter] + b;
        }
        return val;
    }

    public static final double[] add(double[] a, double[] b) {
        double[] val = new double[a.length];
        for (int iter = 0; iter < a.length; ++iter) {
            val[iter] = a[iter] + b[iter];
        }
        return val;
    }

    public static final double angle(double[] a, double[] b) {
        double angle = BasicMath.acos(BasicMath.normalizedDotProduct(a, b));
        return angle;
    }

    public static double angleAbsolute(double[] a, double[] b) {
        return Math.min(Math.abs(BasicMath.angle(a, b)), Math.abs(BasicMath.angle(a, BasicMath.mult(b, -1.0))));
    }

    public static final double asin(double x) {
        return Math.asin(x);
    }

    public static final double[][] catColumns(double[][] A, double[][] B) {
        if (A.length != B.length) {
            throw new MathRuntimeException("Number of rows must be equal in A and B.");
        }
        double[][] C = new double[A.length][A[0].length + B[0].length];
        for (int row = 0; row < C.length; ++row) {
            int column;
            for (column = 0; column < A[row].length; ++column) {
                C[row][column] = A[row][column];
            }
            for (column = 0; column < B[row].length; ++column) {
                C[row][A[row].length + column] = B[row][column];
            }
        }
        return C;
    }

    public static final int closestPowerOfTwo(int a) {
        int power = a == 0 ? 0 : 32 - Integer.numberOfLeadingZeros(a - 1);
        return 1 << power;
    }

    public static final double cos(double angle) {
        return Math.cos(angle);
    }

    public static final double[][] createIdentityMatrix(int m, int n) {
        double[][] A = new double[m][n];
        for (int iterRow = 0; iterRow < A.length; ++iterRow) {
            for (int iterColumn = 0; iterColumn < A[iterRow].length; ++iterColumn) {
                A[iterRow][iterColumn] = 0.0;
                if (iterRow != iterColumn) continue;
                A[iterRow][iterColumn] = 1.0;
            }
        }
        return A;
    }

    public static final double cube(double a) {
        return a * a * a;
    }

    public static final double det(double[][] A) {
        if (A == null || A.length != 3 || A[0].length != 3) {
            throw new MathRuntimeException("Currently can only compute determinant of 3x3 matrix.");
        }
        double det = A[0][0] * (A[1][1] * A[2][2] - A[2][1] * A[1][2]) - A[1][0] * (A[0][1] * A[2][2] - A[2][1] * A[0][2]) + A[2][0] * (A[0][1] * A[1][2] - A[1][1] * A[0][2]);
        return det;
    }

    public static final double[] divide(double[] a, double b) {
        double[] val = new double[a.length];
        for (int iter = 0; iter < a.length; ++iter) {
            val[iter] = a[iter] / b;
        }
        return val;
    }

    public static final double[] divide(double[] a, double[] b) {
        double[] val = new double[a.length];
        for (int iter = 0; iter < a.length; ++iter) {
            val[iter] = a[iter] / b[iter];
        }
        return val;
    }

    public static final double dotProduct(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new MathRuntimeException("Vector lengths must be equal.");
        }
        double val = 0.0;
        for (int iter = 0; iter < a.length; ++iter) {
            val += a[iter] * b[iter];
        }
        return val;
    }

    public static final double euclideanDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return BasicMath.sqrt(BasicMath.euclideanDistanceSquared(x1, y1, z1, x2, y2, z2));
    }

    public static final double euclideanDistanceSquared(double x1, double x2) {
        double xdif = x2 - x1;
        return xdif * xdif;
    }

    public static final double euclideanDistanceSquared(double x1, double y1, double x2, double y2) {
        double xdif = x2 - x1;
        double ydif = y2 - y1;
        return xdif * xdif + ydif * ydif;
    }

    public static final double euclideanDistanceSquared(double x1, double y1, double z1, double x2, double y2, double z2) {
        double xdif = x2 - x1;
        double ydif = y2 - y1;
        double zdif = z2 - z1;
        return xdif * xdif + ydif * ydif + zdif * zdif;
    }

    public static boolean hasNaN(double[] x) {
        for (double val : x) {
            if (!Double.isNaN(val)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIdentityMatrix(double[][] A) {
        if (A == null) {
            return false;
        }
        if (A.length != A[0].length) {
            return false;
        }
        for (int iterRow = 0; iterRow < A.length; ++iterRow) {
            for (int iterColumn = 0; iterColumn < A[iterRow].length; ++iterColumn) {
                if (!(iterRow == iterColumn ? A[iterRow][iterColumn] != 1.0 : A[iterRow][iterColumn] != 0.0)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNonNegative(double[] x) {
        for (double val : x) {
            if (!(val < 0.0)) continue;
            return false;
        }
        return true;
    }

    public static final double laplanceProbabilty(double x, double b) {
        return 1.0 / (2.0 * b) * Math.exp(-Math.abs(x) / b);
    }

    public static double[] matrixToArray(double[][] A) {
        double[] val = new double[A.length * A[0].length];
        for (int iterRow = 0; iterRow < A.length; ++iterRow) {
            for (int iterColumn = 0; iterColumn < A[iterRow].length; ++iterColumn) {
                val[iterRow * A[0].length] = A[iterRow][iterColumn];
            }
        }
        return val;
    }

    public static final double max(double[] a) {
        double val = a[0];
        for (double elem : a) {
            val = Math.max(val, elem);
        }
        return val;
    }

    public static final double min(double[] a) {
        double val = a[0];
        for (double elem : a) {
            val = Math.min(val, elem);
        }
        return val;
    }

    public static final double[] mult(double[] a, double b) {
        double[] val = new double[a.length];
        for (int iter = 0; iter < a.length; ++iter) {
            val[iter] = a[iter] * b;
        }
        return val;
    }

    public static final double[] mult(double[] a, double[] b) {
        if (a == null || b == null) {
            throw new MathRuntimeException("Arrays cannot be null.");
        }
        if (a.length != b.length) {
            throw new MathRuntimeException("Arrays must be of equal length.");
        }
        double[] val = new double[a.length];
        for (int iter = 0; iter < a.length; ++iter) {
            val[iter] = a[iter] * b[iter];
        }
        return val;
    }

    public static final double[][] mult(double[][] A, double b) {
        double[][] X = new double[A.length][A[0].length];
        for (int iterRow = 0; iterRow < A.length; ++iterRow) {
            for (int iterColumn = 0; iterColumn < A[iterRow].length; ++iterColumn) {
                X[iterRow][iterColumn] = A[iterRow][iterColumn] * b;
            }
        }
        return X;
    }

    public static final double[] mult(double[][] A, double[] b) {
        if (A == null || b == null) {
            throw new NullPointerException("Values cannot be null.");
        }
        if (A[0].length != b.length) {
            throw new MathRuntimeException("Matrix dimension [" + A.length + ", " + A[0].length + "] does not match vector length " + b.length + ".");
        }
        double[] x = new double[A.length];
        for (int iterRow = 0; iterRow < A.length; ++iterRow) {
            x[iterRow] = 0.0;
            for (int iterColumn = 0; iterColumn < A[iterRow].length; ++iterColumn) {
                int n = iterRow;
                x[n] = x[n] + A[iterRow][iterColumn] * b[iterColumn];
            }
        }
        return x;
    }

    public static final double[][] mult(double[][] A, double[][] B) {
        if (A == null || B == null) {
            throw new NullPointerException("Matrices cannot be null.");
        }
        if (A[0].length != B.length) {
            throw new MathRuntimeException("Matrices' dimensions do not match.");
        }
        double[][] C = new double[A.length][B[0].length];
        for (int row = 0; row < A.length; ++row) {
            for (int col = 0; col < B[0].length; ++col) {
                C[row][col] = 0.0;
                for (int iter = 0; iter < B.length; ++iter) {
                    double[] dArray = C[row];
                    int n = col;
                    dArray[n] = dArray[n] + A[row][iter] * B[iter][col];
                }
            }
        }
        return C;
    }

    public static final double[] multTranspose(double[][] A, double[] x) {
        double[] value = new double[A[0].length];
        for (int iterRow = 0; iterRow < A[0].length; ++iterRow) {
            value[iterRow] = 0.0;
            for (int iterColumn = 0; iterColumn < A.length; ++iterColumn) {
                int n = iterRow;
                value[n] = value[n] + A[iterColumn][iterRow] * x[iterColumn];
            }
        }
        return value;
    }

    public static final double[][] multTranspose(double[][] A, double[][] B) {
        if (A == null || B == null) {
            throw new NullPointerException("Matrices cannot be null.");
        }
        if (A.length != B.length) {
            throw new MathRuntimeException("Matrices' dimensions do not match.");
        }
        double[][] C = new double[A[0].length][B[0].length];
        for (int colA = 0; colA < A[0].length; ++colA) {
            for (int colB = 0; colB < B[0].length; ++colB) {
                C[colA][colB] = 0.0;
                for (int iter = 0; iter < A.length; ++iter) {
                    double[] dArray = C[colA];
                    int n = colB;
                    dArray[n] = dArray[n] + A[iter][colA] * B[iter][colB];
                }
            }
        }
        return C;
    }

    public static final int nearestMultiple(int n, int base) {
        int x = n / base;
        if (x * base == n) {
            return n;
        }
        return x * base + base;
    }

    public static final int[] nonZeroIndicies(double[] x, double absTolerance) {
        int size = 0;
        for (int iter = 0; iter < x.length; ++iter) {
            if (!(Math.abs(x[iter]) > absTolerance)) continue;
            ++size;
        }
        int[] list = new int[size];
        size = 0;
        for (int iter = 0; iter < x.length; ++iter) {
            if (!(Math.abs(x[iter]) > absTolerance)) continue;
            list[size] = iter;
            ++size;
        }
        return list;
    }

    public static final double[] nonZeroValues(double[] x, double absTolerance) {
        int[] list = BasicMath.nonZeroIndicies(x, absTolerance);
        double[] xnew = new double[list.length];
        int count = 0;
        for (int index : list) {
            xnew[count] = x[index];
            ++count;
        }
        return xnew;
    }

    public static double norm(double[] a) {
        return BasicMath.sqrt(BasicMath.normSquared(a));
    }

    public static final double normalizedDotProduct(double[] a, double[] b) {
        return BasicMath.dotProduct(a, b) / (BasicMath.norm(a) * BasicMath.norm(b));
    }

    public static final double normSquared(double[] a) {
        double r = 0.0;
        for (double elem : a) {
            r += elem * elem;
        }
        return r;
    }

    public static final double roundToNearest(double x, int n) {
        double shift = Math.pow(10.0, n);
        return (double)Math.round(x * shift) / shift;
    }

    public static final double sin(double angle) {
        return Math.sin(angle);
    }

    public static final double sinc(double x) {
        return x == 0.0 || x < 1.0E-8 && x > -1.0E-8 ? 1.0 : BasicMath.sin(x) / x;
    }

    public static final double sqrt(double a) {
        return Math.sqrt(a);
    }

    public static final double square(double a) {
        return a * a;
    }

    public static final double[] square(double[] a) {
        double[] val = new double[a.length];
        for (int iter = 0; iter < a.length; ++iter) {
            val[iter] = a[iter] * a[iter];
        }
        return val;
    }

    public static final double[] subtract(double[] a, double b) {
        double[] val = new double[a.length];
        for (int iter = 0; iter < a.length; ++iter) {
            val[iter] = a[iter] - b;
        }
        return val;
    }

    public static final double[] subtract(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new MathRuntimeException("Vectors must be of same length.");
        }
        double[] val = new double[a.length];
        for (int iter = 0; iter < a.length; ++iter) {
            val[iter] = a[iter] - b[iter];
        }
        return val;
    }

    public static final double sum(double[] a) {
        if (a == null) {
            return 0.0;
        }
        double sum = 0.0;
        for (double val : a) {
            sum += val;
        }
        return sum;
    }

    public static final double[][] transpose(double[][] A) {
        if (A == null) {
            return null;
        }
        double[][] At = new double[A[0].length][A.length];
        for (int row = 0; row < A.length; ++row) {
            for (int col = 0; col < A[row].length; ++col) {
                At[col][row] = A[row][col];
            }
        }
        return At;
    }
}

