/*
 * Decompiled with CFR 0.152.
 */
package jaligner.util;

import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Commons {
    public static final String TAB = "\t";
    private static final Logger logger = Logger.getLogger(Commons.class.getName());
    private static final String BUILD_TIMESTAMP = "Created-At";
    private static final String currentRelease = Commons.getManifestBuildTimestamp();
    private static final String DEFAULT_USER_DIRECTORY = ".";
    private static final String DEFAULT_FILE_SEPARATOR = "/";
    private static final String DEFAULT_LINE_SEPARATOR = "\r\n";
    private static String userDirectory = ".";
    private static String fileSeparator;
    private static String lineSeparator;
    private static boolean jnlp;

    public static String getFileSeparator() {
        return fileSeparator;
    }

    public static String getLineSeparator() {
        return lineSeparator;
    }

    public static String getUserDirectory() {
        return userDirectory;
    }

    public static void setJnlp(boolean jnlp) {
        Commons.jnlp = jnlp;
    }

    public static boolean isJnlp() {
        return jnlp;
    }

    private static String getManifestBuildTimestamp() {
        JarURLConnection connection = null;
        JarFile jarFile = null;
        URL url = Commons.class.getClassLoader().getResource("jaligner");
        try {
            connection = (JarURLConnection)url.openConnection();
            jarFile = connection.getJarFile();
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            Attributes.Name name = new Attributes.Name(BUILD_TIMESTAMP);
            return attributes.getValue(name);
        }
        catch (Exception e) {
            String message = "Failed getting the current release info: " + e.getMessage();
            logger.log(Level.WARNING, message);
            return null;
        }
    }

    public static String getCurrentRelease() {
        return currentRelease;
    }

    public static String getJAlignerInfo() {
        return "JAligner - Build: " + Commons.getCurrentRelease() + " - By: Ahmed Moustafa (ahmed@users.sf.net)";
    }

    static {
        try {
            userDirectory = System.getProperty("user.dir");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed getting user current directory: " + e.getMessage(), e);
        }
        fileSeparator = DEFAULT_FILE_SEPARATOR;
        try {
            fileSeparator = System.getProperty("file.separator");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed getting system file separator: " + e.getMessage(), e);
        }
        lineSeparator = DEFAULT_LINE_SEPARATOR;
        try {
            lineSeparator = System.getProperty("line.separator");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed getting system line separator: " + e.getMessage(), e);
        }
        jnlp = false;
        try {
            jnlp = "true".equalsIgnoreCase(System.getProperty("jnlp.enabled"));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed getting jnlp enabled property: " + e.getMessage(), e);
        }
        Commons.setJnlp(jnlp);
    }
}

