/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;

public class SecurityFiles {
    private SecurityFiles() {
    }

    public static <K, V> void writeFileAtomically(Path path, Map<K, V> map, Function<Map.Entry<K, V>, String> transform) {
        Path tempFile = null;
        try {
            boolean supportsPosixAttributes;
            tempFile = Files.createTempFile(path.getParent(), path.getFileName().toString(), "tmp", new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(tempFile, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
                for (Map.Entry<K, V> entry : map.entrySet()) {
                    StringBuilder sb = new StringBuilder();
                    String line = sb.append(transform.apply(entry)).append(System.lineSeparator()).toString();
                    writer.write(line);
                }
            }
            if (Files.exists(path, new LinkOption[0]) && (supportsPosixAttributes = Environment.getFileStore((Path)path).supportsFileAttributeView(PosixFileAttributeView.class))) {
                SecurityFiles.setPosixAttributesOnTempFile(path, tempFile);
            }
            try {
                Files.move(tempFile, path, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException e) {
                Files.move(tempFile, path, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(String.format(Locale.ROOT, "could not write file [%s]", path.toAbsolutePath()), e);
            }
            catch (Throwable throwable) {
                IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{tempFile});
                throw throwable;
            }
        }
        IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{tempFile});
    }

    static void setPosixAttributesOnTempFile(Path path, Path tempFile) throws IOException {
        PosixFileAttributes attributes = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]).readAttributes();
        PosixFileAttributeView tempFileView = Files.getFileAttributeView(tempFile, PosixFileAttributeView.class, new LinkOption[0]);
        tempFileView.setPermissions(attributes.permissions());
        try {
            tempFileView.setOwner(attributes.owner());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            tempFileView.setGroup(attributes.group());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

