/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen;

import java.io.Closeable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportConnectionListener;
import org.elasticsearch.transport.TransportService;

public abstract class FaultDetection
implements Closeable {
    private static final Logger logger = LogManager.getLogger(FaultDetection.class);
    public static final Setting<Boolean> CONNECT_ON_NETWORK_DISCONNECT_SETTING = Setting.boolSetting("discovery.zen.fd.connect_on_network_disconnect", false, Setting.Property.NodeScope);
    public static final Setting<TimeValue> PING_INTERVAL_SETTING = Setting.positiveTimeSetting("discovery.zen.fd.ping_interval", TimeValue.timeValueSeconds((long)1L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> PING_TIMEOUT_SETTING = Setting.timeSetting("discovery.zen.fd.ping_timeout", TimeValue.timeValueSeconds((long)30L), Setting.Property.NodeScope);
    public static final Setting<Integer> PING_RETRIES_SETTING = Setting.intSetting("discovery.zen.fd.ping_retries", 3, Setting.Property.NodeScope);
    public static final Setting<Boolean> REGISTER_CONNECTION_LISTENER_SETTING = Setting.boolSetting("discovery.zen.fd.register_connection_listener", true, Setting.Property.NodeScope);
    protected final ThreadPool threadPool;
    protected final ClusterName clusterName;
    protected final TransportService transportService;
    protected final boolean registerConnectionListener;
    protected final FDConnectionListener connectionListener;
    protected final boolean connectOnNetworkDisconnect;
    protected final TimeValue pingInterval;
    protected final TimeValue pingRetryTimeout;
    protected final int pingRetryCount;

    public FaultDetection(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterName clusterName) {
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.clusterName = clusterName;
        this.connectOnNetworkDisconnect = CONNECT_ON_NETWORK_DISCONNECT_SETTING.get(settings);
        this.pingInterval = PING_INTERVAL_SETTING.get(settings);
        this.pingRetryTimeout = PING_TIMEOUT_SETTING.get(settings);
        this.pingRetryCount = PING_RETRIES_SETTING.get(settings);
        this.registerConnectionListener = REGISTER_CONNECTION_LISTENER_SETTING.get(settings);
        this.connectionListener = new FDConnectionListener();
        if (this.registerConnectionListener) {
            transportService.addConnectionListener(this.connectionListener);
        }
    }

    @Override
    public void close() {
        this.transportService.removeConnectionListener(this.connectionListener);
    }

    abstract void handleTransportDisconnect(DiscoveryNode var1);

    private class FDConnectionListener
    implements TransportConnectionListener {
        private FDConnectionListener() {
        }

        @Override
        public void onNodeDisconnected(final DiscoveryNode node) {
            AbstractRunnable runnable = new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    logger.warn("failed to handle transport disconnect for node: {}", (Object)node);
                }

                @Override
                protected void doRun() {
                    FaultDetection.this.handleTransportDisconnect(node);
                }
            };
            FaultDetection.this.threadPool.generic().execute(runnable);
        }
    }
}

