/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LoginMessage
extends DOMMessage {
    private final Player player;
    private final String userName;
    private final String version;
    private final boolean admin;
    private final boolean startGame;
    private final boolean singlePlayer;
    private final boolean currentPlayer;
    private final String activeUnitId;
    private final Game game;

    public LoginMessage(Player player, String userName, String version, boolean startGame, boolean singlePlayer, boolean currentPlayer, Unit activeUnit, Game game) {
        super(LoginMessage.getXMLElementTagName());
        this.player = player;
        this.userName = userName;
        this.version = version;
        this.admin = player.isAdmin();
        this.startGame = startGame;
        this.singlePlayer = singlePlayer;
        this.currentPlayer = currentPlayer;
        this.activeUnitId = activeUnit == null ? null : activeUnit.getId();
        this.game = game;
    }

    public LoginMessage(Game game, Element element) {
        super(LoginMessage.getXMLElementTagName());
        this.player = null;
        this.userName = element.getAttribute("userName");
        this.version = element.getAttribute("version");
        String str = element.getAttribute("admin");
        this.admin = Boolean.parseBoolean(str);
        str = element.getAttribute("startGame");
        this.startGame = Boolean.parseBoolean(str);
        str = element.getAttribute("singlePlayer");
        this.singlePlayer = Boolean.parseBoolean(str);
        str = element.getAttribute("currentPlayer");
        this.currentPlayer = Boolean.parseBoolean(str);
        this.activeUnitId = element.getAttribute("activeUnit");
        NodeList children = element.getChildNodes();
        this.game = children.getLength() != 1 ? null : new Game((Element)children.item(0), this.userName);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public boolean getStartGame() {
        return this.startGame;
    }

    public boolean isSinglePlayer() {
        return this.singlePlayer;
    }

    public boolean isCurrentPlayer() {
        return this.currentPlayer;
    }

    public Unit getActiveUnit() {
        return this.activeUnitId == null ? null : this.game.getFreeColGameObject(this.activeUnitId, Unit.class);
    }

    public Game getGame() {
        return this.game;
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        return null;
    }

    @Override
    public Element toXMLElement() {
        Element result = LoginMessage.createMessage(LoginMessage.getXMLElementTagName(), "userName", this.userName, "version", this.version, "admin", Boolean.toString(this.admin), "startGame", Boolean.toString(this.startGame), "singlePlayer", Boolean.toString(this.singlePlayer), "currentPlayer", Boolean.toString(this.currentPlayer), "activeUnit", this.activeUnitId);
        result.appendChild(this.game.toXMLElement(result.getOwnerDocument(), this.player));
        return result;
    }

    public static String getXMLElementTagName() {
        return "login";
    }
}

