module Paths_hsc2hs (
	version,
	getBinDir, getLibDir, getDataDir, getLibexecDir,
	getDataFileName
	) where

import Data.Version

version = Version {versionBranch = [0,67], versionTags = []}

bindir     = "/usr/pkg/bin"
libdir     = "/usr/pkg/lib/hugs/packages/hsc2hs"
datadir    = "/usr/pkg/share/hsc2hs-0.67"
libexecdir = "/usr/pkg/libexec"

getBinDir, getLibDir, getDataDir, getLibexecDir :: IO FilePath
getBinDir = return bindir
getLibDir = return libdir
getDataDir = return datadir
getLibexecDir = return libexecdir

getDataFileName :: FilePath -> IO FilePath
getDataFileName name = return (datadir ++ "/" ++ name)
