/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.ccfb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.rtp.rtcp.RtcpHeaderBuilder;
import org.jitsi.rtp.rtcp.rtcpfb.RtcpFbPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.ccfb.PacketInfo;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.ccfb.ReceivedPacketInfo;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.ccfb.RtcpFbCcfbPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.ccfb.RtcpFbCcfbPacketKt;
import org.jitsi.rtp.util.BufferPool;
import org.jitsi.rtp.util.RtpUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0018J\u0006\u0010\u001e\u001a\u00020\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/ccfb/RtcpFbCcfbPacketBuilder;", "", "rtcpHeader", "Lorg/jitsi/rtp/rtcp/RtcpHeaderBuilder;", "mediaSourceSsrc", "", "packets", "", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/ccfb/PacketInfo;", "reportTimestampCompactNtp", "<init>", "(Lorg/jitsi/rtp/rtcp/RtcpHeaderBuilder;JLjava/util/List;J)V", "getRtcpHeader", "()Lorg/jitsi/rtp/rtcp/RtcpHeaderBuilder;", "getMediaSourceSsrc", "()J", "setMediaSourceSsrc", "(J)V", "getPackets", "()Ljava/util/List;", "getReportTimestampCompactNtp", "groupedPackets", "", "blockLength", "", "writeTo", "", "buf", "", "offset", "build", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/ccfb/RtcpFbCcfbPacket;", "rtp"})
@SourceDebugExtension(value={"SMAP\nRtcpFbCcfbPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtcpFbCcfbPacket.kt\norg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/ccfb/RtcpFbCcfbPacketBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,333:1\n1485#2:334\n1510#2,3:335\n1513#2,3:345\n1872#2,3:351\n381#3,7:338\n216#4,2:348\n216#4:350\n217#4:354\n*S KotlinDebug\n*F\n+ 1 RtcpFbCcfbPacket.kt\norg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/ccfb/RtcpFbCcfbPacketBuilder\n*L\n104#1:334\n104#1:335,3\n104#1:345,3\n149#1:351,3\n104#1:338,7\n109#1:348,2\n133#1:350\n133#1:354\n*E\n"})
public final class RtcpFbCcfbPacketBuilder {
    @NotNull
    private final RtcpHeaderBuilder rtcpHeader;
    private long mediaSourceSsrc;
    @NotNull
    private final List<PacketInfo> packets;
    private final long reportTimestampCompactNtp;
    @NotNull
    private final Map<Long, List<PacketInfo>> groupedPackets;

    /*
     * WARNING - void declaration
     */
    public RtcpFbCcfbPacketBuilder(@NotNull RtcpHeaderBuilder rtcpHeader, long mediaSourceSsrc, @NotNull List<? extends PacketInfo> packets, long reportTimestampCompactNtp) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Intrinsics.checkNotNullParameter(rtcpHeader, "rtcpHeader");
        Intrinsics.checkNotNullParameter(packets, "packets");
        this.rtcpHeader = rtcpHeader;
        this.mediaSourceSsrc = mediaSourceSsrc;
        this.packets = packets;
        this.reportTimestampCompactNtp = reportTimestampCompactNtp;
        Iterable iterable = this.packets;
        RtcpFbCcfbPacketBuilder rtcpFbCcfbPacketBuilder = this;
        boolean $i$f$groupBy = false;
        void var9_8 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            PacketInfo it = (PacketInfo)element$iv$iv;
            boolean bl = false;
            Long key$iv$iv = it.getSsrc();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        rtcpFbCcfbPacketBuilder.groupedPackets = destination$iv$iv;
    }

    public /* synthetic */ RtcpFbCcfbPacketBuilder(RtcpHeaderBuilder rtcpHeaderBuilder, long l, List list, long l2, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            rtcpHeaderBuilder = new RtcpHeaderBuilder(0, false, 0, 0, 0, 0L, 63, null);
        }
        if ((n & 2) != 0) {
            l = -1L;
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(rtcpHeaderBuilder, l, list, l2);
    }

    @NotNull
    public final RtcpHeaderBuilder getRtcpHeader() {
        return this.rtcpHeader;
    }

    public final long getMediaSourceSsrc() {
        return this.mediaSourceSsrc;
    }

    public final void setMediaSourceSsrc(long l) {
        this.mediaSourceSsrc = l;
    }

    @NotNull
    public final List<PacketInfo> getPackets() {
        return this.packets;
    }

    public final long getReportTimestampCompactNtp() {
        return this.reportTimestampCompactNtp;
    }

    private final int blockLength() {
        int totalSize = 0;
        totalSize = 16;
        Map<Long, List<PacketInfo>> $this$forEach$iv = this.groupedPackets;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Long, List<PacketInfo>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Long, List<PacketInfo>> element$iv;
            Map.Entry<Long, List<PacketInfo>> entry = element$iv = iterator2.next();
            boolean bl = false;
            long ssrc = ((Number)entry.getKey()).longValue();
            List<PacketInfo> packets = entry.getValue();
            int blockSize = packets.size() * 2;
            totalSize += 8 + blockSize + RtpUtils.Companion.getNumPaddingBytes(blockSize);
        }
        return totalSize;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeTo(@NotNull byte[] buf, int offset) {
        boolean bl;
        RtcpHeaderBuilder rtcpHeaderBuilder;
        boolean bl2;
        Intrinsics.checkNotNullParameter(buf, "buf");
        int blockLength = this.blockLength();
        boolean bl3 = bl2 = blockLength % 4 == 0;
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int packetSize = blockLength;
        if (!(buf.length - offset >= packetSize)) {
            boolean $i$a$-require-RtcpFbCcfbPacketBuilder$writeTo$22 = false;
            String $i$a$-require-RtcpFbCcfbPacketBuilder$writeTo$22 = "Buffer of size " + buf.length + " with offset " + offset + " too small for CCFB packet of size " + packetSize;
            throw new IllegalArgumentException($i$a$-require-RtcpFbCcfbPacketBuilder$writeTo$22.toString());
        }
        RtcpHeaderBuilder $this$writeTo_u24lambda_u243 = rtcpHeaderBuilder = this.rtcpHeader;
        boolean bl4 = false;
        $this$writeTo_u24lambda_u243.setPacketType(205);
        $this$writeTo_u24lambda_u243.setReportCount(11);
        $this$writeTo_u24lambda_u243.setLength(RtpUtils.Companion.calculateRtcpLengthFieldValue(blockLength));
        rtcpHeaderBuilder.writeTo(buf, offset);
        RtcpFbPacket.Companion.setMediaSourceSsrc(buf, offset, this.mediaSourceSsrc);
        int position = 0;
        position = offset + 12;
        Map<Long, List<PacketInfo>> $this$forEach$iv = this.groupedPackets;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Long, List<PacketInfo>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Long, List<PacketInfo>> element$iv;
            Map.Entry<Long, List<PacketInfo>> entry = element$iv = iterator2.next();
            boolean bl5 = false;
            long ssrc = ((Number)entry.getKey()).longValue();
            List<PacketInfo> packets = entry.getValue();
            if (!(packets.size() <= 16384)) {
                boolean $i$a$-check-RtcpFbCcfbPacketBuilder$writeTo$3$22 = false;
                String $i$a$-check-RtcpFbCcfbPacketBuilder$writeTo$3$22 = "Unexpected number of reports: " + packets.size();
                throw new IllegalStateException($i$a$-check-RtcpFbCcfbPacketBuilder$writeTo$3$22.toString());
            }
            ByteArrayExtensionsKt.putInt(buf, position, (int)ssrc);
            int beginSeq = CollectionsKt.first(packets).getSequenceNumber();
            int numReports = packets.size();
            ByteArrayExtensionsKt.putShort(buf, position += 4, (short)beginSeq);
            ByteArrayExtensionsKt.putShort(buf, position += 2, (short)numReports);
            position += 2;
            Iterable $this$forEachIndexed$iv = packets;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void packet;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                PacketInfo packetInfo = (PacketInfo)item$iv;
                int i = n;
                boolean bl6 = false;
                int expectedSeq = RtpUtils.Companion.applySequenceNumberDelta(beginSeq, i);
                if (!(packet.getSequenceNumber() == expectedSeq)) {
                    boolean bl7 = false;
                    String string = "Sequence number for report " + i + " of " + ssrc + " is wrong (expected " + expectedSeq + " == " + beginSeq + " + " + i + ", got " + packet.getSequenceNumber() + ")";
                    throw new IllegalStateException(string.toString());
                }
                int packetInfo2 = packet instanceof ReceivedPacketInfo ? 0x8000 | RtcpFbCcfbPacketKt.access$to2BitEcn(((ReceivedPacketInfo)packet).getEcn()) | RtcpFbCcfbPacketKt.access$to13BitAto(((ReceivedPacketInfo)packet).getArrivalTimeOffset()) : 0;
                ByteArrayExtensionsKt.putShort(buf, position, (short)packetInfo2);
                position += 2;
            }
            int n = RtpUtils.Companion.getNumPaddingBytes(2 * numReports);
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl8 = false;
                int n3 = position;
                position = n3 + 1;
                buf[n3] = 0;
            }
        }
        ByteArrayExtensionsKt.putInt(buf, position, (int)this.reportTimestampCompactNtp);
        boolean bl9 = bl = (position += 4) - offset == packetSize;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public final RtcpFbCcfbPacket build() {
        int blockLength = this.blockLength();
        int packetSize = blockLength + RtpUtils.Companion.getNumPaddingBytes(blockLength);
        byte[] buf = BufferPool.Companion.getGetArray().invoke(packetSize);
        this.writeTo(buf, 0);
        return new RtcpFbCcfbPacket(buf, 0, packetSize);
    }
}

