/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;

public class DeleteTopicsResponse
extends AbstractResponse {
    private static final String TOPIC_ERROR_CODES_KEY_NAME = "topic_error_codes";
    private static final Schema TOPIC_ERROR_CODE = new Schema(CommonFields.TOPIC_NAME, CommonFields.ERROR_CODE);
    private static final Schema DELETE_TOPICS_RESPONSE_V0 = new Schema(new Field("topic_error_codes", new ArrayOf(TOPIC_ERROR_CODE), "An array of per topic error codes."));
    private static final Schema DELETE_TOPICS_RESPONSE_V1 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field("topic_error_codes", new ArrayOf(TOPIC_ERROR_CODE), "An array of per topic error codes."));
    private final Map<String, Errors> errors;
    private final int throttleTimeMs;

    public static Schema[] schemaVersions() {
        return new Schema[]{DELETE_TOPICS_RESPONSE_V0, DELETE_TOPICS_RESPONSE_V1};
    }

    public DeleteTopicsResponse(Map<String, Errors> errors) {
        this(0, errors);
    }

    public DeleteTopicsResponse(int throttleTimeMs, Map<String, Errors> errors) {
        this.throttleTimeMs = throttleTimeMs;
        this.errors = errors;
    }

    public DeleteTopicsResponse(Struct struct) {
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
        Object[] topicErrorCodesStructs = struct.getArray(TOPIC_ERROR_CODES_KEY_NAME);
        HashMap<String, Errors> errors = new HashMap<String, Errors>();
        for (Object topicErrorCodeStructObj : topicErrorCodesStructs) {
            Struct topicErrorCodeStruct = (Struct)topicErrorCodeStructObj;
            String topic = topicErrorCodeStruct.get(CommonFields.TOPIC_NAME);
            Errors error = Errors.forCode(topicErrorCodeStruct.get(CommonFields.ERROR_CODE));
            errors.put(topic, error);
        }
        this.errors = errors;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.DELETE_TOPICS.responseSchema(version));
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        ArrayList<Struct> topicErrorCodeStructs = new ArrayList<Struct>(this.errors.size());
        for (Map.Entry<String, Errors> topicError : this.errors.entrySet()) {
            Struct topicErrorCodeStruct = struct.instance(TOPIC_ERROR_CODES_KEY_NAME);
            topicErrorCodeStruct.set(CommonFields.TOPIC_NAME, topicError.getKey());
            topicErrorCodeStruct.set(CommonFields.ERROR_CODE, topicError.getValue().code());
            topicErrorCodeStructs.add(topicErrorCodeStruct);
        }
        struct.set(TOPIC_ERROR_CODES_KEY_NAME, (Object)topicErrorCodeStructs.toArray());
        return struct;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Map<String, Errors> errors() {
        return this.errors;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.errors);
    }

    public static DeleteTopicsResponse parse(ByteBuffer buffer, short version) {
        return new DeleteTopicsResponse(ApiKeys.DELETE_TOPICS.responseSchema(version).read(buffer));
    }
}

