/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminClient;
import kafka.admin.AdminClient$;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Replica;
import kafka.coordinator.group.GroupOverview;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003T3hC\u000eL\u0018\tZ7j]\u000ec\u0017.\u001a8u)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00111\u0001\"!\u0003\u0006\u000e\u0003\tI!a\u0003\u0002\u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgN\u0004\"!\u0004\t\u000e\u00039Q!a\u0004\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Eq!a\u0002'pO\u001eLgn\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"!\u0003\u0001\t\u000f]\u0001!\u0019!C\u00011\u0005i\u0001O]8ek\u000e,'oQ8v]R,\u0012!\u0007\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0004\u0013:$\bB\u0002\u0011\u0001A\u0003%\u0011$\u0001\bqe>$WoY3s\u0007>,h\u000e\u001e\u0011\t\u000f\t\u0002!\u0019!C\u00011\u0005i1m\u001c8tk6,'oQ8v]RDa\u0001\n\u0001!\u0002\u0013I\u0012AD2p]N,X.\u001a:D_VtG\u000f\t\u0005\bM\u0001\u0011\r\u0011\"\u0001\u0019\u0003-\u0019XM\u001d<fe\u000e{WO\u001c;\t\r!\u0002\u0001\u0015!\u0003\u001a\u00031\u0019XM\u001d<fe\u000e{WO\u001c;!\u0011\u001dQ\u0003A1A\u0005\u0002-\nqa\u001a:pkBLE-F\u0001-!\ti#'D\u0001/\u0015\ty\u0003'\u0001\u0003mC:<'\"A\u0019\u0002\t)\fg/Y\u0005\u0003g9\u0012aa\u0015;sS:<\u0007BB\u001b\u0001A\u0003%A&\u0001\u0005he>,\b/\u00133!\u0011\u001d9\u0004A1A\u0005\u0002-\n\u0001b\u00197jK:$\u0018\n\u001a\u0005\u0007s\u0001\u0001\u000b\u0011\u0002\u0017\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0004\u0003bB\u001e\u0001\u0005\u0004%\taK\u0001\u0006i>\u0004\u0018n\u0019\u0005\u0007{\u0001\u0001\u000b\u0011\u0002\u0017\u0002\rQ|\u0007/[2!\u0011\u001dy\u0004A1A\u0005\u0002a\tA\u0001]1si\"1\u0011\t\u0001Q\u0001\ne\tQ\u0001]1si\u0002Bqa\u0011\u0001C\u0002\u0013\u0005A)\u0001\u0002uaV\tQ\t\u0005\u0002G\u001d6\tqI\u0003\u0002I\u0013\u000611m\\7n_:T!!\u0002&\u000b\u0005-c\u0015AB1qC\u000eDWMC\u0001N\u0003\ry'oZ\u0005\u0003\u001f\u001e\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004R\u0001\u0001\u0006I!R\u0001\u0004iB\u0004\u0003bB*\u0001\u0005\u0004%\t\u0001G\u0001\u0006a\u0006\u0014HO\r\u0005\u0007+\u0002\u0001\u000b\u0011B\r\u0002\rA\f'\u000f\u001e\u001a!\u0011\u001d9\u0006A1A\u0005\u0002\u0011\u000b1\u0001\u001e93\u0011\u0019I\u0006\u0001)A\u0005\u000b\u0006!A\u000f\u001d\u001a!\u0011\u001dY\u0006\u00011A\u0005\u0002q\u000baa\u00197jK:$X#A/\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001$\u0011!B1e[&t\u0017B\u00012`\u0005-\tE-\\5o\u00072LWM\u001c;\t\u000f\u0011\u0004\u0001\u0019!C\u0001K\u0006Q1\r\\5f]R|F%Z9\u0015\u0005\u0019L\u0007C\u0001\u000eh\u0013\tA7D\u0001\u0003V]&$\bb\u00026d\u0003\u0003\u0005\r!X\u0001\u0004q\u0012\n\u0004B\u00027\u0001A\u0003&Q,A\u0004dY&,g\u000e\u001e\u0011\t\u000b9\u0004A\u0011I8\u0002\u000bM,G/\u00169\u0015\u0003\u0019D#!\\9\u0011\u0005I,X\"A:\u000b\u0005Qd\u0015!\u00026v]&$\u0018B\u0001<t\u0005\u0019\u0011UMZ8sK\")\u0001\u0010\u0001C!_\u0006AA/Z1s\t><h\u000e\u000b\u0002xuB\u0011!o_\u0005\u0003yN\u0014Q!\u00114uKJDQA \u0001\u0005\u0002=\fQ\u0005^3tiN+Wm\u001b+p\u0005\u0016<\u0017N\u001c8j]\u001e\fe\r^3s\t\u0016dW\r^3SK\u000e|'\u000fZ:)\u0007u\f\t\u0001E\u0002s\u0003\u0007I1!!\u0002t\u0005\u0011!Vm\u001d;\t\r\u0005%\u0001\u0001\"\u0001p\u0003u!Xm\u001d;D_:\u001cX/\\3BMR,'\u000fR3mKR,'+Z2pe\u0012\u001c\b\u0006BA\u0004\u0003\u0003Aa!a\u0004\u0001\t\u0003y\u0017\u0001\b;fgRdunZ*uCJ$xJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e\u0015\u0005\u0003\u001b\t\t\u0001\u0003\u0004\u0002\u0016\u0001!\ta\\\u0001%i\u0016\u001cH\u000fT8h'R\f'\u000f^(gMN,G/\u00114uKJ$U\r\\3uKJ+7m\u001c:eg\"\"\u00111CA\u0001\u0011\u0019\tY\u0002\u0001C\u0001_\u0006)C/Z:u\u001f\u001a47/\u001a;t\r>\u0014H+[7fg^CWM\\(gMN,GOT8u\r>,h\u000e\u001a\u0015\u0005\u00033\t\t\u0001\u0003\u0004\u0002\"\u0001!\ta\\\u0001&i\u0016\u001cHo\u00144gg\u0016$8OR8s)&lWm]!gi\u0016\u0014H)\u001a7fi\u0016\u0014VmY8sINDC!a\b\u0002\u0002!1\u0011q\u0005\u0001\u0005\u0002=\fa\u0004^3ti\u0012+G.\u001a;f%\u0016\u001cwN\u001d3t/&$\b.\u0012=dKB$\u0018n\u001c8)\t\u0005\u0015\u0012\u0011\u0001\u0005\u0007\u0003[\u0001A\u0011A8\u0002\u001dQ,7\u000f\u001e'jgR<%o\\;qg\"\"\u00111FA\u0001\u0011\u0019\t\u0019\u0004\u0001C\u0001_\u0006aB/Z:u\u0019&\u001cH/\u00117m\u0005J|7.\u001a:WKJ\u001c\u0018n\u001c8J]\u001a|\u0007\u0006BA\u0019\u0003\u0003Aa!!\u000f\u0001\t\u0003y\u0017a\u0007;fgR<U\r^\"p]N,X.\u001a:He>,\boU;n[\u0006\u0014\u0018\u0010\u000b\u0003\u00028\u0005\u0005\u0001BBA \u0001\u0011\u0005q.A\ruKN$H)Z:de&\u0014WmQ8ogVlWM]$s_V\u0004\b\u0006BA\u001f\u0003\u0003Aa!!\u0012\u0001\t\u0003y\u0017\u0001\f;fgR$Um]2sS\n,7i\u001c8tk6,'o\u0012:pkB4uN\u001d(p]\u0016C\u0018n\u001d;f]R<%o\\;qQ\u0011\t\u0019%!\u0001\t\u000f\u0005-\u0003\u0001\"\u0003\u0002N\u0005i2/\u001e2tGJL'-Z!oI^\u000b\u0017\u000e\u001e$pe\u0006\u001b8/[4o[\u0016tG\u000fF\u0003g\u0003\u001f\n)\u0007C\u0004<\u0003\u0013\u0002\r!!\u0015\u0011\t\u0005M\u0013\u0011\r\b\u0005\u0003+\ni\u0006E\u0002\u0002Xmi!!!\u0017\u000b\u0007\u0005mc!\u0001\u0004=e>|GOP\u0005\u0004\u0003?Z\u0012A\u0002)sK\u0012,g-C\u00024\u0003GR1!a\u0018\u001c\u0011!\t9'!\u0013A\u0002\u0005%\u0014\u0001C2p]N,X.\u001a:\u0011\u0011\u0005-\u00141OA<\u0003oj!!!\u001c\u000b\t\u0005\u001d\u0014q\u000e\u0006\u0004\u0003cJ\u0015aB2mS\u0016tGo]\u0005\u0005\u0003k\niGA\u0007LC\u001a\\\u0017mQ8ogVlWM\u001d\t\u00065\u0005e\u0014QP\u0005\u0004\u0003wZ\"!B!se\u0006L\bc\u0001\u000e\u0002\u0000%\u0019\u0011\u0011Q\u000e\u0003\t\tKH/\u001a\u0005\b\u0003\u000b\u0003A\u0011BAD\u0003-\u0019XM\u001c3SK\u000e|'\u000fZ:\u0015\u000f\u0019\fI)a&\u0002\u001c\"A\u00111RAB\u0001\u0004\ti)\u0001\u0005qe>$WoY3s!!\ty)a%\u0002x\u0005]TBAAI\u0015\u0011\tY)a\u001c\n\t\u0005U\u0015\u0011\u0013\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\t\u000f\u0005e\u00151\u0011a\u00013\u0005Qa.^7SK\u000e|'\u000fZ:\t\r\r\u000b\u0019\t1\u0001F\u0001")
public class LegacyAdminClientTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int serverCount;
    private final String groupId;
    private final String clientId;
    private final String topic;
    private final int part;
    private final TopicPartition tp = new TopicPartition(this.topic(), this.part());
    private final int part2;
    private final TopicPartition tp2 = new TopicPartition(this.topic(), this.part2());
    private AdminClient client = null;

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    public String groupId() {
        return this.groupId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int part2() {
        return this.part2;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public AdminClient client() {
        return this.client;
    }

    public void client_$eq(AdminClient x$1) {
        this.client = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.client_$eq(AdminClient$.MODULE$.createSimplePlaintext(this.brokerList()));
        this.createTopic(this.topic(), 2, this.serverCount(), this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        this.client().close();
        super.tearDown();
    }

    @Test
    public void testSeekToBeginningAfterDeleteRecords() {
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        this.subscribeAndWaitForAssignment(this.topic(), (KafkaConsumer<byte[], byte[]>)consumer);
        this.sendRecords((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), 10, this.tp());
        consumer.seekToBeginning(Collections.singletonList(this.tp()));
        Assert.assertEquals((long)0L, (long)consumer.position(this.tp()));
        this.client().deleteRecordsBefore((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)BoxesRunTime.boxToLong((long)5L))}))).get();
        consumer.seekToBeginning(Collections.singletonList(this.tp()));
        Assert.assertEquals((long)5L, (long)consumer.position(this.tp()));
        this.client().deleteRecordsBefore((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)BoxesRunTime.boxToLong((long)-1L))}))).get();
        consumer.seekToBeginning(Collections.singletonList(this.tp()));
        Assert.assertEquals((long)10L, (long)consumer.position(this.tp()));
    }

    @Test
    public void testConsumeAfterDeleteRecords() {
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        this.subscribeAndWaitForAssignment(this.topic(), (KafkaConsumer<byte[], byte[]>)consumer);
        this.sendRecords((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), 10, this.tp());
        IntRef messageCount = IntRef.create((int)0);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            messageCount$1.elem += consumer.poll(0L).count();
            return messageCount$1.elem == 10;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected 10 messages", 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.client().deleteRecordsBefore((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)BoxesRunTime.boxToLong((long)3L))}))).get();
        consumer.seek(this.tp(), 1L);
        messageCount.elem = 0;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            messageCount$1.elem += consumer.poll(0L).count();
            return messageCount$1.elem == 7;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected 7 messages", 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.client().deleteRecordsBefore((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)BoxesRunTime.boxToLong((long)8L))}))).get();
        consumer.seek(this.tp(), 1L);
        messageCount.elem = 0;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            messageCount$1.elem += consumer.poll(0L).count();
            return messageCount$1.elem == 2;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected 2 messages", 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testLogStartOffsetCheckpoint() {
        this.subscribeAndWaitForAssignment(this.topic(), (KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()));
        this.sendRecords((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), 10, this.tp());
        Assert.assertEquals((Object)new AdminClient.DeleteRecordsResult(5L, null), (Object)((MapLike)this.client().deleteRecordsBefore((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)BoxesRunTime.boxToLong((long)5L))}))).get()).apply((Object)this.tp()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.serverCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.killBroker(i));
        this.restartDeadBrokers();
        this.client().close();
        this.brokerList_$eq(TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), this.listenerName()));
        this.client_$eq(AdminClient$.MODULE$.createSimplePlaintext(this.brokerList()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((AdminClient.DeleteRecordsResult)((MapLike)this.client().deleteRecordsBefore((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)BoxesRunTime.boxToLong((long)0L))}))).get(1000L, TimeUnit.MILLISECONDS)).apply((Object)this.tp())).equals((Object)new AdminClient.DeleteRecordsResult(5L, null)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected low watermark of the partition to be 5L", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testLogStartOffsetAfterDeleteRecords() {
        this.subscribeAndWaitForAssignment(this.topic(), (KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()));
        this.sendRecords((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), 10, this.tp());
        this.client().deleteRecordsBefore((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)BoxesRunTime.boxToLong((long)3L))}))).get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.serverCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assert.assertEquals((long)3L, (long)((Replica)((KafkaServer)this.servers().apply(i)).replicaManager().getReplica(this.tp()).get()).logStartOffset()));
    }

    @Test
    public void testOffsetsForTimesWhenOffsetNotFound() {
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        Assert.assertNull(consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new Long(0L))}))).asJava()).get(this.tp()));
    }

    @Test
    public void testOffsetsForTimesAfterDeleteRecords() {
        KafkaConsumer consumer = (KafkaConsumer)this.consumers().head();
        this.subscribeAndWaitForAssignment(this.topic(), (KafkaConsumer<byte[], byte[]>)consumer);
        this.sendRecords((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), 10, this.tp());
        Assert.assertEquals((long)0L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new Long(0L))}))).asJava()).get(this.tp())).offset());
        this.client().deleteRecordsBefore((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)BoxesRunTime.boxToLong((long)5L))}))).get();
        Assert.assertEquals((long)5L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new Long(0L))}))).asJava()).get(this.tp())).offset());
        this.client().deleteRecordsBefore((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)BoxesRunTime.boxToLong((long)-1L))}))).get();
        Assert.assertNull(consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)new Long(0L))}))).asJava()).get(this.tp()));
    }

    @Test
    public void testDeleteRecordsWithException() {
        this.subscribeAndWaitForAssignment(this.topic(), (KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()));
        this.sendRecords((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), 10, this.tp());
        Assert.assertEquals((Object)new AdminClient.DeleteRecordsResult(5L, null), (Object)((MapLike)this.client().deleteRecordsBefore((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)BoxesRunTime.boxToLong((long)5L))}))).get()).apply((Object)this.tp()));
        Assert.assertEquals((Object)new AdminClient.DeleteRecordsResult(-1L, (Exception)Errors.OFFSET_OUT_OF_RANGE.exception()), (Object)((MapLike)this.client().deleteRecordsBefore((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.tp(), (Object)BoxesRunTime.boxToLong((long)20L))}))).get()).apply((Object)this.tp()));
        TopicPartition nonExistPartition = new TopicPartition(this.topic(), 3);
        Assert.assertEquals((Object)new AdminClient.DeleteRecordsResult(-1L, (Exception)Errors.LEADER_NOT_AVAILABLE.exception()), (Object)((MapLike)this.client().deleteRecordsBefore((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)nonExistPartition, (Object)BoxesRunTime.boxToLong((long)20L))}))).get()).apply((Object)nonExistPartition));
    }

    @Test
    public void testListGroups() {
        this.subscribeAndWaitForAssignment(this.topic(), (KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()));
        List groups = this.client().listAllGroupsFlattened();
        Assert.assertFalse((boolean)groups.isEmpty());
        GroupOverview group = (GroupOverview)groups.head();
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)"consumer", (Object)group.protocolType());
    }

    @Test
    public void testListAllBrokerVersionInfo() {
        this.subscribeAndWaitForAssignment(this.topic(), (KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()));
        scala.collection.immutable.Map brokerVersionInfos = this.client().listAllBrokerVersionInfo();
        String[] brokers = this.brokerList().split(",");
        Assert.assertEquals((long)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokers)).size(), (long)brokerVersionInfos.size());
        brokerVersionInfos.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)LegacyAdminClientTest.$anonfun$testListAllBrokerVersionInfo$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            LegacyAdminClientTest.$anonfun$testListAllBrokerVersionInfo$2(brokers, x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetConsumerGroupSummary() {
        this.subscribeAndWaitForAssignment(this.topic(), (KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()));
        AdminClient qual$1 = this.client();
        String x$4 = this.groupId();
        long x$5 = qual$1.describeConsumerGroup$default$2();
        AdminClient.ConsumerGroupSummary group = qual$1.describeConsumerGroup(x$4, x$5);
        Assert.assertEquals((Object)"range", (Object)group.assignmentStrategy());
        Assert.assertEquals((Object)"Stable", (Object)group.state());
        Assert.assertFalse((boolean)group.consumers().isEmpty());
        AdminClient.ConsumerSummary member = (AdminClient.ConsumerSummary)((IterableLike)group.consumers().get()).head();
        Assert.assertEquals((Object)this.clientId(), (Object)member.clientId());
        Assert.assertFalse((boolean)member.host().isEmpty());
        Assert.assertFalse((boolean)member.consumerId().isEmpty());
    }

    @Test
    public void testDescribeConsumerGroup() {
        this.subscribeAndWaitForAssignment(this.topic(), (KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()));
        AdminClient qual$2 = this.client();
        String x$6 = this.groupId();
        long x$7 = qual$2.describeConsumerGroup$default$2();
        AdminClient.ConsumerGroupSummary consumerGroupSummary = qual$2.describeConsumerGroup(x$6, x$7);
        Assert.assertEquals((long)1L, (long)((SeqLike)consumerGroupSummary.consumers().get()).size());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp(), this.tp2()})), (Object)((List)consumerGroupSummary.consumers().get()).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.assignment(), List$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testDescribeConsumerGroupForNonExistentGroup() {
        String nonExistentGroup = "non" + this.groupId();
        AdminClient qual$3 = this.client();
        String x$8 = nonExistentGroup;
        long x$9 = qual$3.describeConsumerGroup$default$2();
        Assert.assertTrue((String)"Expected empty ConsumerSummary list", (boolean)((SeqLike)qual$3.describeConsumerGroup(x$8, x$9).consumers().get()).isEmpty());
    }

    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(0L);
            return !consumer.assignment().isEmpty();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected non-empty assignment", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp) {
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> LegacyAdminClientTest.$anonfun$sendRecords$1(this, producer, tp, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        futures.foreach((Function1 & Serializable & scala.Serializable)x$3 -> (RecordMetadata)x$3.get());
    }

    public static final /* synthetic */ boolean $anonfun$testListAllBrokerVersionInfo$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testListAllBrokerVersionInfo$2(String[] brokers$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Node node = (Node)tuple2._1();
        Try tryBrokerVersionInfo = (Try)tuple2._2();
        String hostStr = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node.host(), BoxesRunTime.boxToInteger((int)node.port())}));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown host:port pair ", " in brokerVersionInfos"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostStr})), (boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokers$1)).contains((Object)hostStr));
        NodeApiVersions brokerVersionInfo = (NodeApiVersions)tryBrokerVersionInfo.get();
        Assert.assertEquals((long)1L, (long)brokerVersionInfo.latestUsableVersion(ApiKeys.API_VERSIONS));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1(LegacyAdminClientTest $this, KafkaProducer producer$1, TopicPartition tp$1, int i) {
        ProducerRecord record = new ProducerRecord(tp$1.topic(), Predef$.MODULE$.int2Integer(tp$1.partition()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending this record: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record})));
        return producer$1.send(record);
    }

    public LegacyAdminClientTest() {
        this.producerCount = 1;
        this.consumerCount = 2;
        this.serverCount = 3;
        this.groupId = "my-test";
        this.clientId = "consumer-498";
        this.topic = "topic";
        this.part = 0;
        this.part2 = 1;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        this.producerConfig().setProperty("acks", "all");
        this.consumerConfig().setProperty("group.id", this.groupId());
        this.consumerConfig().setProperty("client.id", this.clientId());
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
    }
}

