/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans.activity;

import java.util.Iterator;
import uk.ac.ic.doc.scenebeans.activity.Activity;
import uk.ac.ic.doc.scenebeans.activity.ActivityList;
import uk.ac.ic.doc.scenebeans.activity.CompositeActivity;
import uk.ac.ic.doc.scenebeans.event.AnimationEvent;
import uk.ac.ic.doc.scenebeans.event.AnimationListener;

public class ConcurrentActivity
extends CompositeActivity
implements AnimationListener {
    private ActivityList _activities = ActivityList.EMPTY;
    int _finite_count = 0;
    int _complete = 0;

    public synchronized void reset() {
        this._complete = 0;
        Iterator iterator = this._activities.iterator();
        while (iterator.hasNext()) {
            ((Activity)iterator.next()).reset();
        }
    }

    public synchronized void addActivity(Activity activity) {
        activity.setActivityRunner(this);
        if (activity.isFinite()) {
            ++this._finite_count;
            activity.addAnimationListener(this);
        }
        this._activities = this._activities.add(activity);
    }

    public synchronized void removeActivity(Activity activity) {
        if (activity.isFinite()) {
            --this._finite_count;
            activity.removeAnimationListener(this);
        }
        this._activities = this._activities.remove(activity);
        activity.setActivityRunner(null);
    }

    public void performActivity(double d) {
        this._activities.performActivities(d);
    }

    public void animationEvent(AnimationEvent animationEvent) {
        ++this._complete;
        if (this._complete == this._finite_count) {
            this.postActivityComplete();
        }
    }
}

