/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{LitElement as p,css as h,nothing as m,html as u}from"lit";import{property as c,state as b,customElement as f}from"lit/decorators.js";import"@typo3/backend/element/icon-element.js";import g from"@typo3/core/ajax/ajax-request.js";import v from"@typo3/backend/notification.js";var s=function(d,t,n,l){var i=arguments.length,e=i<3?t:l===null?l=Object.getOwnPropertyDescriptor(t,n):l,o;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")e=Reflect.decorate(d,t,n,l);else for(var a=d.length-1;a>=0;a--)(o=d[a])&&(e=(i<3?o(e):i>3?o(t,n,e):o(t,n))||e);return i>3&&e&&Object.defineProperty(t,n,e),e};let r=class extends p{constructor(){super(...arguments),this.groupName="",this.groupId=0,this.editable=!1,this._isEditing=!1,this._isSubmitting=!1,this.labels={input:TYPO3?.lang?.["editableGroupName.input.field.label"]||"Field",edit:TYPO3?.lang?.["editableGroupName.button.edit.label"]||"Edit",save:TYPO3?.lang?.["editableGroupName.button.save.label"]||"Save",cancel:TYPO3?.lang?.["editableGroupName.button.cancel.label"]||"Cancel"}}static{this.styles=h`:host{display:block;--input-border-color:#bebebe;--input-hover-border-color:#bebebe;--input-focus-border-color:#bebebe;--button-border-radius:2px;--button-color:inherit;--button-bg:transparent;--button-border-color:transparent;--button-hover-color:inherit;--button-hover-bg:#cacaca;--button-hover-border-color:#bebebe;--button-focus-color:inherit;--button-focus-bg:#cacaca;--button-focus-border-color:#bebebe}.label{display:block;white-space:nowrap;text-overflow:ellipsis;overflow:hidden;padding:calc(1px + .16rem) 0}.label,input{font-weight:inherit;font-size:inherit;font-family:inherit;line-height:inherit;margin:0}input{outline:none;background:transparent;padding:.16rem 0;border:0;border-top:1px solid transparent;border-bottom:1px dashed var(--input-border-color);width:100%;outline-offset:0}input:hover{--input-border-color:var(--input-hover-border-color)}input:focus{--input-border-color:var(--input-focus-border-color)}input:focus-visible{outline:.25rem solid color-mix(in srgb,var(--input-border-color),transparent 25%)}.wrapper{position:relative;margin:-1px 0}div.wrapper{padding-inline-end:2.5em}form.wrapper{padding-inline-end:5em}button{cursor:pointer;display:inline-flex;align-items:center;justify-content:center;font-size:inherit;line-height:inherit;border:0;padding:0;height:100%;width:2em;position:absolute;top:0;border-radius:var(--button-border-radius);overflow:hidden;outline:none;color:var(--button-color);background:var(--button-bg);border:1px solid var(--button-border-color);opacity:.3;outline-offset:0;transition:all .2s ease-in-out}button:hover{opacity:1;--button-color:var(--button-hover-color);--button-bg:var(--button-hover-bg);--button-border-color:var(--button-hover-border-color)}button:focus{opacity:1;--button-color:var(--button-focus-color);--button-bg:var(--button-focus-bg);--button-border-color:var(--button-focus-border-color)}button:focus-visible{outline:.25rem solid color-mix(in srgb,var(--button-border-color),transparent 25%)}button[data-action=edit]{inset-inline-end:0}button[data-action=save]{inset-inline-end:calc(2em + 2px)}button[data-action=close]{inset-inline-end:0}.screen-reader{position:absolute;width:1px;height:1px;padding:0;margin:-1px;overflow:hidden;clip:rect(0,0,0,0);white-space:nowrap;border:0}`}async startEditing(){this.isEditable()&&(this._isEditing=!0,await this.updateComplete,this.shadowRoot.querySelector("input")?.focus())}render(){if(this.groupName==="")return m;if(!this.isEditable())return u`<div class=wrapper><div class=label>${this.groupName}</div></div>`;let t;return this._isEditing?t=this.composeEditForm():t=u`<div class=wrapper><div class=label @dblclick=${()=>{this.startEditing()}}>${this.groupName}</div>${this.composeEditButton()}</div>`,t}isEditable(){return this.editable&&this.groupId>0}endEditing(){this.isEditable()&&(this._isEditing=!1)}updateGroupName(t){t.preventDefault();const n=new FormData(t.target),i=Object.fromEntries(n).newGroupName.toString();if(this.groupName===i){this.endEditing();return}this._isSubmitting=!0;const e="&data[tx_scheduler_task_group]["+this.groupId+"][groupName]="+encodeURIComponent(i)+"&redirect="+encodeURIComponent(document.location.href);new g(TYPO3.settings.ajaxUrls.record_process).post(e,{headers:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"}}).then(async o=>await o.resolve()).then(o=>(o.messages.forEach(a=>{v.info(a.title,a.message),window.location.href=o.redirect}),o)).then(()=>{this.groupName=i}).finally(()=>{this.endEditing(),this._isSubmitting=!1})}composeEditButton(){return u`<button data-action=edit type=button title=${this.labels.edit} @click=${()=>{this.startEditing()}}><typo3-backend-icon identifier=actions-open size=small></typo3-backend-icon><span class=screen-reader>${this.labels.edit}</span></button>`}composeEditForm(){return u`<form class=wrapper @submit=${this.updateGroupName}><label class=screen-reader for=input>${this.labels.input}</label> <input autocomplete=off id=input name=newGroupName required value=${this.groupName} ?disabled=${this._isSubmitting} @keydown=${t=>{t.key==="Escape"&&this.endEditing()}}> <button data-action=save type=submit title=${this.labels.save} ?disabled=${this._isSubmitting}><typo3-backend-icon identifier=actions-check size=small></typo3-backend-icon><span class=screen-reader>${this.labels.save}</span></button> <button data-action=close type=button title=${this.labels.cancel} ?disabled=${this._isSubmitting} @click=${()=>{this.endEditing()}}><typo3-backend-icon identifier=actions-close size=small></typo3-backend-icon><span class=screen-reader>${this.labels.cancel}</span></button></form>`}};s([c({type:String})],r.prototype,"groupName",void 0),s([c({type:Number})],r.prototype,"groupId",void 0),s([c({type:Boolean})],r.prototype,"editable",void 0),s([b()],r.prototype,"_isEditing",void 0),s([b()],r.prototype,"_isSubmitting",void 0),r=s([f("typo3-scheduler-editable-group-name")],r);export{r as EditableGroupName};
