"""Generated message classes for cloudidentity version v1beta1.

API for provisioning and managing identity resources.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudidentity'


class AndroidAttributes(_messages.Message):
  r"""Resource representing the Android specific attributes of a Device.

  Enums:
    OwnershipPrivilegeValueValuesEnum: Ownership privileges on device.

  Fields:
    enabledUnknownSources: Whether applications from unknown sources can be
      installed on device.
    ownerProfileAccount: Whether this account is on an owner/primary profile.
      For phones, only true for owner profiles. Android 4+ devices can have
      secondary or restricted user profiles.
    ownershipPrivilege: Ownership privileges on device.
    supportsWorkProfile: Whether device supports Android work profiles. If
      false, this service will not block access to corp data even if an
      administrator turns on the "Enforce Work Profile" policy.
  """

  class OwnershipPrivilegeValueValuesEnum(_messages.Enum):
    r"""Ownership privileges on device.

    Values:
      OWNERSHIP_PRIVILEGE_UNSPECIFIED: Ownership privilege is not set.
      DEVICE_ADMINISTRATOR: Active device administrator privileges on the
        device.
      PROFILE_OWNER: Profile Owner privileges. The account is in a managed
        corporate profile.
      DEVICE_OWNER: Device Owner privileges on the device.
    """
    OWNERSHIP_PRIVILEGE_UNSPECIFIED = 0
    DEVICE_ADMINISTRATOR = 1
    PROFILE_OWNER = 2
    DEVICE_OWNER = 3

  enabledUnknownSources = _messages.BooleanField(1)
  ownerProfileAccount = _messages.BooleanField(2)
  ownershipPrivilege = _messages.EnumField('OwnershipPrivilegeValueValuesEnum', 3)
  supportsWorkProfile = _messages.BooleanField(4)


class ApproveDeviceUserRequest(_messages.Message):
  r"""Request message for approving the device to access user data.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
  """

  customer = _messages.StringField(1)


class ApproveDeviceUserResponse(_messages.Message):
  r"""Response message for approving the device to access user data.

  Fields:
    deviceUser: Resultant DeviceUser object for the action.
  """

  deviceUser = _messages.MessageField('DeviceUser', 1)


class BlockDeviceUserRequest(_messages.Message):
  r"""Request message for blocking account on device.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
  """

  customer = _messages.StringField(1)


class BlockDeviceUserResponse(_messages.Message):
  r"""Response message for blocking the device from accessing user data.

  Fields:
    deviceUser: Resultant DeviceUser object for the action.
  """

  deviceUser = _messages.MessageField('DeviceUser', 1)


class CancelWipeDeviceRequest(_messages.Message):
  r"""Request message for cancelling an unfinished device wipe.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
  """

  customer = _messages.StringField(1)


class CancelWipeDeviceResponse(_messages.Message):
  r"""Response message for cancelling an unfinished device wipe.

  Fields:
    device: Resultant Device object for the action. Note that asset tags will
      not be returned in the device object.
  """

  device = _messages.MessageField('Device', 1)


class CancelWipeDeviceUserRequest(_messages.Message):
  r"""Request message for cancelling an unfinished user account wipe.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
  """

  customer = _messages.StringField(1)


class CancelWipeDeviceUserResponse(_messages.Message):
  r"""Response message for cancelling an unfinished user account wipe.

  Fields:
    deviceUser: Resultant DeviceUser object for the action.
  """

  deviceUser = _messages.MessageField('DeviceUser', 1)


class CheckTransitiveMembershipResponse(_messages.Message):
  r"""The response message for MembershipsService.CheckTransitiveMembership.

  Fields:
    hasMembership: Response does not include the possible roles of a member
      since the behavior of this rpc is not all-or-nothing unlike the other
      rpcs. So, it may not be possible to list all the roles definitively, due
      to possible lack of authorization in some of the paths.
  """

  hasMembership = _messages.BooleanField(1)


class ClientContext(_messages.Message):
  r"""Information related to the caller client.

  Fields:
    appId: [Optional] Identifier of the application. e.g., "com.google.Drive"
    clientVersion: The name and the version of the client. e.g. "DXP 1.0"
    iosVendorId: Vendor id of the ios device.
    osVersion: [Optional] OS version on which the client app is running. e.g.,
      "iOS 12.1"
  """

  appId = _messages.StringField(1)
  clientVersion = _messages.StringField(2)
  iosVendorId = _messages.StringField(3)
  osVersion = _messages.StringField(4)


class ClientState(_messages.Message):
  r"""Represents the state associated with an API client calling the Devices
  API. Resource representing ClientState and supports updates from API users

  Enums:
    ComplianceStateValueValuesEnum: The compliance state of the resource as
      specified by the API client.
    HealthScoreValueValuesEnum: The Health score of the resource
    ManagedValueValuesEnum: The management state of the resource as specified
      by the API client.
    OwnerTypeValueValuesEnum: Output only. The owner of the ClientState

  Messages:
    KeyValuePairsValue: The map of key-value attributes stored by callers
      specific to a device. The total serialized length of this map may not
      exceed 10KB. No limit is placed on the number of attributes in a map.

  Fields:
    assetTags: The caller can specify asset tags for this resource
    complianceState: The compliance state of the resource as specified by the
      API client.
    createTime: Output only. The time the client state data was created.
    customId: This field may be used to store a unique identifier for the API
      resource within which these CustomAttributes are a field.
    etag: The token that needs to be passed back for concurrency control in
      updates. Token needs to be passed back in UpdateRequest
    healthScore: The Health score of the resource
    keyValuePairs: The map of key-value attributes stored by callers specific
      to a device. The total serialized length of this map may not exceed
      10KB. No limit is placed on the number of attributes in a map.
    lastUpdateTime: Output only. The time the client state data was last
      updated.
    managed: The management state of the resource as specified by the API
      client.
    name: Output only. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      ClientState in format: `devices/{device_id}/deviceUsers/{device_user_id}
      /clientState/{partner_id}`, where partner_id corresponds to the partner
      storing the data.
    ownerType: Output only. The owner of the ClientState
    scoreReason: A descriptive cause of the health score.
  """

  class ComplianceStateValueValuesEnum(_messages.Enum):
    r"""The compliance state of the resource as specified by the API client.

    Values:
      COMPLIANCE_STATE_UNSPECIFIED: The compliance state of the resource is
        unknown or unspecified.
      COMPLIANT: Device is compliant with third party policies
      NON_COMPLIANT: Device is not compliant with third party policies
    """
    COMPLIANCE_STATE_UNSPECIFIED = 0
    COMPLIANT = 1
    NON_COMPLIANT = 2

  class HealthScoreValueValuesEnum(_messages.Enum):
    r"""The Health score of the resource

    Values:
      HEALTH_SCORE_UNSPECIFIED: Default value
      VERY_POOR: The object is in very poor health as defined by the caller.
      POOR: The object is in poor health as defined by the caller.
      NEUTRAL: The object health is neither good nor poor, as defined by the
        caller.
      GOOD: The object is in good health as defined by the caller.
      VERY_GOOD: The object is in very good health as defined by the caller.
    """
    HEALTH_SCORE_UNSPECIFIED = 0
    VERY_POOR = 1
    POOR = 2
    NEUTRAL = 3
    GOOD = 4
    VERY_GOOD = 5

  class ManagedValueValuesEnum(_messages.Enum):
    r"""The management state of the resource as specified by the API client.

    Values:
      MANAGED_STATE_UNSPECIFIED: The management state of the resource is
        unknown or unspecified.
      MANAGED: The resource is managed.
      UNMANAGED: The resource is not managed.
    """
    MANAGED_STATE_UNSPECIFIED = 0
    MANAGED = 1
    UNMANAGED = 2

  class OwnerTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The owner of the ClientState

    Values:
      OWNER_TYPE_UNSPECIFIED: Unknown owner type
      OWNER_TYPE_CUSTOMER: Customer is the owner
      OWNER_TYPE_PARTNER: Partner is the owner
    """
    OWNER_TYPE_UNSPECIFIED = 0
    OWNER_TYPE_CUSTOMER = 1
    OWNER_TYPE_PARTNER = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class KeyValuePairsValue(_messages.Message):
    r"""The map of key-value attributes stored by callers specific to a
    device. The total serialized length of this map may not exceed 10KB. No
    limit is placed on the number of attributes in a map.

    Messages:
      AdditionalProperty: An additional property for a KeyValuePairsValue
        object.

    Fields:
      additionalProperties: Additional properties of type KeyValuePairsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a KeyValuePairsValue object.

      Fields:
        key: Name of the additional property.
        value: A CustomAttributeValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('CustomAttributeValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  assetTags = _messages.StringField(1, repeated=True)
  complianceState = _messages.EnumField('ComplianceStateValueValuesEnum', 2)
  createTime = _messages.StringField(3)
  customId = _messages.StringField(4)
  etag = _messages.StringField(5)
  healthScore = _messages.EnumField('HealthScoreValueValuesEnum', 6)
  keyValuePairs = _messages.MessageField('KeyValuePairsValue', 7)
  lastUpdateTime = _messages.StringField(8)
  managed = _messages.EnumField('ManagedValueValuesEnum', 9)
  name = _messages.StringField(10)
  ownerType = _messages.EnumField('OwnerTypeValueValuesEnum', 11)
  scoreReason = _messages.StringField(12)


class CloudidentityDevicesCancelWipeRequest(_messages.Message):
  r"""A CloudidentityDevicesCancelWipeRequest object.

  Fields:
    cancelWipeDeviceRequest: A CancelWipeDeviceRequest resource to be passed
      as the request body.
    name: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}`, where device_id is the unique ID
      assigned to the Device, and device_user_id is the unique ID assigned to
      the User.
  """

  cancelWipeDeviceRequest = _messages.MessageField('CancelWipeDeviceRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudidentityDevicesDeleteRequest(_messages.Message):
  r"""A CloudidentityDevicesDeleteRequest object.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
    name: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}`, where device_id is the unique ID
      assigned to the Device.
  """

  customer = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class CloudidentityDevicesDeviceUsersApproveRequest(_messages.Message):
  r"""A CloudidentityDevicesDeviceUsersApproveRequest object.

  Fields:
    approveDeviceUserRequest: A ApproveDeviceUserRequest resource to be passed
      as the request body.
    name: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}/deviceUsers/{device_user_id}`, where
      device_id is the unique ID assigned to the Device, and device_user_id is
      the unique ID assigned to the User.
  """

  approveDeviceUserRequest = _messages.MessageField('ApproveDeviceUserRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudidentityDevicesDeviceUsersBlockRequest(_messages.Message):
  r"""A CloudidentityDevicesDeviceUsersBlockRequest object.

  Fields:
    blockDeviceUserRequest: A BlockDeviceUserRequest resource to be passed as
      the request body.
    name: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}/deviceUsers/{device_user_id}`, where
      device_id is the unique ID assigned to the Device, and device_user_id is
      the unique ID assigned to the User.
  """

  blockDeviceUserRequest = _messages.MessageField('BlockDeviceUserRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudidentityDevicesDeviceUsersCancelWipeRequest(_messages.Message):
  r"""A CloudidentityDevicesDeviceUsersCancelWipeRequest object.

  Fields:
    cancelWipeDeviceUserRequest: A CancelWipeDeviceUserRequest resource to be
      passed as the request body.
    name: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}/deviceUsers/{device_user_id}`, where
      device_id is the unique ID assigned to the Device, and device_user_id is
      the unique ID assigned to the User.
  """

  cancelWipeDeviceUserRequest = _messages.MessageField('CancelWipeDeviceUserRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudidentityDevicesDeviceUsersClientStatesGetRequest(_messages.Message):
  r"""A CloudidentityDevicesDeviceUsersClientStatesGetRequest object.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
    name: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      ClientState in format: `devices/{device_id}/deviceUsers/{device_user_id}
      /clientStates/{partner_id}`, where device_id is the unique ID assigned
      to the Device, device_user_id is the unique ID assigned to the User and
      partner_id identifies the partner storing the data. To get the client
      state for devices belonging to your own organization, the `partnerId` is
      in the format: `customerId-*anystring*`. Where the `customerId` is your
      organization's customer ID and `anystring` is any suffix. This suffix is
      used in setting up Custom Access Levels in Context-Aware Access. You may
      use `my_customer` instead of the customer ID for devices managed by your
      own organization.
  """

  customer = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class CloudidentityDevicesDeviceUsersClientStatesListRequest(_messages.Message):
  r"""A CloudidentityDevicesDeviceUsersClientStatesListRequest object.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
    filter: Optional. Additional restrictions when fetching list of client
      states.
    orderBy: Optional. Order specification for client states in the response.
    pageToken: Optional. A page token, received from a previous
      `ListClientStates` call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters provided to `ListClientStates`
      must match the call that provided the page token.
    parent: Required. To list all ClientStates, set this to
      "devices/-/deviceUsers/-". To list all ClientStates owned by a
      DeviceUser, set this to the resource name of the DeviceUser. Format:
      devices/{device}/deviceUsers/{deviceUser}
  """

  customer = _messages.StringField(1)
  filter = _messages.StringField(2)
  orderBy = _messages.StringField(3)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudidentityDevicesDeviceUsersClientStatesPatchRequest(_messages.Message):
  r"""A CloudidentityDevicesDeviceUsersClientStatesPatchRequest object.

  Fields:
    clientState: A ClientState resource to be passed as the request body.
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
    name: Output only. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      ClientState in format: `devices/{device_id}/deviceUsers/{device_user_id}
      /clientState/{partner_id}`, where partner_id corresponds to the partner
      storing the data.
    updateMask: Optional. Comma-separated list of fully qualified names of
      fields to be updated. If not specified, all updatable fields in
      ClientState are updated.
  """

  clientState = _messages.MessageField('ClientState', 1)
  customer = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  updateMask = _messages.StringField(4)


class CloudidentityDevicesDeviceUsersCollectBugReportRequest(_messages.Message):
  r"""A CloudidentityDevicesDeviceUsersCollectBugReportRequest object.

  Fields:
    collectBugReportRequest: A CollectBugReportRequest resource to be passed
      as the request body.
    name: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}/deviceUsers/{device_user_id}`, where
      device_id is the unique ID assigned to the Device, and device_user_id is
      the unique ID assigned to the User.
  """

  collectBugReportRequest = _messages.MessageField('CollectBugReportRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudidentityDevicesDeviceUsersDeleteRequest(_messages.Message):
  r"""A CloudidentityDevicesDeviceUsersDeleteRequest object.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
    name: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}/deviceUsers/{device_user_id}`, where
      device_id is the unique ID assigned to the Device, and device_user_id is
      the unique ID assigned to the User.
  """

  customer = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class CloudidentityDevicesDeviceUsersEndpointAppsListRequest(_messages.Message):
  r"""A CloudidentityDevicesDeviceUsersEndpointAppsListRequest object.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
    orderBy: Optional. Order specification for devices in the response.
    pageSize: Optional. The maximum number of Apps to return. If unspecified,
      at most 20 Apps will be returned. The maximum value is 20; values above
      20 will be coerced to 20.
    pageToken: Optional. page_token to get subsequent pages in the response
      starting at this token. This should be filled with the value provided by
      a previous call to ListDevices.
    parent: Required. The parent, which owns this collection of EndpointApps.
      Supported Format: devices/{device}/deviceUsers/{deviceUser} Note:
      wildcards in parent path are not supported.
  """

  customer = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudidentityDevicesDeviceUsersGetRequest(_messages.Message):
  r"""A CloudidentityDevicesDeviceUsersGetRequest object.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
    name: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}/deviceUsers/{device_user_id}`, where
      device_id is the unique ID assigned to the Device, and device_user_id is
      the unique ID assigned to the User.
  """

  customer = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class CloudidentityDevicesDeviceUsersListRequest(_messages.Message):
  r"""A CloudidentityDevicesDeviceUsersListRequest object.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
    filter: Optional. Additional restrictions when fetching list of devices.
      [HC article](https://support.google.com/a/answer/7549103)
    orderBy: Optional. Order specification for devices in the response.
    pageSize: Optional. The maximum number of DeviceUsers to return. If
      unspecified, at most 5 DeviceUsers will be returned. The maximum value
      is 20; values above 20 will be coerced to 20.
    pageToken: Optional. A page token, received from a previous
      `ListDeviceUsers` call. Provide this to retrieve the subsequent page.
      When paginating, all other parameters provided to `ListBooks` must match
      the call that provided the page token.
    parent: Required. To list all DeviceUsers, set this to "devices/-". To
      list all DeviceUsers owned by a device, set this to the resource name of
      the device. Format: devices/{device}
  """

  customer = _messages.StringField(1)
  filter = _messages.StringField(2)
  orderBy = _messages.StringField(3)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)
  parent = _messages.StringField(6, required=True)


class CloudidentityDevicesDeviceUsersLookupRequest(_messages.Message):
  r"""A CloudidentityDevicesDeviceUsersLookupRequest object.

  Fields:
    androidId: Android Id returned by [Settings.Secure#ANDROID_ID](https://dev
      eloper.android.com/reference/android/provider/Settings.Secure.html#ANDRO
      ID_ID).
    pageSize: The maximum number of DeviceUsers to return. If unspecified, at
      most 20 DeviceUsers will be returned. The maximum value is 20; values
      above 20 will be coerced to 20.
    pageToken: A page token, received from a previous `LookupDeviceUsers`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to `LookupDeviceUsers` must match the call
      that provided the page token.
    parent: Must be set to "devices/-/deviceUsers" to search across all
      DeviceUser belonging to the user.
    rawResourceId: Raw Resource Id used by Google Endpoint Verification. If
      the user is enrolled into Google Endpoint Verification, this id will be
      saved as the 'device_resource_id' field in the following platform
      dependent files. Mac: ~/.secureConnect/context_aware_config.json
      Windows:
      C:\\Users\%USERPROFILE%\.secureConnect\context_aware_config.json Linux:
      ~/.secureConnect/context_aware_config.json
    userId: The user whose DeviceUser's resource name will be fetched. Must be
      set to 'me' to fetch the DeviceUser's resource name for the calling
      user.
  """

  androidId = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  rawResourceId = _messages.StringField(5)
  userId = _messages.StringField(6)


class CloudidentityDevicesDeviceUsersPatchRequest(_messages.Message):
  r"""A CloudidentityDevicesDeviceUsersPatchRequest object.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
    deviceUser: A DeviceUser resource to be passed as the request body.
    name: Output only. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      DeviceUser in format: `devices/{device_id}/deviceUsers/{user_id}`, where
      user_id is the ID of the user associated with the user session.
    name1: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}/deviceUsers/{device_user_id}`, where
      device_id is the unique ID assigned to the Device, and device_user_id is
      the unique ID assigned to the User.
    updateMask: Required. Fully qualified names of fields to update. Only
      "custom_attributes" is supported.
  """

  customer = _messages.StringField(1)
  deviceUser = _messages.MessageField('DeviceUser', 2)
  name = _messages.StringField(3, required=True)
  name1 = _messages.StringField(4)
  updateMask = _messages.StringField(5)


class CloudidentityDevicesDeviceUsersSignoutRequest(_messages.Message):
  r"""A CloudidentityDevicesDeviceUsersSignoutRequest object.

  Fields:
    name: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}/deviceUsers/{device_user_id}`, where
      device_id is the unique ID assigned to the Device, and device_user_id is
      the unique ID assigned to the User.
    signoutDeviceUserRequest: A SignoutDeviceUserRequest resource to be passed
      as the request body.
  """

  name = _messages.StringField(1, required=True)
  signoutDeviceUserRequest = _messages.MessageField('SignoutDeviceUserRequest', 2)


class CloudidentityDevicesDeviceUsersSyncRequest(_messages.Message):
  r"""A CloudidentityDevicesDeviceUsersSyncRequest object.

  Fields:
    name: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}/deviceUsers/{device_user_id}`, where
      device_id is the unique ID assigned to the Device, and device_user_id is
      the unique ID assigned to the User.
    syncDeviceUserRequest: A SyncDeviceUserRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  syncDeviceUserRequest = _messages.MessageField('SyncDeviceUserRequest', 2)


class CloudidentityDevicesDeviceUsersUnenrollRequest(_messages.Message):
  r"""A CloudidentityDevicesDeviceUsersUnenrollRequest object.

  Fields:
    name: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}/deviceUsers/{device_user_id}`, where
      device_id is the unfique ID assigned to the Device, and device_user_id
      is the unique ID assigned to the User.
    unenrollDeviceUserRequest: A UnenrollDeviceUserRequest resource to be
      passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  unenrollDeviceUserRequest = _messages.MessageField('UnenrollDeviceUserRequest', 2)


class CloudidentityDevicesDeviceUsersWipeRequest(_messages.Message):
  r"""A CloudidentityDevicesDeviceUsersWipeRequest object.

  Fields:
    name: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}/deviceUsers/{device_user_id}`, where
      device_id is the unique ID assigned to the Device, and device_user_id is
      the unique ID assigned to the User.
    wipeDeviceUserRequest: A WipeDeviceUserRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  wipeDeviceUserRequest = _messages.MessageField('WipeDeviceUserRequest', 2)


class CloudidentityDevicesGetRequest(_messages.Message):
  r"""A CloudidentityDevicesGetRequest object.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      Customer in format: `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
    name: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}`, where device_id is the unique ID
      assigned to the Device.
  """

  customer = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class CloudidentityDevicesGetSettingsRequest(_messages.Message):
  r"""A CloudidentityDevicesGetSettingsRequest object.

  Fields:
    clientContext_appId: [Optional] Identifier of the application. e.g.,
      "com.google.Drive"
    clientContext_clientVersion: The name and the version of the client. e.g.
      "DXP 1.0"
    clientContext_iosVendorId: Vendor id of the ios device.
    clientContext_osVersion: [Optional] OS version on which the client app is
      running. e.g., "iOS 12.1"
    resourceId: Resource id of the entity for which the settings are
      requested.
  """

  clientContext_appId = _messages.StringField(1)
  clientContext_clientVersion = _messages.StringField(2)
  clientContext_iosVendorId = _messages.StringField(3)
  clientContext_osVersion = _messages.StringField(4)
  resourceId = _messages.StringField(5, required=True)


class CloudidentityDevicesListRequest(_messages.Message):
  r"""A CloudidentityDevicesListRequest object.

  Enums:
    ViewValueValuesEnum: Optional. The view to use for the List request.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer.
    filter: Optional. Additional restrictions when fetching list of devices.
      [HC article link](https://support.google.com/a/answer/7549103)
    orderBy: Optional. Order specification for devices in the response. Only
      one of the following field names may be used to specify the order:
      `create_time`, `last_sync_time`, `model`, `os_version`, `device_type`
      and `serial_number`. `desc` may be specified optionally to specify
      results to be sorted in descending order. Default order is ascending.
    pageSize: Optional. The maximum number of Devices to return. If
      unspecified, at most 20 Devices will be returned. The maximum value is
      100; values above 100 will be coerced to 100.
    pageToken: Optional. A page token, received from a previous `ListDevices`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to `ListDevices` must match the call that
      provided the page token.
    view: Optional. The view to use for the List request.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Optional. The view to use for the List request.

    Values:
      VIEW_UNSPECIFIED: Default value. The value is unused.
      COMPANY_INVENTORY: This view contains all devices imported by the
        company admin. Each device in the response contains all information
        specified by the company admin when importing the device (i.e. asset
        tags).
      USER_ASSIGNED_DEVICES: This view contains all devices with at least one
        user registered on the device. Each device in the response contains
        all device information, except for asset tags.
    """
    VIEW_UNSPECIFIED = 0
    COMPANY_INVENTORY = 1
    USER_ASSIGNED_DEVICES = 2

  customer = _messages.StringField(1)
  filter = _messages.StringField(2)
  orderBy = _messages.StringField(3)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)
  view = _messages.EnumField('ViewValueValuesEnum', 6)


class CloudidentityDevicesLockRequest(_messages.Message):
  r"""A CloudidentityDevicesLockRequest object.

  Fields:
    lockDeviceRequest: A LockDeviceRequest resource to be passed as the
      request body.
    name: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}`, where device_id is the unique ID
      assigned to the Device.
  """

  lockDeviceRequest = _messages.MessageField('LockDeviceRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudidentityDevicesPatchRequest(_messages.Message):
  r"""A CloudidentityDevicesPatchRequest object.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
    device: A Device resource to be passed as the request body.
    name: Output only. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}`, where device_id is the unique id
      assigned to the Device.
    name1: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}`, where device_id is the unique ID
      assigned to the Device.
    updateMask: Required. Fully qualified names of fields to update. Only
      "custom_attributes" is supported.
  """

  customer = _messages.StringField(1)
  device = _messages.MessageField('Device', 2)
  name = _messages.StringField(3, required=True)
  name1 = _messages.StringField(4)
  updateMask = _messages.StringField(5)


class CloudidentityDevicesResetPinRequest(_messages.Message):
  r"""A CloudidentityDevicesResetPinRequest object.

  Fields:
    name: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}`, where device_id is the unique ID
      assigned to the Device, and device_user_id is the unique ID assigned to
      the User.
    resetPinRequest: A ResetPinRequest resource to be passed as the request
      body.
  """

  name = _messages.StringField(1, required=True)
  resetPinRequest = _messages.MessageField('ResetPinRequest', 2)


class CloudidentityDevicesRingRequest(_messages.Message):
  r"""A CloudidentityDevicesRingRequest object.

  Fields:
    name: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}/deviceUsers/{device_user_id}`, where
      device_id is the unique ID assigned to the Device, and device_user_id is
      the unique ID assigned to the User.
    ringDeviceRequest: A RingDeviceRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  ringDeviceRequest = _messages.MessageField('RingDeviceRequest', 2)


class CloudidentityDevicesSettingsRequest(_messages.Message):
  r"""A CloudidentityDevicesSettingsRequest object.

  Fields:
    getEffectiveSettingsRequest: A GetEffectiveSettingsRequest resource to be
      passed as the request body.
    resourceId: Resource id of the entity for which the settings are
      requested.
  """

  getEffectiveSettingsRequest = _messages.MessageField('GetEffectiveSettingsRequest', 1)
  resourceId = _messages.StringField(2, required=True)


class CloudidentityDevicesWipeRequest(_messages.Message):
  r"""A CloudidentityDevicesWipeRequest object.

  Fields:
    name: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}/deviceUsers/{device_user_id}`, where
      device_id is the unique ID assigned to the Device, and device_user_id is
      the unique ID assigned to the User.
    wipeDeviceRequest: A WipeDeviceRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  wipeDeviceRequest = _messages.MessageField('WipeDeviceRequest', 2)


class CloudidentityGroupsCreateRequest(_messages.Message):
  r"""A CloudidentityGroupsCreateRequest object.

  Enums:
    InitialGroupConfigValueValuesEnum: Required. The initial configuration
      option for the `Group`.

  Fields:
    group: A Group resource to be passed as the request body.
    initialGroupConfig: Required. The initial configuration option for the
      `Group`.
  """

  class InitialGroupConfigValueValuesEnum(_messages.Enum):
    r"""Required. The initial configuration option for the `Group`.

    Values:
      INITIAL_GROUP_CONFIG_UNSPECIFIED: Default. Should not be used.
      WITH_INITIAL_OWNER: The end user making the request will be added as the
        initial owner of the `Group`.
      EMPTY: An empty group is created without any initial owners. This can
        only be used by admins of the domain.
    """
    INITIAL_GROUP_CONFIG_UNSPECIFIED = 0
    WITH_INITIAL_OWNER = 1
    EMPTY = 2

  group = _messages.MessageField('Group', 1)
  initialGroupConfig = _messages.EnumField('InitialGroupConfigValueValuesEnum', 2)


class CloudidentityGroupsDeleteRequest(_messages.Message):
  r"""A CloudidentityGroupsDeleteRequest object.

  Fields:
    name: Required. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Group` to retrieve. Must be of the form `groups/{group_id}`.
  """

  name = _messages.StringField(1, required=True)


class CloudidentityGroupsGetRequest(_messages.Message):
  r"""A CloudidentityGroupsGetRequest object.

  Fields:
    name: Required. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Group` to retrieve. Must be of the form `groups/{group_id}`.
  """

  name = _messages.StringField(1, required=True)


class CloudidentityGroupsListRequest(_messages.Message):
  r"""A CloudidentityGroupsListRequest object.

  Enums:
    ViewValueValuesEnum: The level of detail to be returned. If unspecified,
      defaults to `View.BASIC`.

  Fields:
    pageSize: The maximum number of results to return. Note that the number of
      results returned may be less than this value even if there are more
      available results. To fetch all results, clients must continue calling
      this method repeatedly until the response no longer contains a
      `next_page_token`. If unspecified, defaults to 200 for `View.BASIC` and
      to 50 for `View.FULL`. Must not be greater than 1000 for `View.BASIC` or
      500 for `View.FULL`.
    pageToken: The `next_page_token` value returned from a previous list
      request, if any.
    parent: Required. The parent resource under which to list all `Group`s.
      Must be of the form `identitysources/{identity_source_id}` for external-
      identity-mapped groups or `customers/{customer_id}` for Google Groups.
    view: The level of detail to be returned. If unspecified, defaults to
      `View.BASIC`.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""The level of detail to be returned. If unspecified, defaults to
    `View.BASIC`.

    Values:
      VIEW_UNSPECIFIED: Default. Should not be used.
      BASIC: Only basic resource information is returned.
      FULL: All resource information is returned.
    """
    VIEW_UNSPECIFIED = 0
    BASIC = 1
    FULL = 2

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class CloudidentityGroupsLookupRequest(_messages.Message):
  r"""A CloudidentityGroupsLookupRequest object.

  Fields:
    groupKey_id: The ID of the entity. For Google-managed entities, the `id`
      must be the email address of an existing group or user. For external-
      identity-mapped entities, the `id` must be a string conforming to the
      Identity Source's requirements. Must be unique within a `namespace`.
    groupKey_namespace: The namespace in which the entity exists. If not
      specified, the `EntityKey` represents a Google-managed entity such as a
      Google user or a Google Group. If specified, the `EntityKey` represents
      an external-identity-mapped group. The namespace must correspond to an
      identity source created in Admin Console and must be in the form of
      `identitysources/{identity_source_id}.
  """

  groupKey_id = _messages.StringField(1)
  groupKey_namespace = _messages.StringField(2)


class CloudidentityGroupsMembershipsCheckTransitiveMembershipRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsCheckTransitiveMembershipRequest object.

  Fields:
    parent: [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the group
      to check the transitive membership in. Format: `groups/{group_id}`,
      where `group_id` is the unique id assigned to the Group to which the
      Membership belongs to.
    query: Required. A CEL expression that MUST include member specification.
      This is a `required` field. Certain groups are uniquely identified by
      both a 'member_key_id' and a 'member_key_namespace', which requires an
      additional query input: 'member_key_namespace'. Example query:
      `member_key_id == 'member_key_id_value'`
  """

  parent = _messages.StringField(1, required=True)
  query = _messages.StringField(2)


class CloudidentityGroupsMembershipsCreateRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsCreateRequest object.

  Fields:
    membership: A Membership resource to be passed as the request body.
    parent: Required. The parent `Group` resource under which to create the
      `Membership`. Must be of the form `groups/{group_id}`.
  """

  membership = _messages.MessageField('Membership', 1)
  parent = _messages.StringField(2, required=True)


class CloudidentityGroupsMembershipsDeleteRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsDeleteRequest object.

  Fields:
    name: Required. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Membership` to delete. Must be of the form
      `groups/{group_id}/memberships/{membership_id}`.
  """

  name = _messages.StringField(1, required=True)


class CloudidentityGroupsMembershipsGetMembershipGraphRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsGetMembershipGraphRequest object.

  Fields:
    parent: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the group
      to search transitive memberships in. Format: `groups/{group_id}`, where
      `group_id` is the unique ID assigned to the Group to which the
      Membership belongs to. group_id can be a wildcard collection id "-".
      When a group_id is specified, the membership graph will be constrained
      to paths between the member (defined in the query) and the parent. If a
      wildcard collection is provided, all membership paths connected to the
      member will be returned.
    query: Required. A CEL expression that MUST include member specification
      AND label(s). Certain groups are uniquely identified by both a
      'member_key_id' and a 'member_key_namespace', which requires an
      additional query input: 'member_key_namespace'. Example query:
      `member_key_id == 'member_key_id_value' && in labels`
  """

  parent = _messages.StringField(1, required=True)
  query = _messages.StringField(2)


class CloudidentityGroupsMembershipsGetRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsGetRequest object.

  Fields:
    name: Required. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Membership` to retrieve. Must be of the form
      `groups/{group_id}/memberships/{membership_id}`.
  """

  name = _messages.StringField(1, required=True)


class CloudidentityGroupsMembershipsListRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsListRequest object.

  Enums:
    ViewValueValuesEnum: The level of detail to be returned. If unspecified,
      defaults to `MembershipView.BASIC`.

  Fields:
    pageSize: The maximum number of results to return. Note that the number of
      results returned may be less than this value even if there are more
      available results. To fetch all results, clients must continue calling
      this method repeatedly until the response no longer contains a
      `next_page_token`. If unspecified, defaults to 200 for `GroupView.BASIC`
      and to 50 for `GroupView.FULL`. Must not be greater than 1000 for
      `GroupView.BASIC` or 500 for `GroupView.FULL`.
    pageToken: The `next_page_token` value returned from a previous search
      request, if any.
    parent: Required. The parent `Group` resource under which to lookup the
      `Membership` name. Must be of the form `groups/{group_id}`.
    view: The level of detail to be returned. If unspecified, defaults to
      `MembershipView.BASIC`.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""The level of detail to be returned. If unspecified, defaults to
    `MembershipView.BASIC`.

    Values:
      BASIC: Default. Only basic resource information is returned.
      FULL: All resource information is returned.
    """
    BASIC = 0
    FULL = 1

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class CloudidentityGroupsMembershipsLookupRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsLookupRequest object.

  Fields:
    memberKey_id: The ID of the entity. For Google-managed entities, the `id`
      must be the email address of an existing group or user. For external-
      identity-mapped entities, the `id` must be a string conforming to the
      Identity Source's requirements. Must be unique within a `namespace`.
    memberKey_namespace: The namespace in which the entity exists. If not
      specified, the `EntityKey` represents a Google-managed entity such as a
      Google user or a Google Group. If specified, the `EntityKey` represents
      an external-identity-mapped group. The namespace must correspond to an
      identity source created in Admin Console and must be in the form of
      `identitysources/{identity_source_id}.
    parent: Required. The parent `Group` resource under which to lookup the
      `Membership` name. Must be of the form `groups/{group_id}`.
  """

  memberKey_id = _messages.StringField(1)
  memberKey_namespace = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudidentityGroupsMembershipsModifyMembershipRolesRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsModifyMembershipRolesRequest object.

  Fields:
    modifyMembershipRolesRequest: A ModifyMembershipRolesRequest resource to
      be passed as the request body.
    name: Required. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Membership` whose roles are to be modified. Must be of the form
      `groups/{group_id}/memberships/{membership_id}`.
  """

  modifyMembershipRolesRequest = _messages.MessageField('ModifyMembershipRolesRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudidentityGroupsMembershipsPatchRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsPatchRequest object.

  Fields:
    membership: A Membership resource to be passed as the request body.
    name: Output only. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Membership`. Shall be of the form
      `groups/{group_id}/memberships/{membership_id}`.
    updateMask: Required. The fully-qualified names of fields to update.
  """

  membership = _messages.MessageField('Membership', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudidentityGroupsMembershipsSearchTransitiveGroupsRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsSearchTransitiveGroupsRequest object.

  Fields:
    pageSize: The default page size is 200 (max 1000).
    pageToken: The next_page_token value returned from a previous list
      request, if any.
    parent: [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the group
      to search transitive memberships in. Format: `groups/{group_id}`, where
      `group_id` is always '-' as this API will search across all groups for a
      given member.
    query: Required. A CEL expression that MUST include member specification
      AND label(s). This is a `required` field. Users can search on label
      attributes of groups. CONTAINS match ('in') is supported on labels.
      Certain groups are uniquely identified by both a 'member_key_id' and a
      'member_key_namespace', which requires an additional query input:
      'member_key_namespace'. Example query: `member_key_id ==
      'member_key_id_value' && in labels`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  query = _messages.StringField(4)


class CloudidentityGroupsMembershipsSearchTransitiveMembershipsRequest(_messages.Message):
  r"""A CloudidentityGroupsMembershipsSearchTransitiveMembershipsRequest
  object.

  Fields:
    pageSize: The default page size is 200 (max 1000).
    pageToken: The next_page_token value returned from a previous list
      request, if any.
    parent: [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the group
      to search transitive memberships in. Format: `groups/{group_id}`, where
      `group_id` is the unique ID assigned to the Group.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudidentityGroupsPatchRequest(_messages.Message):
  r"""A CloudidentityGroupsPatchRequest object.

  Fields:
    group: A Group resource to be passed as the request body.
    name: Output only. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Group`. Shall be of the form `groups/{group_id}`.
    updateMask: Required. The fully-qualified names of fields to update. May
      only contain the following fields: `display_name`, `description`.
  """

  group = _messages.MessageField('Group', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudidentityGroupsSearchRequest(_messages.Message):
  r"""A CloudidentityGroupsSearchRequest object.

  Enums:
    ViewValueValuesEnum: The level of detail to be returned. If unspecified,
      defaults to `View.BASIC`.

  Fields:
    pageSize: The maximum number of results to return. Note that the number of
      results returned may be less than this value even if there are more
      available results. To fetch all results, clients must continue calling
      this method repeatedly until the response no longer contains a
      `next_page_token`. If unspecified, defaults to 200 for `GroupView.BASIC`
      and to 50 for `GroupView.FULL`. Must not be greater than 1000 for
      `GroupView.BASIC` or 500 for `GroupView.FULL`.
    pageToken: The `next_page_token` value returned from a previous search
      request, if any.
    query: Required. The search query. Must be specified in [Common Expression
      Language](https://opensource.google/projects/cel). May only contain
      equality operators on the parent and inclusion operators on labels
      (e.g., `parent == 'customers/{customer_id}' &&
      'cloudidentity.googleapis.com/groups.discussion_forum' in labels`).
    view: The level of detail to be returned. If unspecified, defaults to
      `View.BASIC`.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""The level of detail to be returned. If unspecified, defaults to
    `View.BASIC`.

    Values:
      BASIC: Default. Only basic resource information is returned.
      FULL: All resource information is returned.
    """
    BASIC = 0
    FULL = 1

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  query = _messages.StringField(3)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class CollectBugReportRequest(_messages.Message):
  r"""Request message for collecting the bugreport for the user.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
  """

  customer = _messages.StringField(1)


class CreateDeviceRequest(_messages.Message):
  r"""Request message for creating a Company Owned device.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
    device: Required. The device to be created. The name field within this
      device is ignored in the create method. A new name is created by the
      method, and returned within the response. Only the fields `device_type`,
      `serial_number` and `asset_tag` (if present) are used to create the
      device.`device_type` and `serial_number` are required.
  """

  customer = _messages.StringField(1)
  device = _messages.MessageField('Device', 2)


class CustomAttributeValue(_messages.Message):
  r"""Additional custom attribute values may be one of these types

  Fields:
    boolValue: Represents a boolean value.
    numberValue: Represents a double value.
    stringValue: Represents a string value.
  """

  boolValue = _messages.BooleanField(1)
  numberValue = _messages.FloatField(2)
  stringValue = _messages.StringField(3)


class Device(_messages.Message):
  r"""A Device within the Cloud Identity Devices API. Represents a Device
  known to Google Cloud, independent of the device ownership, type, and
  whether it is assigned or in use by a user.

  Enums:
    CompromisedStateValueValuesEnum: Output only. Represents whether the
      Device is compromised.
    DeviceTypeValueValuesEnum: Output only. Type of device.
    EncryptionStateValueValuesEnum: Output only. Device encryption state.
    ManagementStateValueValuesEnum: Output only. Management state of the
      device
    OwnerTypeValueValuesEnum: Output only. Whether the device is owned by the
      company or an individual

  Fields:
    androidSpecificAttributes: Output only. Attributes specific to Android
      devices.
    assetTag: Asset tag of the device.
    basebandVersion: Output only. Baseband version of the device.
    bootloaderVersion: Output only. Device bootloader version. Example: 0.6.7.
    brand: Output only. Device brand. Example: Samsung.
    buildNumber: Output only. Build number of the device.
    compromisedState: Output only. Represents whether the Device is
      compromised.
    createTime: Output only. When the Company-Owned device was imported. This
      field is empty for BYOD devices.
    deviceType: Output only. Type of device.
    enabledDeveloperOptions: Output only. Whether developer options is enabled
      on device.
    enabledUsbDebugging: Output only. Whether USB debugging is enabled on
      device.
    encryptionState: Output only. Device encryption state.
    imei: Output only. IMEI number of device if GSM device; empty otherwise.
    kernelVersion: Output only. Kernel version of the device.
    lastSyncTime: Most recent time when device synced with this service.
    managementState: Output only. Management state of the device
    manufacturer: Output only. Device manufacturer. Example: Motorola.
    meid: Output only. MEID number of device if CDMA device; empty otherwise.
    model: Output only. Model name of device. Example: Pixel 3.
    name: Output only. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}`, where device_id is the unique id
      assigned to the Device.
    networkOperator: Output only. Mobile or network operator of device, if
      available.
    osVersion: Output only. OS version of the device. Example: Android 8.1.0.
    otherAccounts: Output only. Domain name for Google accounts on device.
      Type for other accounts on device. On Android, will only be populated if
      |ownership_privilege| is |PROFILE_OWNER| or |DEVICE_OWNER|. Does not
      include the account signed in to the device policy app if that account's
      domain has only one account. Examples: "com.example", "xyz.com".
    ownerType: Output only. Whether the device is owned by the company or an
      individual
    releaseVersion: Output only. OS release version. Example: 6.0.
    securityPatchTime: Output only. OS security patch update time on device.
    serialNumber: Serial Number of device. Example: HT82V1A01076.
    wifiMacAddresses: WiFi MAC addresses of device.
  """

  class CompromisedStateValueValuesEnum(_messages.Enum):
    r"""Output only. Represents whether the Device is compromised.

    Values:
      COMPROMISED_STATE_UNSPECIFIED: Default value.
      COMPROMISED: The device is compromised (currently, this means Android
        device is rooted).
      UNCOMPROMISED: The device is safe (currently, this means Android device
        is unrooted).
    """
    COMPROMISED_STATE_UNSPECIFIED = 0
    COMPROMISED = 1
    UNCOMPROMISED = 2

  class DeviceTypeValueValuesEnum(_messages.Enum):
    r"""Output only. Type of device.

    Values:
      DEVICE_TYPE_UNSPECIFIED: Unknown device type
      ANDROID: Device is an Android device
      IOS: Device is an iOS device
      GOOGLE_SYNC: Device is a Google Sync device.
      WINDOWS: Device is a Windows device.
      MAC_OS: Device is a MacOS device.
      LINUX: Device is a Linux device.
      CHROME_OS: Device is a ChromeOS device.
    """
    DEVICE_TYPE_UNSPECIFIED = 0
    ANDROID = 1
    IOS = 2
    GOOGLE_SYNC = 3
    WINDOWS = 4
    MAC_OS = 5
    LINUX = 6
    CHROME_OS = 7

  class EncryptionStateValueValuesEnum(_messages.Enum):
    r"""Output only. Device encryption state.

    Values:
      ENCRYPTION_STATE_UNSPECIFIED: Encryption Status is not set.
      UNSUPPORTED_BY_DEVICE: Device doesn't support encryption.
      ENCRYPTED: Device is encrypted.
      NOT_ENCRYPTED: Device is not encrypted.
    """
    ENCRYPTION_STATE_UNSPECIFIED = 0
    UNSUPPORTED_BY_DEVICE = 1
    ENCRYPTED = 2
    NOT_ENCRYPTED = 3

  class ManagementStateValueValuesEnum(_messages.Enum):
    r"""Output only. Management state of the device

    Values:
      MANAGEMENT_STATE_UNSPECIFIED: Default value. This value is unused.
      APPROVED: Device is approved.
      BLOCKED: Device is blocked.
      PENDING: Device is pending approval.
      UNPROVISIONED: The device is not provisioned. Device will start from
        this state until some action is taken (i.e. a user starts using the
        device).
      WIPING: Data and settings on the device are being removed.
      WIPED: All data and settings on the device are removed.
    """
    MANAGEMENT_STATE_UNSPECIFIED = 0
    APPROVED = 1
    BLOCKED = 2
    PENDING = 3
    UNPROVISIONED = 4
    WIPING = 5
    WIPED = 6

  class OwnerTypeValueValuesEnum(_messages.Enum):
    r"""Output only. Whether the device is owned by the company or an
    individual

    Values:
      DEVICE_OWNERSHIP_UNSPECIFIED: Default value. The value is unused.
      COMPANY: Company owns the device.
      BYOD: Bring Your Own Device (i.e. individual owns the device)
    """
    DEVICE_OWNERSHIP_UNSPECIFIED = 0
    COMPANY = 1
    BYOD = 2

  androidSpecificAttributes = _messages.MessageField('AndroidAttributes', 1)
  assetTag = _messages.StringField(2)
  basebandVersion = _messages.StringField(3)
  bootloaderVersion = _messages.StringField(4)
  brand = _messages.StringField(5)
  buildNumber = _messages.StringField(6)
  compromisedState = _messages.EnumField('CompromisedStateValueValuesEnum', 7)
  createTime = _messages.StringField(8)
  deviceType = _messages.EnumField('DeviceTypeValueValuesEnum', 9)
  enabledDeveloperOptions = _messages.BooleanField(10)
  enabledUsbDebugging = _messages.BooleanField(11)
  encryptionState = _messages.EnumField('EncryptionStateValueValuesEnum', 12)
  imei = _messages.StringField(13)
  kernelVersion = _messages.StringField(14)
  lastSyncTime = _messages.StringField(15)
  managementState = _messages.EnumField('ManagementStateValueValuesEnum', 16)
  manufacturer = _messages.StringField(17)
  meid = _messages.StringField(18)
  model = _messages.StringField(19)
  name = _messages.StringField(20)
  networkOperator = _messages.StringField(21)
  osVersion = _messages.StringField(22)
  otherAccounts = _messages.StringField(23, repeated=True)
  ownerType = _messages.EnumField('OwnerTypeValueValuesEnum', 24)
  releaseVersion = _messages.StringField(25)
  securityPatchTime = _messages.StringField(26)
  serialNumber = _messages.StringField(27)
  wifiMacAddresses = _messages.StringField(28, repeated=True)


class DeviceUser(_messages.Message):
  r"""Represents a user's use of a Device in the Cloud Identity Devices API. A
  DeviceUser is a resource representing a user's use of a Device

  Enums:
    CompromisedStateValueValuesEnum: Compromised State of the DeviceUser
      object
    ManagementStateValueValuesEnum: Output only. Management state of the user
      on the device.
    PasswordStateValueValuesEnum: Password state of the DeviceUser object

  Fields:
    compromisedState: Compromised State of the DeviceUser object
    createTime: When the user first signed in to the device
    firstSyncTime: Output only. Most recent time when user registered with
      this service.
    languageCode: Output only. Default locale used on device, in IETF BCP-47
      format.
    lastSyncTime: Output only. Last time when user synced with policies.
    managementState: Output only. Management state of the user on the device.
    name: Output only. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      DeviceUser in format: `devices/{device_id}/deviceUsers/{user_id}`, where
      user_id is the ID of the user associated with the user session.
    passwordState: Password state of the DeviceUser object
    userAgent: Output only. User agent on the device for this specific user
    userEmail: Email address of the user registered on the device.
  """

  class CompromisedStateValueValuesEnum(_messages.Enum):
    r"""Compromised State of the DeviceUser object

    Values:
      COMPROMISED_STATE_UNSPECIFIED: Compromised state of Device User account
        is unknown or unspecified.
      COMPROMISED: Device User Account is compromised.
      NOT_COMPROMISED: Device User Account is not compromised.
    """
    COMPROMISED_STATE_UNSPECIFIED = 0
    COMPROMISED = 1
    NOT_COMPROMISED = 2

  class ManagementStateValueValuesEnum(_messages.Enum):
    r"""Output only. Management state of the user on the device.

    Values:
      MANAGEMENT_STATE_UNSPECIFIED: Default value. This value is unused.
      WIPING: This user's data and profile is being removed from the device.
      WIPED: This user's data and profile is removed from the device.
      APPROVED: User is approved to access data on the device.
      BLOCKED: User is blocked from accessing data on the device.
      PENDING_APPROVAL: User is awaiting approval.
      UNENROLLED: User is unenrolled from Advanced Windows Management, but the
        Windows account is still intact.
    """
    MANAGEMENT_STATE_UNSPECIFIED = 0
    WIPING = 1
    WIPED = 2
    APPROVED = 3
    BLOCKED = 4
    PENDING_APPROVAL = 5
    UNENROLLED = 6

  class PasswordStateValueValuesEnum(_messages.Enum):
    r"""Password state of the DeviceUser object

    Values:
      PASSWORD_STATE_UNSPECIFIED: Password state not set.
      PASSWORD_SET: Password set in object.
      PASSWORD_NOT_SET: Password not set in object.
    """
    PASSWORD_STATE_UNSPECIFIED = 0
    PASSWORD_SET = 1
    PASSWORD_NOT_SET = 2

  compromisedState = _messages.EnumField('CompromisedStateValueValuesEnum', 1)
  createTime = _messages.StringField(2)
  firstSyncTime = _messages.StringField(3)
  languageCode = _messages.StringField(4)
  lastSyncTime = _messages.StringField(5)
  managementState = _messages.EnumField('ManagementStateValueValuesEnum', 6)
  name = _messages.StringField(7)
  passwordState = _messages.EnumField('PasswordStateValueValuesEnum', 8)
  userAgent = _messages.StringField(9)
  userEmail = _messages.StringField(10)


class DynamicGroupMetadata(_messages.Message):
  r"""Dynamic group metadata like queries and status.

  Fields:
    queries: Memberships will be the union of all queries. Only one entry with
      USER resource is currently supported.
    status: Output only. Status of the dynamic group.
  """

  queries = _messages.MessageField('DynamicGroupQuery', 1, repeated=True)
  status = _messages.MessageField('DynamicGroupStatus', 2)


class DynamicGroupQuery(_messages.Message):
  r"""Defines a query on a resource.

  Enums:
    ResourceTypeValueValuesEnum:

  Fields:
    query: Query that determines the memberships of the dynamic group.
      Examples: All users with at least one `organizations.department` of
      engineering. `user.organizations.exists(org,
      org.department=='engineering')` All users with at least one location
      that has `area` of `foo` and `building_id` of `bar`.
      `user.locations.exists(loc, loc.area=='foo' && loc.building_id=='bar')`
    resourceType: A ResourceTypeValueValuesEnum attribute.
  """

  class ResourceTypeValueValuesEnum(_messages.Enum):
    r"""ResourceTypeValueValuesEnum enum type.

    Values:
      RESOURCE_TYPE_UNSPECIFIED: Default value (not valid)
      USER: For queries on User
      TEAM_DRIVE: For queries on Team Drive
    """
    RESOURCE_TYPE_UNSPECIFIED = 0
    USER = 1
    TEAM_DRIVE = 2

  query = _messages.StringField(1)
  resourceType = _messages.EnumField('ResourceTypeValueValuesEnum', 2)


class DynamicGroupStatus(_messages.Message):
  r"""The current status of a dynamic group along with timestamp.

  Enums:
    StatusValueValuesEnum: Status of the dynamic group.

  Fields:
    status: Status of the dynamic group.
    statusTime: The latest time at which the dynamic group is guaranteed to be
      in the given status. If status is `UP_TO_DATE`, the latest time at which
      the dynamic group was confirmed to be up-to-date. If status is
      `UPDATING_MEMBERSHIPS`, the time at which dynamic group was created.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""Status of the dynamic group.

    Values:
      STATUS_UNSPECIFIED: Default.
      UP_TO_DATE: The dynamic group is up-to-date.
      UPDATING_MEMBERSHIPS: The dynamic group has just been created and
        memberships are being updated.
    """
    STATUS_UNSPECIFIED = 0
    UP_TO_DATE = 1
    UPDATING_MEMBERSHIPS = 2

  status = _messages.EnumField('StatusValueValuesEnum', 1)
  statusTime = _messages.StringField(2)


class EffectiveSetting(_messages.Message):
  r"""A EffectiveSetting object.

  Fields:
    mamDataProtectionSetting: A MamDataProtectionSetting attribute.
  """

  mamDataProtectionSetting = _messages.MessageField('MamDataProtectionSetting', 1)


class EntityKey(_messages.Message):
  r"""A unique identifier for an entity in the Cloud Identity Groups API. An
  entity can represent either a group with an optional `namespace` or a user
  without a `namespace`. The combination of `id` and `namespace` must be
  unique; however, the same `id` can be used with different `namespace`s.

  Fields:
    id: The ID of the entity. For Google-managed entities, the `id` must be
      the email address of an existing group or user. For external-identity-
      mapped entities, the `id` must be a string conforming to the Identity
      Source's requirements. Must be unique within a `namespace`.
    namespace: The namespace in which the entity exists. If not specified, the
      `EntityKey` represents a Google-managed entity such as a Google user or
      a Google Group. If specified, the `EntityKey` represents an external-
      identity-mapped group. The namespace must correspond to an identity
      source created in Admin Console and must be in the form of
      `identitysources/{identity_source_id}.
  """

  id = _messages.StringField(1)
  namespace = _messages.StringField(2)


class ExpiryDetail(_messages.Message):
  r"""The `MembershipRole` expiry details.

  Fields:
    expireTime: The time at which the `MembershipRole` will expire.
  """

  expireTime = _messages.StringField(1)


class GetEffectiveSettingsRequest(_messages.Message):
  r"""A GetEffectiveSettingsRequest object.

  Fields:
    clientContext: Context of the caller client.
  """

  clientContext = _messages.MessageField('ClientContext', 1)


class GetEffectiveSettingsResponse(_messages.Message):
  r"""A GetEffectiveSettingsResponse object.

  Fields:
    effectiveSetting: A EffectiveSetting attribute.
    resourceId: Resource id of the device.
  """

  effectiveSetting = _messages.MessageField('EffectiveSetting', 1)
  resourceId = _messages.StringField(2)


class GetMembershipGraphResponse(_messages.Message):
  r"""The response message for MembershipsService.GetMembershipGraph.

  Fields:
    adjacencyList: The membership graph's path information represented as an
      adjacency list.
    groups: The resources representing each group in the adjacency list. Each
      group in this list can be correlated to a 'group' of the
      MembershipAdjacencyList using the 'name' of the Group resource.
  """

  adjacencyList = _messages.MessageField('MembershipAdjacencyList', 1, repeated=True)
  groups = _messages.MessageField('Group', 2, repeated=True)


class GoogleAppsCloudidentityDevicesV1AndroidAttributes(_messages.Message):
  r"""Resource representing the Android specific attributes of a Device.

  Enums:
    OwnershipPrivilegeValueValuesEnum: Ownership privileges on device.

  Fields:
    enabledUnknownSources: Whether applications from unknown sources can be
      installed on device.
    ownerProfileAccount: Whether this account is on an owner/primary profile.
      For phones, only true for owner profiles. Android 4+ devices can have
      secondary or restricted user profiles.
    ownershipPrivilege: Ownership privileges on device.
    supportsWorkProfile: Whether device supports Android work profiles. If
      false, this service will not block access to corp data even if an
      administrator turns on the "Enforce Work Profile" policy.
  """

  class OwnershipPrivilegeValueValuesEnum(_messages.Enum):
    r"""Ownership privileges on device.

    Values:
      OWNERSHIP_PRIVILEGE_UNSPECIFIED: Ownership privilege is not set.
      DEVICE_ADMINISTRATOR: Active device administrator privileges on the
        device.
      PROFILE_OWNER: Profile Owner privileges. The account is in a managed
        corporate profile.
      DEVICE_OWNER: Device Owner privileges on the device.
    """
    OWNERSHIP_PRIVILEGE_UNSPECIFIED = 0
    DEVICE_ADMINISTRATOR = 1
    PROFILE_OWNER = 2
    DEVICE_OWNER = 3

  enabledUnknownSources = _messages.BooleanField(1)
  ownerProfileAccount = _messages.BooleanField(2)
  ownershipPrivilege = _messages.EnumField('OwnershipPrivilegeValueValuesEnum', 3)
  supportsWorkProfile = _messages.BooleanField(4)


class GoogleAppsCloudidentityDevicesV1ApproveDeviceUserResponse(_messages.Message):
  r"""Response message for approving the device to access user data.

  Fields:
    deviceUser: Resultant DeviceUser object for the action.
  """

  deviceUser = _messages.MessageField('GoogleAppsCloudidentityDevicesV1DeviceUser', 1)


class GoogleAppsCloudidentityDevicesV1BlockDeviceUserResponse(_messages.Message):
  r"""Response message for blocking the device from accessing user data.

  Fields:
    deviceUser: Resultant DeviceUser object for the action.
  """

  deviceUser = _messages.MessageField('GoogleAppsCloudidentityDevicesV1DeviceUser', 1)


class GoogleAppsCloudidentityDevicesV1CancelWipeDeviceResponse(_messages.Message):
  r"""Response message for cancelling an unfinished device wipe.

  Fields:
    device: Resultant Device object for the action. Note that asset tags will
      not be returned in the device object.
  """

  device = _messages.MessageField('GoogleAppsCloudidentityDevicesV1Device', 1)


class GoogleAppsCloudidentityDevicesV1CancelWipeDeviceUserResponse(_messages.Message):
  r"""Response message for cancelling an unfinished user account wipe.

  Fields:
    deviceUser: Resultant DeviceUser object for the action.
  """

  deviceUser = _messages.MessageField('GoogleAppsCloudidentityDevicesV1DeviceUser', 1)


class GoogleAppsCloudidentityDevicesV1ClientState(_messages.Message):
  r"""Represents the state associated with an API client calling the Devices
  API. Resource representing ClientState and supports updates from API users

  Enums:
    ComplianceStateValueValuesEnum: The compliance state of the resource as
      specified by the API client.
    HealthScoreValueValuesEnum: The Health score of the resource. The Health
      score is the callers specification of the condition of the device from a
      usability point of view. For example, a third-party device management
      provider may specify a health score based on its compliance with
      organizational policies.
    ManagedValueValuesEnum: The management state of the resource as specified
      by the API client.
    OwnerTypeValueValuesEnum: Output only. The owner of the ClientState

  Messages:
    KeyValuePairsValue: The map of key-value attributes stored by callers
      specific to a device. The total serialized length of this map may not
      exceed 10KB. No limit is placed on the number of attributes in a map.

  Fields:
    assetTags: The caller can specify asset tags for this resource
    complianceState: The compliance state of the resource as specified by the
      API client.
    createTime: Output only. The time the client state data was created.
    customId: This field may be used to store a unique identifier for the API
      resource within which these CustomAttributes are a field.
    etag: The token that needs to be passed back for concurrency control in
      updates. Token needs to be passed back in UpdateRequest
    healthScore: The Health score of the resource. The Health score is the
      callers specification of the condition of the device from a usability
      point of view. For example, a third-party device management provider may
      specify a health score based on its compliance with organizational
      policies.
    keyValuePairs: The map of key-value attributes stored by callers specific
      to a device. The total serialized length of this map may not exceed
      10KB. No limit is placed on the number of attributes in a map.
    lastUpdateTime: Output only. The time the client state data was last
      updated.
    managed: The management state of the resource as specified by the API
      client.
    name: Output only. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      ClientState in format: `devices/{device_id}/deviceUsers/{device_user_id}
      /clientState/{partner_id}`, where partner_id corresponds to the partner
      storing the data. For partners belonging to the "BeyondCorp Alliance",
      this is the partner ID specified to you by Google. For all other
      callers, this is a string of the form: `{customer_id}-suffix`, where
      `customer_id` is your customer ID. The *suffix* is any string the caller
      specifies. This string will be displayed verbatim in the administration
      console. This suffix is used in setting up Custom Access Levels in
      Context-Aware Access. Your organization's customer ID can be obtained
      from the URL: `GET
      https://www.googleapis.com/admin/directory/v1/customers/my_customer` The
      `id` field in the response contains the customer ID starting with the
      letter 'C'. The customer ID to be used in this API is the string after
      the letter 'C' (not including 'C')
    ownerType: Output only. The owner of the ClientState
    scoreReason: A descriptive cause of the health score.
  """

  class ComplianceStateValueValuesEnum(_messages.Enum):
    r"""The compliance state of the resource as specified by the API client.

    Values:
      COMPLIANCE_STATE_UNSPECIFIED: The compliance state of the resource is
        unknown or unspecified.
      COMPLIANT: Device is compliant with third party policies
      NON_COMPLIANT: Device is not compliant with third party policies
    """
    COMPLIANCE_STATE_UNSPECIFIED = 0
    COMPLIANT = 1
    NON_COMPLIANT = 2

  class HealthScoreValueValuesEnum(_messages.Enum):
    r"""The Health score of the resource. The Health score is the callers
    specification of the condition of the device from a usability point of
    view. For example, a third-party device management provider may specify a
    health score based on its compliance with organizational policies.

    Values:
      HEALTH_SCORE_UNSPECIFIED: Default value
      VERY_POOR: The object is in very poor health as defined by the caller.
      POOR: The object is in poor health as defined by the caller.
      NEUTRAL: The object health is neither good nor poor, as defined by the
        caller.
      GOOD: The object is in good health as defined by the caller.
      VERY_GOOD: The object is in very good health as defined by the caller.
    """
    HEALTH_SCORE_UNSPECIFIED = 0
    VERY_POOR = 1
    POOR = 2
    NEUTRAL = 3
    GOOD = 4
    VERY_GOOD = 5

  class ManagedValueValuesEnum(_messages.Enum):
    r"""The management state of the resource as specified by the API client.

    Values:
      MANAGED_STATE_UNSPECIFIED: The management state of the resource is
        unknown or unspecified.
      MANAGED: The resource is managed.
      UNMANAGED: The resource is not managed.
    """
    MANAGED_STATE_UNSPECIFIED = 0
    MANAGED = 1
    UNMANAGED = 2

  class OwnerTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The owner of the ClientState

    Values:
      OWNER_TYPE_UNSPECIFIED: Unknown owner type
      OWNER_TYPE_CUSTOMER: Customer is the owner
      OWNER_TYPE_PARTNER: Partner is the owner
    """
    OWNER_TYPE_UNSPECIFIED = 0
    OWNER_TYPE_CUSTOMER = 1
    OWNER_TYPE_PARTNER = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class KeyValuePairsValue(_messages.Message):
    r"""The map of key-value attributes stored by callers specific to a
    device. The total serialized length of this map may not exceed 10KB. No
    limit is placed on the number of attributes in a map.

    Messages:
      AdditionalProperty: An additional property for a KeyValuePairsValue
        object.

    Fields:
      additionalProperties: Additional properties of type KeyValuePairsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a KeyValuePairsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleAppsCloudidentityDevicesV1CustomAttributeValue
          attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleAppsCloudidentityDevicesV1CustomAttributeValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  assetTags = _messages.StringField(1, repeated=True)
  complianceState = _messages.EnumField('ComplianceStateValueValuesEnum', 2)
  createTime = _messages.StringField(3)
  customId = _messages.StringField(4)
  etag = _messages.StringField(5)
  healthScore = _messages.EnumField('HealthScoreValueValuesEnum', 6)
  keyValuePairs = _messages.MessageField('KeyValuePairsValue', 7)
  lastUpdateTime = _messages.StringField(8)
  managed = _messages.EnumField('ManagedValueValuesEnum', 9)
  name = _messages.StringField(10)
  ownerType = _messages.EnumField('OwnerTypeValueValuesEnum', 11)
  scoreReason = _messages.StringField(12)


class GoogleAppsCloudidentityDevicesV1CustomAttributeValue(_messages.Message):
  r"""Additional custom attribute values may be one of these types

  Fields:
    boolValue: Represents a boolean value.
    numberValue: Represents a double value.
    stringValue: Represents a string value.
  """

  boolValue = _messages.BooleanField(1)
  numberValue = _messages.FloatField(2)
  stringValue = _messages.StringField(3)


class GoogleAppsCloudidentityDevicesV1Device(_messages.Message):
  r""" A Device within the Cloud Identity Devices API. Represents a Device
  known to Google Cloud, independent of the device ownership, type, and
  whether it is assigned or in use by a user.

  Enums:
    CompromisedStateValueValuesEnum: Output only. Represents whether the
      Device is compromised.
    DeviceTypeValueValuesEnum: Output only. Type of device.
    EncryptionStateValueValuesEnum: Output only. Device encryption state.
    ManagementStateValueValuesEnum: Output only. Management state of the
      device
    OwnerTypeValueValuesEnum: Output only. Whether the device is owned by the
      company or an individual

  Fields:
    androidSpecificAttributes: Output only. Attributes specific to Android
      devices.
    assetTag: Asset tag of the device.
    basebandVersion: Output only. Baseband version of the device.
    bootloaderVersion: Output only. Device bootloader version. Example: 0.6.7.
    brand: Output only. Device brand. Example: Samsung.
    buildNumber: Output only. Build number of the device.
    compromisedState: Output only. Represents whether the Device is
      compromised.
    createTime: Output only. When the Company-Owned device was imported. This
      field is empty for BYOD devices.
    deviceType: Output only. Type of device.
    enabledDeveloperOptions: Output only. Whether developer options is enabled
      on device.
    enabledUsbDebugging: Output only. Whether USB debugging is enabled on
      device.
    encryptionState: Output only. Device encryption state.
    imei: Output only. IMEI number of device if GSM device; empty otherwise.
    kernelVersion: Output only. Kernel version of the device.
    lastSyncTime: Most recent time when device synced with this service.
    managementState: Output only. Management state of the device
    manufacturer: Output only. Device manufacturer. Example: Motorola.
    meid: Output only. MEID number of device if CDMA device; empty otherwise.
    model: Output only. Model name of device. Example: Pixel 3.
    name: Output only. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the Device
      in format: `devices/{device_id}`, where device_id is the unique id
      assigned to the Device.
    networkOperator: Output only. Mobile or network operator of device, if
      available.
    osVersion: Output only. OS version of the device. Example: Android 8.1.0.
    otherAccounts: Output only. Domain name for Google accounts on device.
      Type for other accounts on device. On Android, will only be populated if
      |ownership_privilege| is |PROFILE_OWNER| or |DEVICE_OWNER|. Does not
      include the account signed in to the device policy app if that account's
      domain has only one account. Examples: "com.example", "xyz.com".
    ownerType: Output only. Whether the device is owned by the company or an
      individual
    releaseVersion: Output only. OS release version. Example: 6.0.
    securityPatchTime: Output only. OS security patch update time on device.
    serialNumber: Serial Number of device. Example: HT82V1A01076.
    wifiMacAddresses: WiFi MAC addresses of device.
  """

  class CompromisedStateValueValuesEnum(_messages.Enum):
    r"""Output only. Represents whether the Device is compromised.

    Values:
      COMPROMISED_STATE_UNSPECIFIED: Default value.
      COMPROMISED: The device is compromised (currently, this means Android
        device is rooted).
      UNCOMPROMISED: The device is safe (currently, this means Android device
        is unrooted).
    """
    COMPROMISED_STATE_UNSPECIFIED = 0
    COMPROMISED = 1
    UNCOMPROMISED = 2

  class DeviceTypeValueValuesEnum(_messages.Enum):
    r"""Output only. Type of device.

    Values:
      DEVICE_TYPE_UNSPECIFIED: Unknown device type
      ANDROID: Device is an Android device
      IOS: Device is an iOS device
      GOOGLE_SYNC: Device is a Google Sync device.
      WINDOWS: Device is a Windows device.
      MAC_OS: Device is a MacOS device.
      LINUX: Device is a Linux device.
      CHROME_OS: Device is a ChromeOS device.
    """
    DEVICE_TYPE_UNSPECIFIED = 0
    ANDROID = 1
    IOS = 2
    GOOGLE_SYNC = 3
    WINDOWS = 4
    MAC_OS = 5
    LINUX = 6
    CHROME_OS = 7

  class EncryptionStateValueValuesEnum(_messages.Enum):
    r"""Output only. Device encryption state.

    Values:
      ENCRYPTION_STATE_UNSPECIFIED: Encryption Status is not set.
      UNSUPPORTED_BY_DEVICE: Device doesn't support encryption.
      ENCRYPTED: Device is encrypted.
      NOT_ENCRYPTED: Device is not encrypted.
    """
    ENCRYPTION_STATE_UNSPECIFIED = 0
    UNSUPPORTED_BY_DEVICE = 1
    ENCRYPTED = 2
    NOT_ENCRYPTED = 3

  class ManagementStateValueValuesEnum(_messages.Enum):
    r"""Output only. Management state of the device

    Values:
      MANAGEMENT_STATE_UNSPECIFIED: Default value. This value is unused.
      APPROVED: Device is approved.
      BLOCKED: Device is blocked.
      PENDING: Device is pending approval.
      UNPROVISIONED: The device is not provisioned. Device will start from
        this state until some action is taken (i.e. a user starts using the
        device).
      WIPING: Data and settings on the device are being removed.
      WIPED: All data and settings on the device are removed.
    """
    MANAGEMENT_STATE_UNSPECIFIED = 0
    APPROVED = 1
    BLOCKED = 2
    PENDING = 3
    UNPROVISIONED = 4
    WIPING = 5
    WIPED = 6

  class OwnerTypeValueValuesEnum(_messages.Enum):
    r"""Output only. Whether the device is owned by the company or an
    individual

    Values:
      DEVICE_OWNERSHIP_UNSPECIFIED: Default value. The value is unused.
      COMPANY: Company owns the device.
      BYOD: Bring Your Own Device (i.e. individual owns the device)
    """
    DEVICE_OWNERSHIP_UNSPECIFIED = 0
    COMPANY = 1
    BYOD = 2

  androidSpecificAttributes = _messages.MessageField('GoogleAppsCloudidentityDevicesV1AndroidAttributes', 1)
  assetTag = _messages.StringField(2)
  basebandVersion = _messages.StringField(3)
  bootloaderVersion = _messages.StringField(4)
  brand = _messages.StringField(5)
  buildNumber = _messages.StringField(6)
  compromisedState = _messages.EnumField('CompromisedStateValueValuesEnum', 7)
  createTime = _messages.StringField(8)
  deviceType = _messages.EnumField('DeviceTypeValueValuesEnum', 9)
  enabledDeveloperOptions = _messages.BooleanField(10)
  enabledUsbDebugging = _messages.BooleanField(11)
  encryptionState = _messages.EnumField('EncryptionStateValueValuesEnum', 12)
  imei = _messages.StringField(13)
  kernelVersion = _messages.StringField(14)
  lastSyncTime = _messages.StringField(15)
  managementState = _messages.EnumField('ManagementStateValueValuesEnum', 16)
  manufacturer = _messages.StringField(17)
  meid = _messages.StringField(18)
  model = _messages.StringField(19)
  name = _messages.StringField(20)
  networkOperator = _messages.StringField(21)
  osVersion = _messages.StringField(22)
  otherAccounts = _messages.StringField(23, repeated=True)
  ownerType = _messages.EnumField('OwnerTypeValueValuesEnum', 24)
  releaseVersion = _messages.StringField(25)
  securityPatchTime = _messages.StringField(26)
  serialNumber = _messages.StringField(27)
  wifiMacAddresses = _messages.StringField(28, repeated=True)


class GoogleAppsCloudidentityDevicesV1DeviceUser(_messages.Message):
  r"""Represents a user's use of a Device in the Cloud Identity Devices API. A
  DeviceUser is a resource representing a user's use of a Device

  Enums:
    CompromisedStateValueValuesEnum: Compromised State of the DeviceUser
      object
    ManagementStateValueValuesEnum: Output only. Management state of the user
      on the device.
    PasswordStateValueValuesEnum: Password state of the DeviceUser object

  Fields:
    compromisedState: Compromised State of the DeviceUser object
    createTime: When the user first signed in to the device
    firstSyncTime: Output only. Most recent time when user registered with
      this service.
    languageCode: Output only. Default locale used on device, in IETF BCP-47
      format.
    lastSyncTime: Output only. Last time when user synced with policies.
    managementState: Output only. Management state of the user on the device.
    name: Output only. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      DeviceUser in format: `devices/{device_id}/deviceUsers/{user_id}`, where
      user_id is the ID of the user associated with the user session.
    passwordState: Password state of the DeviceUser object
    userAgent: Output only. User agent on the device for this specific user
    userEmail: Email address of the user registered on the device.
  """

  class CompromisedStateValueValuesEnum(_messages.Enum):
    r"""Compromised State of the DeviceUser object

    Values:
      COMPROMISED_STATE_UNSPECIFIED: Compromised state of Device User account
        is unknown or unspecified.
      COMPROMISED: Device User Account is compromised.
      NOT_COMPROMISED: Device User Account is not compromised.
    """
    COMPROMISED_STATE_UNSPECIFIED = 0
    COMPROMISED = 1
    NOT_COMPROMISED = 2

  class ManagementStateValueValuesEnum(_messages.Enum):
    r"""Output only. Management state of the user on the device.

    Values:
      MANAGEMENT_STATE_UNSPECIFIED: Default value. This value is unused.
      WIPING: This user's data and profile is being removed from the device.
      WIPED: This user's data and profile is removed from the device.
      APPROVED: User is approved to access data on the device.
      BLOCKED: User is blocked from accessing data on the device.
      PENDING_APPROVAL: User is awaiting approval.
      UNENROLLED: User is unenrolled from Advanced Windows Management, but the
        Windows account is still intact.
    """
    MANAGEMENT_STATE_UNSPECIFIED = 0
    WIPING = 1
    WIPED = 2
    APPROVED = 3
    BLOCKED = 4
    PENDING_APPROVAL = 5
    UNENROLLED = 6

  class PasswordStateValueValuesEnum(_messages.Enum):
    r"""Password state of the DeviceUser object

    Values:
      PASSWORD_STATE_UNSPECIFIED: Password state not set.
      PASSWORD_SET: Password set in object.
      PASSWORD_NOT_SET: Password not set in object.
    """
    PASSWORD_STATE_UNSPECIFIED = 0
    PASSWORD_SET = 1
    PASSWORD_NOT_SET = 2

  compromisedState = _messages.EnumField('CompromisedStateValueValuesEnum', 1)
  createTime = _messages.StringField(2)
  firstSyncTime = _messages.StringField(3)
  languageCode = _messages.StringField(4)
  lastSyncTime = _messages.StringField(5)
  managementState = _messages.EnumField('ManagementStateValueValuesEnum', 6)
  name = _messages.StringField(7)
  passwordState = _messages.EnumField('PasswordStateValueValuesEnum', 8)
  userAgent = _messages.StringField(9)
  userEmail = _messages.StringField(10)


class GoogleAppsCloudidentityDevicesV1WipeDeviceResponse(_messages.Message):
  r"""Response message for wiping all data on the device.

  Fields:
    device: Resultant Device object for the action. Note that asset tags will
      not be returned in the device object.
  """

  device = _messages.MessageField('GoogleAppsCloudidentityDevicesV1Device', 1)


class GoogleAppsCloudidentityDevicesV1WipeDeviceUserResponse(_messages.Message):
  r"""Response message for wiping the user's account from the device.

  Fields:
    deviceUser: Resultant DeviceUser object for the action.
  """

  deviceUser = _messages.MessageField('GoogleAppsCloudidentityDevicesV1DeviceUser', 1)


class Group(_messages.Message):
  r"""A group within the Cloud Identity Groups API. A `Group` is a collection
  of entities, where each entity is either a user, another group, or a service
  account.

  Messages:
    LabelsValue: Required. One or more label entries that apply to the Group.
      Currently supported labels contain a key with an empty value. Google
      Groups are the default type of group and have a label with a key of
      `cloudidentity.googleapis.com/groups.discussion_forum` and an empty
      value. Existing Google Groups can have an additional label with a key of
      `cloudidentity.googleapis.com/groups.security` and an empty value added
      to them. **This is an immutable change and the security label cannot be
      removed once added.** Dynamic groups have a label with a key of
      `cloudidentity.googleapis.com/groups.dynamic`. Identity-mapped groups
      for Cloud Search have a label with a key of `system/groups/external` and
      an empty value. Examples:
      {"cloudidentity.googleapis.com/groups.discussion_forum": ""} or
      {"system/groups/external": ""}.

  Fields:
    additionalGroupKeys: Additional entity key aliases for a Group.
    createTime: Output only. The time when the `Group` was created.
    description: An extended description to help users determine the purpose
      of a `Group`. Must not be longer than 4,096 characters.
    displayName: The display name of the `Group`.
    dynamicGroupMetadata: Optional. Dynamic group metadata like queries and
      status.
    groupKey: Required. Immutable. The `EntityKey` of the `Group`.
    labels: Required. One or more label entries that apply to the Group.
      Currently supported labels contain a key with an empty value. Google
      Groups are the default type of group and have a label with a key of
      `cloudidentity.googleapis.com/groups.discussion_forum` and an empty
      value. Existing Google Groups can have an additional label with a key of
      `cloudidentity.googleapis.com/groups.security` and an empty value added
      to them. **This is an immutable change and the security label cannot be
      removed once added.** Dynamic groups have a label with a key of
      `cloudidentity.googleapis.com/groups.dynamic`. Identity-mapped groups
      for Cloud Search have a label with a key of `system/groups/external` and
      an empty value. Examples:
      {"cloudidentity.googleapis.com/groups.discussion_forum": ""} or
      {"system/groups/external": ""}.
    name: Output only. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Group`. Shall be of the form `groups/{group_id}`.
    parent: Required. Immutable. The resource name of the entity under which
      this `Group` resides in the Cloud Identity resource hierarchy. Must be
      of the form `identitysources/{identity_source_id}` for external-
      identity-mapped groups or `customers/{customer_id}` for Google Groups.
    updateTime: Output only. The time when the `Group` was last updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Required. One or more label entries that apply to the Group. Currently
    supported labels contain a key with an empty value. Google Groups are the
    default type of group and have a label with a key of
    `cloudidentity.googleapis.com/groups.discussion_forum` and an empty value.
    Existing Google Groups can have an additional label with a key of
    `cloudidentity.googleapis.com/groups.security` and an empty value added to
    them. **This is an immutable change and the security label cannot be
    removed once added.** Dynamic groups have a label with a key of
    `cloudidentity.googleapis.com/groups.dynamic`. Identity-mapped groups for
    Cloud Search have a label with a key of `system/groups/external` and an
    empty value. Examples:
    {"cloudidentity.googleapis.com/groups.discussion_forum": ""} or
    {"system/groups/external": ""}.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalGroupKeys = _messages.MessageField('EntityKey', 1, repeated=True)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  dynamicGroupMetadata = _messages.MessageField('DynamicGroupMetadata', 5)
  groupKey = _messages.MessageField('EntityKey', 6)
  labels = _messages.MessageField('LabelsValue', 7)
  name = _messages.StringField(8)
  parent = _messages.StringField(9)
  updateTime = _messages.StringField(10)


class GroupRelation(_messages.Message):
  r"""Message representing a transitive group of a user or a group.

  Enums:
    RelationTypeValueValuesEnum: The relation between the member and the
      transitive group.

  Messages:
    LabelsValue: Labels for Group resource.

  Fields:
    displayName: Display name for this group.
    group: Resource name for this group.
    groupKey: Entity key has an id and a namespace. In case of discussion
      forums, the id will be an email address without a namespace.
    labels: Labels for Group resource.
    relationType: The relation between the member and the transitive group.
    roles: Membership roles of the member for the group.
  """

  class RelationTypeValueValuesEnum(_messages.Enum):
    r"""The relation between the member and the transitive group.

    Values:
      RELATION_TYPE_UNSPECIFIED: The relation type is undefined or
        undetermined.
      DIRECT: The two entities have only a direct membership with each other.
      INDIRECT: The two entities have only an indirect membership with each
        other.
      DIRECT_AND_INDIRECT: The two entities have both a direct and an indirect
        membership with each other.
    """
    RELATION_TYPE_UNSPECIFIED = 0
    DIRECT = 1
    INDIRECT = 2
    DIRECT_AND_INDIRECT = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels for Group resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  group = _messages.StringField(2)
  groupKey = _messages.MessageField('EntityKey', 3)
  labels = _messages.MessageField('LabelsValue', 4)
  relationType = _messages.EnumField('RelationTypeValueValuesEnum', 5)
  roles = _messages.MessageField('TransitiveMembershipRole', 6, repeated=True)


class ListClientStatesResponse(_messages.Message):
  r"""Response message that is returned in LRO result of ListClientStates
  Operation.

  Fields:
    clientStates: Client states meeting the list restrictions.
    nextPageToken: Token to retrieve the next page of results. Empty if there
      are no more results.
  """

  clientStates = _messages.MessageField('ClientState', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDeviceUsersResponse(_messages.Message):
  r"""Response message that is returned from the ListDeviceUsers method.

  Fields:
    deviceUsers: Devices meeting the list restrictions.
    nextPageToken: Token to retrieve the next page of results. Empty if there
      are no more results.
  """

  deviceUsers = _messages.MessageField('DeviceUser', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDevicesResponse(_messages.Message):
  r"""Response message that is returned from the ListDevices method.

  Fields:
    devices: Devices meeting the list restrictions.
    nextPageToken: Token to retrieve the next page of results. Empty if there
      are no more results.
  """

  devices = _messages.MessageField('Device', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListGroupsResponse(_messages.Message):
  r"""The response message for GroupsService.ListGroups.

  Fields:
    groups: The `Group`s under the specified `parent`.
    nextPageToken: A continuation token to retrieve the next page of results,
      or empty if there are no more results available.
  """

  groups = _messages.MessageField('Group', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMembershipsResponse(_messages.Message):
  r"""The response message for MembershipsService.ListMemberships.

  Fields:
    memberships: The `Membership`s under the specified `parent`.
    nextPageToken: A continuation token to retrieve the next page of results,
      or empty if there are no more results available.
  """

  memberships = _messages.MessageField('Membership', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class LockDeviceRequest(_messages.Message):
  r"""Request message for locking the device.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
  """

  customer = _messages.StringField(1)


class LookupGroupNameResponse(_messages.Message):
  r"""The response message for GroupsService.LookupGroupName.

  Fields:
    name: Output only. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      looked-up `Group`.
  """

  name = _messages.StringField(1)


class LookupMembershipNameResponse(_messages.Message):
  r"""The response message for MembershipsService.LookupMembershipName.

  Fields:
    name: The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      looked-up `Membership`. Must be of the form
      `groups/{group_id}/memberships/{membership_id}`.
  """

  name = _messages.StringField(1)


class LookupSelfDeviceUsersResponse(_messages.Message):
  r"""Response containing resource names of the DeviceUsers associated with
  the caller's credentials.

  Fields:
    customer: The obfuscated customer Id that may be passed back to other
      Devices API methods such as List, Get, etc.
    names: [Resource
      names](https://cloud.google.com/apis/design/resource_names) of the
      DeviceUsers in the format:
      `devices/{device_id}/deviceUsers/{user_resource_id}`, where device_id is
      the unique ID assigned to a Device and user_resource_id is the unique
      user ID
    nextPageToken: Token to retrieve the next page of results. Empty if there
      are no more results.
  """

  customer = _messages.StringField(1)
  names = _messages.StringField(2, repeated=True)
  nextPageToken = _messages.StringField(3)


class MamDataProtectionSetting(_messages.Message):
  r"""Data protection setting for enforcing data leak restrictions on user's
  device.

  Fields:
    copyPasteProtected: Whether user's data on the device is protected for
      cut/copy/paste.
    obfuscatedCustomerId: Obfuscated customer ID of the user in hex with at
      most 16 chars.
    sharingProtected: Whether the user's data on the device is protected for
      native sharing.
  """

  copyPasteProtected = _messages.BooleanField(1)
  obfuscatedCustomerId = _messages.StringField(2)
  sharingProtected = _messages.BooleanField(3)


class MemberRelation(_messages.Message):
  r"""Message representing a transitive membership of a group.

  Enums:
    RelationTypeValueValuesEnum: The relation between the group and the
      transitive member.

  Fields:
    member: Resource name for this member if member is a GROUP, otherwise it
      is empty.
    preferredMemberKey: Entity key has an id and a namespace. In case of
      discussion forums, the id will be an email address without a namespace.
    relationType: The relation between the group and the transitive member.
    roles: The membership role details (i.e name of role and expiry time).
  """

  class RelationTypeValueValuesEnum(_messages.Enum):
    r"""The relation between the group and the transitive member.

    Values:
      RELATION_TYPE_UNSPECIFIED: The relation type is undefined or
        undetermined.
      DIRECT: The two entities have only a direct membership with each other.
      INDIRECT: The two entities have only an indirect membership with each
        other.
      DIRECT_AND_INDIRECT: The two entities have both a direct and an indirect
        membership with each other.
    """
    RELATION_TYPE_UNSPECIFIED = 0
    DIRECT = 1
    INDIRECT = 2
    DIRECT_AND_INDIRECT = 3

  member = _messages.StringField(1)
  preferredMemberKey = _messages.MessageField('EntityKey', 2, repeated=True)
  relationType = _messages.EnumField('RelationTypeValueValuesEnum', 3)
  roles = _messages.MessageField('TransitiveMembershipRole', 4, repeated=True)


class Membership(_messages.Message):
  r"""A membership within the Cloud Identity Groups API. A `Membership`
  defines a relationship between a `Group` and an entity belonging to that
  `Group`, referred to as a "member".

  Enums:
    TypeValueValuesEnum: Output only. The type of the membership.

  Fields:
    createTime: Output only. The time when the `Membership` was created.
    memberKey: Immutable. The `EntityKey` of the member. Either `member_key`
      or `preferred_member_key` must be set when calling
      MembershipsService.CreateMembership but not both; both shall be set when
      returned.
    name: Output only. The [resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      `Membership`. Shall be of the form
      `groups/{group_id}/memberships/{membership_id}`.
    preferredMemberKey: Required. Immutable. The `EntityKey` of the member.
      Either `member_key` or `preferred_member_key` must be set when calling
      MembershipsService.CreateMembership but not both; both shall be set when
      returned.
    roles: The `MembershipRole`s that apply to the `Membership`. If
      unspecified, defaults to a single `MembershipRole` with `name` `MEMBER`.
      Must not contain duplicate `MembershipRole`s with the same `name`.
    type: Output only. The type of the membership.
    updateTime: Output only. The time when the `Membership` was last updated.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Output only. The type of the membership.

    Values:
      TYPE_UNSPECIFIED: Default. Should not be used.
      USER: Represents user type.
      SERVICE_ACCOUNT: Represents service account type.
      GROUP: Represents group type.
      OTHER: Represents other type.
    """
    TYPE_UNSPECIFIED = 0
    USER = 1
    SERVICE_ACCOUNT = 2
    GROUP = 3
    OTHER = 4

  createTime = _messages.StringField(1)
  memberKey = _messages.MessageField('EntityKey', 2)
  name = _messages.StringField(3)
  preferredMemberKey = _messages.MessageField('EntityKey', 4)
  roles = _messages.MessageField('MembershipRole', 5, repeated=True)
  type = _messages.EnumField('TypeValueValuesEnum', 6)
  updateTime = _messages.StringField(7)


class MembershipAdjacencyList(_messages.Message):
  r"""Membership graph's path information as an adjacency list.

  Fields:
    edges: Each edge contains information about the member that belongs to
      this group. Note: Fields returned here will help identify the specific
      Membership resource (e.g name, preferred_member_key and role), but may
      not be a comprehensive list of all fields.
    group: Resource name of the group that the members belong to.
  """

  edges = _messages.MessageField('Membership', 1, repeated=True)
  group = _messages.StringField(2)


class MembershipRole(_messages.Message):
  r"""A membership role within the Cloud Identity Groups API. A
  `MembershipRole` defines the privileges granted to a `Membership`.

  Fields:
    expiryDetail: The expiry details of the `MembershipRole`. Expiry details
      are only supported for `MEMBER` `MembershipRoles`. May be set if `name`
      is `MEMBER`. Must not be set if `name` is any other value.
    name: The name of the `MembershipRole`. Must be one of `OWNER`, `MANAGER`,
      `MEMBER`.
  """

  expiryDetail = _messages.MessageField('ExpiryDetail', 1)
  name = _messages.StringField(2)


class ModifyMembershipRolesRequest(_messages.Message):
  r"""The request message for MembershipsService.ModifyMembershipRoles.

  Fields:
    addRoles: The `MembershipRole`s to be added. Adding or removing roles in
      the same request as updating roles is not supported. Must not be set if
      `update_roles_params` is set.
    removeRoles: The `name`s of the `MembershipRole`s to be removed. Adding or
      removing roles in the same request as updating roles is not supported.
      It is not possible to remove the `MEMBER` `MembershipRole`. If you wish
      to delete a `Membership`, call MembershipsService.DeleteMembership
      instead. Must not contain `MEMBER`. Must not be set if
      `update_roles_params` is set.
    updateRolesParams: The `MembershipRole`s to be updated. Updating roles in
      the same request as adding or removing roles is not supported. Must not
      be set if either `add_roles` or `remove_roles` is set.
  """

  addRoles = _messages.MessageField('MembershipRole', 1, repeated=True)
  removeRoles = _messages.StringField(2, repeated=True)
  updateRolesParams = _messages.MessageField('UpdateMembershipRolesParams', 3, repeated=True)


class ModifyMembershipRolesResponse(_messages.Message):
  r"""The response message for MembershipsService.ModifyMembershipRoles.

  Fields:
    membership: The `Membership` resource after modifying its
      `MembershipRole`s.
  """

  membership = _messages.MessageField('Membership', 1)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success. If
      the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal response of the operation in case of success. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success. If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class ResetPinRequest(_messages.Message):
  r"""Request message for resetting the pin on the device.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
    pin: Required. New pin number to set for the device.
  """

  customer = _messages.StringField(1)
  pin = _messages.StringField(2)


class RingDeviceRequest(_messages.Message):
  r"""Request message for ringing device.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
  """

  customer = _messages.StringField(1)


class SearchGroupsResponse(_messages.Message):
  r"""The response message for GroupsService.SearchGroups.

  Fields:
    groups: The `Group`s that match the search query.
    nextPageToken: A continuation token to retrieve the next page of results,
      or empty if there are no more results available.
  """

  groups = _messages.MessageField('Group', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class SearchTransitiveGroupsResponse(_messages.Message):
  r"""The response message for MembershipsService.SearchTransitiveGroups.

  Fields:
    memberships: List of transitive groups satisfying the query.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results available for listing.
  """

  memberships = _messages.MessageField('GroupRelation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class SearchTransitiveMembershipsResponse(_messages.Message):
  r"""The response message for MembershipsService.SearchTransitiveMemberships.

  Fields:
    memberships: List of transitive members satisfying the query.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results.
  """

  memberships = _messages.MessageField('MemberRelation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class SignoutDeviceUserRequest(_messages.Message):
  r"""Request message for signing out of the device.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
  """

  customer = _messages.StringField(1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class SyncDeviceUserRequest(_messages.Message):
  r"""Request message for syncing the user's device management policies.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
  """

  customer = _messages.StringField(1)


class TransitiveMembershipRole(_messages.Message):
  r"""Message representing the role of a TransitiveMembership.

  Fields:
    role: TransitiveMembershipRole in string format. Currently supported
      TransitiveMembershipRoles: `"MEMBER"`, `"OWNER"`, and `"MANAGER"`.
  """

  role = _messages.StringField(1)


class UnenrollDeviceUserRequest(_messages.Message):
  r"""Request message to unenroll the user from Advanced Windows Management.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
  """

  customer = _messages.StringField(1)


class UpdateMembershipRolesParams(_messages.Message):
  r"""The details of an update to a `MembershipRole`.

  Fields:
    fieldMask: The fully-qualified names of fields to update. May only contain
      the field `expiry_detail`.
    membershipRole: The `MembershipRole`s to be updated. Only `MEMBER`
      `MembershipRoles` can currently be updated. May only contain a
      `MembershipRole` with `name` `MEMBER`.
  """

  fieldMask = _messages.StringField(1)
  membershipRole = _messages.MessageField('MembershipRole', 2)


class WipeDeviceRequest(_messages.Message):
  r"""Request message for wiping all data on the device.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
  """

  customer = _messages.StringField(1)


class WipeDeviceResponse(_messages.Message):
  r"""Response message for wiping all data on the device.

  Fields:
    device: Resultant Device object for the action. Note that asset tags will
      not be returned in the device object.
  """

  device = _messages.MessageField('Device', 1)


class WipeDeviceUserRequest(_messages.Message):
  r"""Request message for starting an account wipe on device.

  Fields:
    customer: Required. [Resource
      name](https://cloud.google.com/apis/design/resource_names) of the
      customer. If you're using this API for your own organization, use
      `customers/my_customer` If you're using this API to manage another
      organization, use `customers/{customer_id}`, where customer_id is the
      customer to whom the device belongs.
  """

  customer = _messages.StringField(1)


class WipeDeviceUserResponse(_messages.Message):
  r"""Response message for wiping the user's account from the device.

  Fields:
    deviceUser: Resultant DeviceUser object for the action.
  """

  deviceUser = _messages.MessageField('DeviceUser', 1)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
