/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.utils.PortingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultFocusManager;
import javax.swing.JLayeredPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PopupWindow {
    protected EventListenerList listenerList = new EventListenerList();
    private JWindow _delegate;
    private Container _container;
    private List _grabbed = new Vector();
    private List _excluded = new Vector();
    private WindowListener _windowListener;
    private ComponentListener _componentListener;
    private ContainerListener _containerListener;
    private MouseListener _mouseListener;
    private Component _component;
    private KeyEventDispatcher _keyEventDispatcher;
    private Component _parent;

    public PopupWindow(Container container) {
        this._container = container;
        this.createDelegate();
        this.createListeners();
    }

    private void createDelegate() {
        Window window = this.getWindow();
        if (window != null) {
            this._delegate = new JWindow(window);
        }
    }

    public void add(Component component) {
        this._component = component;
        this._component.addPropertyChangeListener("preferredSize", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (PopupWindow.this._delegate != null) {
                    PopupWindow.this._delegate.pack();
                }
            }
        });
        if (this._delegate != null) {
            this._delegate.getContentPane().add(component);
            this._delegate.pack();
            this._delegate.pack();
        }
    }

    public void show(Component relative, int x, int y) {
        this._parent = relative;
        if (this._delegate == null) {
            this.createDelegate();
            if (this._delegate == null) {
                return;
            }
            this.add(this._component);
        }
        Point p = new Point(x, y);
        SwingUtilities.convertPointToScreen(p, relative);
        Rectangle screenSize = PortingUtils.getScreenBounds(relative);
        Dimension size = this._component.getPreferredSize();
        int left = p.x + size.width;
        int bottom = p.y + size.height;
        if (p.x < screenSize.x) {
            p.x = screenSize.x;
        }
        if (left > screenSize.width) {
            p.x = screenSize.width - size.width;
        }
        if (p.y < screenSize.y) {
            p.y = screenSize.y;
        }
        if (bottom > screenSize.height) {
            p.y = screenSize.height - size.height;
        }
        this._delegate.setLocation(p.x, p.y);
        this._delegate.setSize(this._component.getPreferredSize());
        this.firePopupMenuWillBecomeVisible();
        this._delegate.setVisible(true);
        this.grabContainers();
        this._keyEventDispatcher = new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    PopupWindow.this.hide();
                    return true;
                }
                return false;
            }
        };
        DefaultFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this._keyEventDispatcher);
    }

    public void hide() {
        if (this._parent != null) {
            this._parent.requestFocus();
        }
        this.firePopupMenuWillBecomeInvisible();
        if (this._delegate != null) {
            this._delegate.setVisible(false);
        }
        if (this._keyEventDispatcher != null) {
            DefaultFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this._keyEventDispatcher);
            this._keyEventDispatcher = null;
        }
        this.releaseContainers();
        this.disposeDelegate();
    }

    private void createListeners() {
        this._windowListener = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PopupWindow.this.hide();
            }

            public void windowClosed(WindowEvent e) {
                PopupWindow.this.hide();
            }

            public void windowIconified(WindowEvent e) {
                PopupWindow.this.hide();
            }
        };
        this._componentListener = new ComponentListener(){

            public void componentResized(ComponentEvent e) {
                PopupWindow.this.hide();
            }

            public void componentMoved(ComponentEvent e) {
                PopupWindow.this.hide();
            }

            public void componentShown(ComponentEvent e) {
                PopupWindow.this.hide();
            }

            public void componentHidden(ComponentEvent e) {
                PopupWindow.this.hide();
            }
        };
        this._containerListener = new ContainerListener(){

            public void componentAdded(ContainerEvent e) {
                PopupWindow.this.hide();
            }

            public void componentRemoved(ContainerEvent e) {
                PopupWindow.this.hide();
            }
        };
        this._mouseListener = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                PopupWindow.this.hide();
            }
        };
    }

    private void disposeDelegate() {
        if (this._delegate != null) {
            this._delegate.dispose();
            this._delegate = null;
        }
    }

    private Window getWindow() {
        Container c = this._container;
        if (c == null) {
            return null;
        }
        while (!(c instanceof Window) && c.getParent() != null) {
            c = c.getParent();
        }
        if (c instanceof Window) {
            return (Window)c;
        }
        return null;
    }

    private void grabContainers() {
        Container c = this._container;
        while (!(c instanceof Window) && c.getParent() != null) {
            c = c.getParent();
        }
        this.grabContainer(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grabContainer(Container c) {
        if (c instanceof Window) {
            ((Window)c).addWindowListener(this._windowListener);
            c.addComponentListener(this._componentListener);
            this._grabbed.add(c);
        }
        Object object = c.getTreeLock();
        synchronized (object) {
            int ncomponents = c.getComponentCount();
            Component[] component = c.getComponents();
            for (int i = 0; i < ncomponents; ++i) {
                Component comp = component[i];
                if (!comp.isVisible() || this.isExcludedComponent(comp)) continue;
                comp.addMouseListener(this._mouseListener);
                this._grabbed.add(comp);
                if (!(comp instanceof Container)) continue;
                Container cont = (Container)comp;
                if (cont instanceof JLayeredPane) {
                    cont.addContainerListener(this._containerListener);
                }
                this.grabContainer(cont);
            }
        }
    }

    void releaseContainers() {
        for (Object o : this._grabbed) {
            Component c = (Component)o;
            if (c instanceof Window) {
                ((Window)c).removeWindowListener(this._windowListener);
                c.removeComponentListener(this._componentListener);
            } else {
                c.removeMouseListener(this._mouseListener);
            }
            if (!(c instanceof Container) || !(c instanceof JLayeredPane)) continue;
            ((Container)c).removeContainerListener(this._containerListener);
        }
        this._grabbed.clear();
    }

    public boolean isVisible() {
        return this._delegate != null ? this._delegate.isVisible() : false;
    }

    public void addPopupMenuListener(PopupMenuListener l) {
        this.listenerList.add(PopupMenuListener.class, l);
    }

    public void removePopupMenuListener(PopupMenuListener l) {
        this.listenerList.remove(PopupMenuListener.class, l);
    }

    public PopupMenuListener[] getPopupMenuListeners() {
        return (PopupMenuListener[])this.listenerList.getListeners(PopupMenuListener.class);
    }

    public void firePopupMenuWillBecomeVisible() {
        Object[] listeners = this.listenerList.getListenerList();
        PopupMenuEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PopupMenuListener.class) continue;
            if (e == null) {
                e = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)listeners[i + 1]).popupMenuWillBecomeVisible(e);
        }
    }

    public void firePopupMenuWillBecomeInvisible() {
        Object[] listeners = this.listenerList.getListenerList();
        PopupMenuEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PopupMenuListener.class) continue;
            if (e == null) {
                e = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)listeners[i + 1]).popupMenuWillBecomeInvisible(e);
        }
    }

    public void firePopupMenuCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        PopupMenuEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PopupMenuListener.class) continue;
            if (e == null) {
                e = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)listeners[i + 1]).popupMenuCanceled(e);
        }
    }

    public void addAsExcludedComponents(Component comp) {
        if (this._excluded.contains(comp)) {
            return;
        }
        this._excluded.add(comp);
    }

    public void removeFromExcludedComponents(Component comp) {
        if (!this._excluded.contains(comp)) {
            return;
        }
        this._excluded.remove(comp);
    }

    public boolean isExcludedComponent(Component comp) {
        return this._excluded.contains(comp);
    }
}

