/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Aggregate;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class Average
extends Aggregate
implements Callable {
    public int getImplementationMethod() {
        return super.getImplementationMethod() | 0x10;
    }

    public ItemType getItemType(TypeHierarchy th) {
        ItemType base = Atomizer.getAtomizedItemType(this.argument[0], false, th);
        if (base.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            return BuiltInAtomicType.DOUBLE;
        }
        if (base.getPrimitiveType() == 533) {
            return BuiltInAtomicType.DECIMAL;
        }
        return base;
    }

    public int computeCardinality() {
        if (!Cardinality.allowsZero(this.argument[0].getCardinality())) {
            return 16384;
        }
        return super.computeCardinality();
    }

    public AtomicValue evaluateItem(XPathContext context) throws XPathException {
        try {
            return Average.average(this.argument[0].iterate(context), context);
        }
        catch (XPathException err) {
            err.maybeSetContext(context);
            err.maybeSetLocation(this);
            throw err;
        }
    }

    public static AtomicValue average(SequenceIterator iter, XPathContext context) throws XPathException {
        ConversionRules rules = context.getConfiguration().getConversionRules();
        StringConverter toDouble = rules.getStringConverter(BuiltInAtomicType.DOUBLE);
        int count = 0;
        AtomicValue item = (AtomicValue)iter.next();
        if (item == null) {
            return null;
        }
        ++count;
        if (item instanceof UntypedAtomicValue) {
            item = toDouble.convert(item).asAtomic();
        }
        if (item instanceof NumericValue) {
            AtomicValue next;
            do {
                if ((next = (AtomicValue)iter.next()) == null) {
                    return ArithmeticExpression.compute(item, 3, new Int64Value(count), context);
                }
                ++count;
                if (next instanceof UntypedAtomicValue) {
                    next = toDouble.convert(next).asAtomic();
                    continue;
                }
                if (next instanceof NumericValue) continue;
                throw new XPathException("Input to avg() contains a mix of numeric and non-numeric values", "FORG0006");
            } while (!(item = ArithmeticExpression.compute(item, 0, next, context)).isNaN() || !(item instanceof DoubleValue));
            return item;
        }
        if (item instanceof DurationValue) {
            while (true) {
                AtomicValue next;
                if ((next = (AtomicValue)iter.next()) == null) {
                    return ((DurationValue)item).multiply(1.0 / (double)count);
                }
                ++count;
                if (!(next instanceof DurationValue)) {
                    throw new XPathException("Input to avg() contains a mix of duration and non-duration values", "FORG0006");
                }
                item = ((DurationValue)item).add((DurationValue)next);
            }
        }
        throw new XPathException("Input to avg() contains a value that is neither numeric, nor a duration", "FORG0006");
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        try {
            return Average.average(arguments[0].iterate(), context);
        }
        catch (XPathException err) {
            err.maybeSetContext(context);
            err.maybeSetLocation(this);
            throw err;
        }
    }
}

