/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.StringValue;

public class GenerateId
extends SystemFunctionCall {
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.useContextItemAsDefault(visitor);
        return this.simplifyArguments(visitor);
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p & 0xFFBFFFFF;
    }

    public StringValue evaluateItem(XPathContext c) throws XPathException {
        NodeInfo node = (NodeInfo)this.argument[0].evaluateItem(c);
        return GenerateId.generateId(node);
    }

    public static StringValue generateId(NodeInfo node) {
        if (node == null) {
            return StringValue.EMPTY_STRING;
        }
        FastStringBuffer buffer = new FastStringBuffer(16);
        node.generateId(buffer);
        buffer.condense();
        return new StringValue(buffer);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        NodeInfo node = arguments.length == 0 ? this.getContextNode(context) : (NodeInfo)arguments[0].head();
        return GenerateId.generateId(node);
    }
}

