/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.ssh;

import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Locale;
import org.apache.ivy.plugins.repository.AbstractRepository;
import org.apache.ivy.plugins.repository.ssh.SshCache;
import org.apache.ivy.util.Credentials;
import org.apache.ivy.util.CredentialsUtil;
import org.apache.ivy.util.Message;

public abstract class AbstractSshBasedRepository
extends AbstractRepository {
    private File keyFile = null;
    private File passFile = null;
    private String userPassword = null;
    private String keyFilePassword = null;
    private String user = null;
    private String host = null;
    private int port = -1;
    private static HashMap credentialsCache = new HashMap();
    private static final int MAX_CREDENTILAS_CACHE_SIZE = 100;

    protected Session getSession(String string) throws IOException {
        Object object;
        URI uRI = this.parseURI(string);
        String string2 = this.getHost();
        int n = this.getPort();
        Object object2 = this.getUser();
        String string3 = this.getUserPassword();
        if (uRI != null && uRI.getScheme() != null) {
            if (uRI.getHost() != null) {
                string2 = uRI.getHost();
            }
            if (uRI.getPort() != -1) {
                n = uRI.getPort();
            }
            if (uRI.getUserInfo() != null) {
                object = uRI.getUserInfo();
                if (((String)object).indexOf(":") == -1) {
                    object2 = object;
                } else {
                    object2 = ((String)object).substring(0, ((String)object).indexOf(":"));
                    string3 = ((String)object).substring(((String)object).indexOf(":") + 1);
                }
            }
        }
        if (string2 == null) {
            throw new IllegalArgumentException("missing host information. host should be provided either directly on the repository or in the connection URI");
        }
        if (object2 == null) {
            object = this.requestCredentials(string2);
            if (object != null) {
                object2 = ((Credentials)object).getUserName();
                string3 = ((Credentials)object).getPasswd();
            } else {
                Message.error("username is not set");
            }
        }
        return SshCache.getInstance().getSession(string2, n, (String)object2, string3, this.getKeyFile(), this.getKeyFilePassword(), this.getPassFile());
    }

    private URI parseURI(String string) {
        try {
            URI uRI = new URI(string);
            if (uRI.getScheme() != null && !uRI.getScheme().toLowerCase(Locale.US).equals(this.getRepositoryScheme().toLowerCase(Locale.US))) {
                throw new URISyntaxException(string, "Wrong scheme in URI. Expected " + this.getRepositoryScheme() + " as scheme!");
            }
            if (uRI.getHost() == null && this.getHost() == null) {
                throw new URISyntaxException(string, "Missing host in URI or in resolver");
            }
            if (uRI.getPath() == null) {
                throw new URISyntaxException(string, "Missing path in URI");
            }
            return uRI;
        }
        catch (URISyntaxException uRISyntaxException) {
            Message.error(uRISyntaxException.getMessage());
            Message.error("The uri '" + string + "' is in the wrong format.");
            Message.error("Please use " + this.getRepositoryScheme() + "://user:pass@hostname/path/to/repository");
            return null;
        }
    }

    private Credentials requestCredentials(String string) {
        Object v = credentialsCache.get(string);
        if (v == null) {
            Credentials credentials = CredentialsUtil.promptCredentials(new Credentials(null, string, this.user, this.userPassword), this.getPassFile());
            if (credentials != null) {
                if (credentialsCache.size() > 100) {
                    credentialsCache.clear();
                }
                credentialsCache.put(string, credentials);
            }
            return credentials;
        }
        return (Credentials)v;
    }

    protected void releaseSession(Session session, String string) {
        session.disconnect();
        SshCache.getInstance().clearSession(session);
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setKeyFile(File file) {
        this.keyFile = file;
        if (!this.keyFile.exists()) {
            Message.warn("Pemfile " + this.keyFile.getAbsolutePath() + " doesn't exist.");
            this.keyFile = null;
        } else if (!this.keyFile.canRead()) {
            Message.warn("Pemfile " + this.keyFile.getAbsolutePath() + " not readable.");
            this.keyFile = null;
        } else {
            Message.debug("Using " + this.keyFile.getAbsolutePath() + " as keyfile.");
        }
    }

    public File getKeyFile() {
        return this.keyFile;
    }

    public void setUserPassword(String string) {
        this.userPassword = string;
    }

    public String getKeyFilePassword() {
        return this.keyFilePassword;
    }

    public void setKeyFilePassword(String string) {
        this.keyFilePassword = string;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setPassFile(File file) {
        this.passFile = file;
    }

    public File getPassFile() {
        return this.passFile;
    }

    protected abstract String getRepositoryScheme();
}

