/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.AbstractRefactoringCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.AddModifySequenceDialog;

public class ModifySequenceCommand
extends AbstractRefactoringCommand {
    private static final ILogger s_log = LoggerController.createLogger(ModifySequenceCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ModifySequenceCommand.class);
    protected AddModifySequenceDialog customDialog;

    public ModifySequenceCommand(ISession session, IDatabaseObjectInfo[] info) {
        super(session, info);
    }

    @Override
    protected void onExecute() throws SQLException {
        this.showCustomDialog();
    }

    @Override
    protected String[] generateSQLStatements() throws UserCancelledOperationException {
        DatabaseObjectQualifier qualifier = new DatabaseObjectQualifier(this._info[0].getCatalogName(), this._info[0].getSchemaName());
        String[] result = this._dialect.getAlterSequenceSQL(this.customDialog.getSequenceName(), this.customDialog.getIncrement(), this.customDialog.getMinimum(), this.customDialog.getMaximum(), this.customDialog.getStart(), this.customDialog.getCache(), this.customDialog.isCycled(), qualifier, this._sqlPrefs);
        return result;
    }

    @Override
    protected void executeScript(String script) {
        AbstractRefactoringCommand.CommandExecHandler handler = new AbstractRefactoringCommand.CommandExecHandler(this._session);
        SQLExecuterTask executer = new SQLExecuterTask(this._session, script, (ISQLExecuterHandler)handler);
        executer.run();
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ModifySequenceCommand.this.customDialog.setVisible(false);
                        ModifySequenceCommand.this.customDialog.dispose();
                        ModifySequenceCommand.this._session.getSchemaInfo().reload(ModifySequenceCommand.this._info[0]);
                    }
                });
            }
        });
    }

    @Override
    protected boolean isRefactoringSupportedForDialect(HibernateDialect dialect) {
        return dialect.supportsAlterSequence();
    }

    private void showCustomDialog() throws SQLException {
        this.customDialog = this.createCustomDialog();
        this.customDialog.addExecuteListener(new AbstractRefactoringCommand.ExecuteListener());
        this.customDialog.addEditSQLListener(new AbstractRefactoringCommand.EditSQLListener(this.customDialog));
        this.customDialog.addShowSQLListener(new AbstractRefactoringCommand.ShowSQLListener(i18n.SHOWSQL_DIALOG_TITLE, this.customDialog));
        this.customDialog.setLocationRelativeTo(SessionUtils.getOwningFrame((ISession)this._session));
        this.customDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddModifySequenceDialog createCustomDialog() throws SQLException {
        AddModifySequenceDialog result;
        block4: {
            ResultSet rs = null;
            result = null;
            String simpleName = this._info[0].getSimpleName();
            DatabaseObjectQualifier qualifier = new DatabaseObjectQualifier(this._info[0].getCatalogName(), this._info[0].getSchemaName());
            String sql = this._dialect.getSequenceInformationSQL(simpleName, qualifier, this._sqlPrefs);
            try {
                rs = this.executeQuery(sql, simpleName);
                if (rs.next()) {
                    String last_value = rs.getString(1);
                    String max_value = rs.getString(2);
                    String min_value = rs.getString(3);
                    String cache_value = rs.getString(4);
                    String increment_by = rs.getString(5);
                    int cycleInt = rs.getInt(6);
                    boolean is_cyled = cycleInt == 1;
                    result = new AddModifySequenceDialog(1, simpleName, last_value, increment_by, min_value, max_value, cache_value, is_cyled, SessionUtils.getOwningFrame((ISession)this._session));
                    break block4;
                }
                throw new IllegalStateException("createCustomDialog: failed to find sequence named : " + simpleName);
            }
            finally {
                SQLUtilities.closeResultSet((ResultSet)rs, (boolean)true);
            }
        }
        return result;
    }

    private ResultSet executeQuery(String sql, String sequenceName) throws SQLException {
        ResultSet result = null;
        if (sql.endsWith("?") || sql.endsWith("?)")) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("ModifySequenceCommand: running sql=" + sql));
                s_log.debug((Object)("param sequenceName = " + sequenceName));
            }
            PreparedStatement stmt = this._session.getSQLConnection().prepareStatement(sql);
            stmt.setString(1, sequenceName);
            result = stmt.executeQuery();
        } else {
            s_log.debug((Object)("ModifySequenceCommand: running sql=" + sql));
            Statement stmt = this._session.getSQLConnection().createStatement();
            result = stmt.executeQuery(sql);
        }
        return result;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String SHOWSQL_DIALOG_TITLE = ModifySequenceCommand.access$000().getString("ModifySequenceCommand.sqlDialogTitle");
        public static final String SQL_DIALOG_TITLE = ModifySequenceCommand.access$000().getString("ModifySequenceCommand.sqlDialogTitle");
        public static final String SQL_ERROR_SEQUENCE_DATA = ModifySequenceCommand.access$000().getString("ModifySequenceCommand.sqlErrorNoSequenceData");
    }
}

