/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.dnd;

import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import net.sourceforge.squirrel_sql.client.gui.dnd.DropedFileExtractor;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class FileEditorDropTargetListener
extends DropTargetAdapter
implements DropTargetListener {
    static final ILogger s_log = LoggerController.createLogger(DropedFileExtractor.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DropedFileExtractor.class);
    private ISession _session;

    public FileEditorDropTargetListener(ISession session) {
        this._session = session;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            File fileToOpen = DropedFileExtractor.getFile(dtde, this._session.getApplication());
            if (fileToOpen != null) {
                if (s_log.isInfoEnabled()) {
                    s_log.info("drop: path=" + fileToOpen.getAbsolutePath());
                }
                ISQLPanelAPI api = this._session.getSQLPanelAPIOfActiveSessionWindow();
                api.fileOpen(fileToOpen);
            }
        }
        catch (Exception e) {
            s_log.error("drop: Unexpected exception " + e.getMessage(), e);
        }
    }
}

